/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.socket;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apache.zeppelin.socket.NotebookSocketListener;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;

public class NotebookSocket
extends WebSocketAdapter {
    private Session connection;
    private NotebookSocketListener listener;
    private HttpServletRequest request;
    private String protocol;

    public NotebookSocket(HttpServletRequest req, String protocol, NotebookSocketListener listener) {
        this.listener = listener;
        this.request = req;
        this.protocol = protocol;
    }

    public void onWebSocketClose(int closeCode, String message) {
        this.listener.onClose(this, closeCode, message);
    }

    public void onWebSocketConnect(Session connection) {
        this.connection = connection;
        this.listener.onOpen(this);
    }

    public void onWebSocketText(String message) {
        this.listener.onMessage(this, message);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public synchronized void send(String serializeMessage) throws IOException {
        this.connection.getRemote().sendString(serializeMessage);
    }
}

