/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.utils;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.text.IniRealm;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.zeppelin.conf.ZeppelinConfiguration;

public class SecurityUtils {
    public static void initSecurityManager(String shiroPath) {
        IniSecurityManagerFactory factory = new IniSecurityManagerFactory("file:" + shiroPath);
        SecurityManager securityManager = (SecurityManager)factory.getInstance();
        org.apache.shiro.SecurityUtils.setSecurityManager((SecurityManager)securityManager);
    }

    public static Boolean isValidOrigin(String sourceHost, ZeppelinConfiguration conf) throws UnknownHostException, URISyntaxException {
        if (sourceHost == null || sourceHost.isEmpty()) {
            return false;
        }
        String sourceUriHost = new URI(sourceHost).getHost();
        sourceUriHost = sourceUriHost == null ? "" : sourceUriHost.toLowerCase();
        sourceUriHost = sourceUriHost.toLowerCase();
        String currentHost = InetAddress.getLocalHost().getHostName().toLowerCase();
        return conf.getAllowedOrigins().contains("*") || currentHost.equals(sourceUriHost) || "localhost".equals(sourceUriHost) || conf.getAllowedOrigins().contains(sourceHost);
    }

    public static String getPrincipal() {
        Subject subject = org.apache.shiro.SecurityUtils.getSubject();
        String principal = subject.isAuthenticated() ? subject.getPrincipal().toString() : "anonymous";
        return principal;
    }

    public static Collection getRealmsList() {
        String key = ThreadContext.SECURITY_MANAGER_KEY;
        DefaultWebSecurityManager defaultWebSecurityManager = (DefaultWebSecurityManager)ThreadContext.get((Object)key);
        Collection realms = defaultWebSecurityManager.getRealms();
        return realms;
    }

    public static HashSet<String> getRoles() {
        Subject subject = org.apache.shiro.SecurityUtils.getSubject();
        HashSet<String> roles = new HashSet<String>();
        Map allRoles = null;
        if (subject.isAuthenticated()) {
            Collection realmsList = SecurityUtils.getRealmsList();
            for (Realm realm : realmsList) {
                String name = realm.getName();
                if (!name.equals("iniRealm")) continue;
                allRoles = ((IniRealm)realm).getIni().get((Object)"roles");
                break;
            }
            if (allRoles != null) {
                for (Map.Entry pair : allRoles.entrySet()) {
                    if (!subject.hasRole((String)pair.getKey())) continue;
                    roles.add((String)pair.getKey());
                }
            }
        }
        return roles;
    }
}

