/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.NotebookAuthorization;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.rest.exception.BadRequestException;
import org.apache.zeppelin.rest.exception.ForbiddenException;
import org.apache.zeppelin.rest.exception.NotFoundException;
import org.apache.zeppelin.rest.message.CronRequest;
import org.apache.zeppelin.rest.message.NewNoteRequest;
import org.apache.zeppelin.rest.message.NewParagraphRequest;
import org.apache.zeppelin.rest.message.RunParagraphWithParametersRequest;
import org.apache.zeppelin.search.SearchService;
import org.apache.zeppelin.server.JsonResponse;
import org.apache.zeppelin.socket.NotebookServer;
import org.apache.zeppelin.types.InterpreterSettingsList;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.utils.InterpreterBindingUtils;
import org.apache.zeppelin.utils.SecurityUtils;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/notebook")
@Produces(value={"application/json"})
public class NotebookRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(NotebookRestApi.class);
    Gson gson = new Gson();
    private Notebook notebook;
    private NotebookServer notebookServer;
    private SearchService noteSearchService;
    private NotebookAuthorization notebookAuthorization;

    public NotebookRestApi() {
    }

    public NotebookRestApi(Notebook notebook, NotebookServer notebookServer, SearchService search) {
        this.notebook = notebook;
        this.notebookServer = notebookServer;
        this.noteSearchService = search;
        this.notebookAuthorization = notebook.getNotebookAuthorization();
    }

    @GET
    @Path(value="{noteId}/permissions")
    @ZeppelinApi
    public Response getNotePermissions(@PathParam(value="noteId") String noteId) throws IOException {
        this.checkIfUserIsAnon(this.getBlockNotAuthenticatedUserErrorMsg());
        this.checkIfUserCanRead(noteId, "Insufficient privileges you cannot get the list of permissions for this note");
        HashMap<String, Set> permissionsMap = new HashMap<String, Set>();
        permissionsMap.put("owners", this.notebookAuthorization.getOwners(noteId));
        permissionsMap.put("readers", this.notebookAuthorization.getReaders(noteId));
        permissionsMap.put("writers", this.notebookAuthorization.getWriters(noteId));
        return new JsonResponse(Response.Status.OK, "", permissionsMap).build();
    }

    private String ownerPermissionError(Set<String> current, Set<String> allowed) throws IOException {
        LOG.info("Cannot change permissions. Connection owners {}. Allowed owners {}", (Object)current.toString(), (Object)allowed.toString());
        return "Insufficient privileges to change permissions.\n\nAllowed owners: " + allowed.toString() + "\n\nUser belongs to: " + current.toString();
    }

    private String getBlockNotAuthenticatedUserErrorMsg() throws IOException {
        return "Only authenticated user can set the permission.";
    }

    private void checkIfUserIsAnon(String errorMsg) {
        boolean isAuthenticated = SecurityUtils.isAuthenticated();
        if (isAuthenticated && SecurityUtils.getPrincipal().equals("anonymous")) {
            LOG.info("Anonymous user cannot set any permissions for this note.");
            throw new ForbiddenException(errorMsg);
        }
    }

    private void checkIfUserIsOwner(String noteId, String errorMsg) {
        HashSet userAndRoles = Sets.newHashSet();
        userAndRoles.add(SecurityUtils.getPrincipal());
        userAndRoles.addAll(SecurityUtils.getRoles());
        if (!this.notebookAuthorization.isOwner((Set)userAndRoles, noteId)) {
            throw new ForbiddenException(errorMsg);
        }
    }

    private void checkIfUserCanWrite(String noteId, String errorMsg) {
        HashSet userAndRoles = Sets.newHashSet();
        userAndRoles.add(SecurityUtils.getPrincipal());
        userAndRoles.addAll(SecurityUtils.getRoles());
        if (!this.notebookAuthorization.hasWriteAuthorization((Set)userAndRoles, noteId)) {
            throw new ForbiddenException(errorMsg);
        }
    }

    private void checkIfUserCanRead(String noteId, String errorMsg) {
        HashSet userAndRoles = Sets.newHashSet();
        userAndRoles.add(SecurityUtils.getPrincipal());
        userAndRoles.addAll(SecurityUtils.getRoles());
        if (!this.notebookAuthorization.hasReadAuthorization((Set)userAndRoles, noteId)) {
            throw new ForbiddenException(errorMsg);
        }
    }

    private void checkIfNoteIsNotNull(Note note) {
        if (note == null) {
            throw new NotFoundException("note not found");
        }
    }

    private void checkIfParagraphIsNotNull(Paragraph paragraph) {
        if (paragraph == null) {
            throw new NotFoundException("paragraph not found");
        }
    }

    @PUT
    @Path(value="{noteId}/permissions")
    @ZeppelinApi
    public Response putNotePermissions(@PathParam(value="noteId") String noteId, String req) throws IOException {
        String principal = SecurityUtils.getPrincipal();
        HashSet<String> roles = SecurityUtils.getRoles();
        HashSet<String> userAndRoles = new HashSet<String>();
        userAndRoles.add(principal);
        userAndRoles.addAll(roles);
        this.checkIfUserIsAnon(this.getBlockNotAuthenticatedUserErrorMsg());
        this.checkIfUserIsOwner(noteId, this.ownerPermissionError(userAndRoles, this.notebookAuthorization.getOwners(noteId)));
        HashMap permMap = (HashMap)this.gson.fromJson(req, new TypeToken<HashMap<String, HashSet<String>>>(){}.getType());
        Note note = this.notebook.getNote(noteId);
        LOG.info("Set permissions {} {} {} {} {}", new Object[]{noteId, principal, permMap.get("owners"), permMap.get("readers"), permMap.get("writers")});
        HashSet readers = (HashSet)permMap.get("readers");
        HashSet owners = (HashSet)permMap.get("owners");
        HashSet writers = (HashSet)permMap.get("writers");
        if (readers != null && !readers.isEmpty()) {
            if (writers.isEmpty()) {
                writers = Sets.newHashSet((Object[])new String[]{SecurityUtils.getPrincipal()});
            }
            if (owners.isEmpty()) {
                owners = Sets.newHashSet((Object[])new String[]{SecurityUtils.getPrincipal()});
            }
        }
        if (writers != null && !writers.isEmpty() && owners.isEmpty()) {
            owners = Sets.newHashSet((Object[])new String[]{SecurityUtils.getPrincipal()});
        }
        this.notebookAuthorization.setReaders(noteId, (Set)readers);
        this.notebookAuthorization.setWriters(noteId, (Set)writers);
        this.notebookAuthorization.setOwners(noteId, (Set)owners);
        LOG.debug("After set permissions {} {} {}", new Object[]{this.notebookAuthorization.getOwners(noteId), this.notebookAuthorization.getReaders(noteId), this.notebookAuthorization.getWriters(noteId)});
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        note.persist(subject);
        this.notebookServer.broadcastNote(note);
        this.notebookServer.broadcastNoteList(subject, userAndRoles);
        return new JsonResponse(Response.Status.OK).build();
    }

    @PUT
    @Path(value="interpreter/bind/{noteId}")
    @ZeppelinApi
    public Response bind(@PathParam(value="noteId") String noteId, String req) throws IOException {
        this.checkIfUserCanWrite(noteId, "Insufficient privileges you cannot bind any interpreters to this note");
        List settingIdList = (List)this.gson.fromJson(req, new TypeToken<List<String>>(){}.getType());
        this.notebook.bindInterpretersToNote(SecurityUtils.getPrincipal(), noteId, settingIdList);
        return new JsonResponse(Response.Status.OK).build();
    }

    @GET
    @Path(value="interpreter/bind/{noteId}")
    @ZeppelinApi
    public Response bind(@PathParam(value="noteId") String noteId) {
        this.checkIfUserCanRead(noteId, "Insufficient privileges you cannot get any interpreters settings");
        List<InterpreterSettingsList> settingList = InterpreterBindingUtils.getInterpreterBindings(this.notebook, noteId);
        this.notebookServer.broadcastInterpreterBindings(noteId, settingList);
        return new JsonResponse<List<InterpreterSettingsList>>(Response.Status.OK, "", settingList).build();
    }

    @GET
    @Path(value="/")
    @ZeppelinApi
    public Response getNoteList() throws IOException {
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        HashSet<String> userAndRoles = SecurityUtils.getRoles();
        userAndRoles.add(subject.getUser());
        List<Map<String, String>> notesInfo = this.notebookServer.generateNotesInfo(false, subject, userAndRoles);
        return new JsonResponse<List<Map<String, String>>>(Response.Status.OK, "", notesInfo).build();
    }

    @GET
    @Path(value="{noteId}")
    @ZeppelinApi
    public Response getNote(@PathParam(value="noteId") String noteId) throws IOException {
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanRead(noteId, "Insufficient privileges you cannot get this note");
        return new JsonResponse<Note>(Response.Status.OK, "", note).build();
    }

    @GET
    @Path(value="export/{noteId}")
    @ZeppelinApi
    public Response exportNote(@PathParam(value="noteId") String noteId) throws IOException {
        this.checkIfUserCanRead(noteId, "Insufficient privileges you cannot export this note");
        String exportJson = this.notebook.exportNote(noteId);
        return new JsonResponse<String>(Response.Status.OK, "", exportJson).build();
    }

    @POST
    @Path(value="import")
    @ZeppelinApi
    public Response importNote(String req) throws IOException {
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        Note newNote = this.notebook.importNote(req, null, subject);
        return new JsonResponse<String>(Response.Status.CREATED, "", newNote.getId()).build();
    }

    @POST
    @Path(value="/")
    @ZeppelinApi
    public Response createNote(String message) throws IOException {
        LOG.info("Create new note by JSON {}", (Object)message);
        NewNoteRequest request = (NewNoteRequest)this.gson.fromJson(message, NewNoteRequest.class);
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        Note note = this.notebook.createNote(subject);
        List<NewParagraphRequest> initialParagraphs = request.getParagraphs();
        if (initialParagraphs != null) {
            for (NewParagraphRequest paragraphRequest : initialParagraphs) {
                Paragraph p = note.addParagraph(subject);
                p.setTitle(paragraphRequest.getTitle());
                p.setText(paragraphRequest.getText());
            }
        }
        note.addParagraph(subject);
        String noteName = request.getName();
        if (noteName.isEmpty()) {
            noteName = "Note " + note.getId();
        }
        note.setName(noteName);
        note.persist(subject);
        this.notebookServer.broadcastNote(note);
        this.notebookServer.broadcastNoteList(subject, SecurityUtils.getRoles());
        return new JsonResponse<String>(Response.Status.CREATED, "", note.getId()).build();
    }

    @DELETE
    @Path(value="{noteId}")
    @ZeppelinApi
    public Response deleteNote(@PathParam(value="noteId") String noteId) throws IOException {
        Note note;
        LOG.info("Delete note {} ", (Object)noteId);
        this.checkIfUserIsOwner(noteId, "Insufficient privileges you cannot delete this note");
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        if (!noteId.isEmpty() && (note = this.notebook.getNote(noteId)) != null) {
            this.notebook.removeNote(noteId, subject);
        }
        this.notebookServer.broadcastNoteList(subject, SecurityUtils.getRoles());
        return new JsonResponse<String>(Response.Status.OK, "").build();
    }

    @POST
    @Path(value="{noteId}")
    @ZeppelinApi
    public Response cloneNote(@PathParam(value="noteId") String noteId, String message) throws IOException, CloneNotSupportedException, IllegalArgumentException {
        LOG.info("clone note by JSON {}", (Object)message);
        this.checkIfUserCanWrite(noteId, "Insufficient privileges you cannot clone this note");
        NewNoteRequest request = (NewNoteRequest)this.gson.fromJson(message, NewNoteRequest.class);
        String newNoteName = null;
        if (request != null) {
            newNoteName = request.getName();
        }
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        Note newNote = this.notebook.cloneNote(noteId, newNoteName, subject);
        this.notebookServer.broadcastNote(newNote);
        this.notebookServer.broadcastNoteList(subject, SecurityUtils.getRoles());
        return new JsonResponse<String>(Response.Status.CREATED, "", newNote.getId()).build();
    }

    @POST
    @Path(value="{noteId}/paragraph")
    @ZeppelinApi
    public Response insertParagraph(@PathParam(value="noteId") String noteId, String message) throws IOException {
        LOG.info("insert paragraph {} {}", (Object)noteId, (Object)message);
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanWrite(noteId, "Insufficient privileges you cannot add paragraph to this note");
        NewParagraphRequest request = (NewParagraphRequest)this.gson.fromJson(message, NewParagraphRequest.class);
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        Double indexDouble = request.getIndex();
        Paragraph p = indexDouble == null ? note.addParagraph(subject) : note.insertParagraph(indexDouble.intValue(), subject);
        p.setTitle(request.getTitle());
        p.setText(request.getText());
        note.persist(subject);
        this.notebookServer.broadcastNote(note);
        return new JsonResponse<String>(Response.Status.CREATED, "", p.getId()).build();
    }

    @GET
    @Path(value="{noteId}/paragraph/{paragraphId}")
    @ZeppelinApi
    public Response getParagraph(@PathParam(value="noteId") String noteId, @PathParam(value="paragraphId") String paragraphId) throws IOException {
        LOG.info("get paragraph {} {}", (Object)noteId, (Object)paragraphId);
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanRead(noteId, "Insufficient privileges you cannot get this paragraph");
        Paragraph p = note.getParagraph(paragraphId);
        this.checkIfParagraphIsNotNull(p);
        return new JsonResponse<Paragraph>(Response.Status.OK, "", p).build();
    }

    @PUT
    @Path(value="{noteId}/paragraph/{paragraphId}/config")
    @ZeppelinApi
    public Response updateParagraphConfig(@PathParam(value="noteId") String noteId, @PathParam(value="paragraphId") String paragraphId, String message) throws IOException {
        String user = SecurityUtils.getPrincipal();
        LOG.info("{} will update paragraph config {} {}", new Object[]{user, noteId, paragraphId});
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanWrite(noteId, "Insufficient privileges you cannot update this paragraph config");
        Paragraph p = note.getParagraph(paragraphId);
        this.checkIfParagraphIsNotNull(p);
        Map newConfig = (Map)this.gson.fromJson(message, HashMap.class);
        if (newConfig == null || newConfig.isEmpty()) {
            LOG.warn("{} is trying to update paragraph {} of note {} with empty config", new Object[]{user, paragraphId, noteId});
            throw new BadRequestException("paragraph config cannot be empty");
        }
        Map origConfig = p.getConfig();
        for (String key : newConfig.keySet()) {
            origConfig.put(key, newConfig.get(key));
        }
        p.setConfig(origConfig);
        AuthenticationInfo subject = new AuthenticationInfo(user);
        note.persist(subject);
        return new JsonResponse<Paragraph>(Response.Status.OK, "", p).build();
    }

    @POST
    @Path(value="{noteId}/paragraph/{paragraphId}/move/{newIndex}")
    @ZeppelinApi
    public Response moveParagraph(@PathParam(value="noteId") String noteId, @PathParam(value="paragraphId") String paragraphId, @PathParam(value="newIndex") String newIndex) throws IOException {
        LOG.info("move paragraph {} {} {}", new Object[]{noteId, paragraphId, newIndex});
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanWrite(noteId, "Insufficient privileges you cannot move paragraph");
        Paragraph p = note.getParagraph(paragraphId);
        this.checkIfParagraphIsNotNull(p);
        try {
            note.moveParagraph(paragraphId, Integer.parseInt(newIndex), true);
            AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
            note.persist(subject);
            this.notebookServer.broadcastNote(note);
            return new JsonResponse<String>(Response.Status.OK, "").build();
        }
        catch (IndexOutOfBoundsException e) {
            LOG.error("Exception in NotebookRestApi while moveParagraph ", (Throwable)e);
            return new JsonResponse<String>(Response.Status.BAD_REQUEST, "paragraph's new index is out of bound").build();
        }
    }

    @DELETE
    @Path(value="{noteId}/paragraph/{paragraphId}")
    @ZeppelinApi
    public Response deleteParagraph(@PathParam(value="noteId") String noteId, @PathParam(value="paragraphId") String paragraphId) throws IOException {
        LOG.info("delete paragraph {} {}", (Object)noteId, (Object)paragraphId);
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanRead(noteId, "Insufficient privileges you cannot remove paragraph from this note");
        Paragraph p = note.getParagraph(paragraphId);
        this.checkIfParagraphIsNotNull(p);
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        note.removeParagraph(SecurityUtils.getPrincipal(), paragraphId);
        note.persist(subject);
        this.notebookServer.broadcastNote(note);
        return new JsonResponse<String>(Response.Status.OK, "").build();
    }

    @PUT
    @Path(value="{noteId}/clear")
    @ZeppelinApi
    public Response clearAllParagraphOutput(@PathParam(value="noteId") String noteId) throws IOException {
        LOG.info("clear all paragraph output of note {}", (Object)noteId);
        this.checkIfUserCanWrite(noteId, "Insufficient privileges you cannot clear this note");
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        note.clearAllParagraphOutput();
        return new JsonResponse<String>(Response.Status.OK, "").build();
    }

    @POST
    @Path(value="job/{noteId}")
    @ZeppelinApi
    public Response runNoteJobs(@PathParam(value="noteId") String noteId) throws IOException, IllegalArgumentException {
        LOG.info("run note jobs {} ", (Object)noteId);
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanWrite(noteId, "Insufficient privileges you cannot run job for this note");
        try {
            note.runAll();
        }
        catch (Exception ex) {
            LOG.error("Exception from run", (Throwable)ex);
            return new JsonResponse<String>(Response.Status.PRECONDITION_FAILED, ex.getMessage() + "- Not selected or Invalid Interpreter bind").build();
        }
        return new JsonResponse(Response.Status.OK).build();
    }

    @DELETE
    @Path(value="job/{noteId}")
    @ZeppelinApi
    public Response stopNoteJobs(@PathParam(value="noteId") String noteId) throws IOException, IllegalArgumentException {
        LOG.info("stop note jobs {} ", (Object)noteId);
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanWrite(noteId, "Insufficient privileges you cannot stop this job for this note");
        for (Paragraph p : note.getParagraphs()) {
            if (p.isTerminated()) continue;
            p.abort();
        }
        return new JsonResponse(Response.Status.OK).build();
    }

    @GET
    @Path(value="job/{noteId}")
    @ZeppelinApi
    public Response getNoteJobStatus(@PathParam(value="noteId") String noteId) throws IOException, IllegalArgumentException {
        LOG.info("get note job status.");
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanRead(noteId, "Insufficient privileges you cannot get job status");
        return new JsonResponse<List>(Response.Status.OK, null, note.generateParagraphsInfo()).build();
    }

    @GET
    @Path(value="job/{noteId}/{paragraphId}")
    @ZeppelinApi
    public Response getNoteParagraphJobStatus(@PathParam(value="noteId") String noteId, @PathParam(value="paragraphId") String paragraphId) throws IOException, IllegalArgumentException {
        LOG.info("get note paragraph job status.");
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanRead(noteId, "Insufficient privileges you cannot get job status");
        Paragraph paragraph = note.getParagraph(paragraphId);
        this.checkIfParagraphIsNotNull(paragraph);
        return new JsonResponse<Map>(Response.Status.OK, null, note.generateSingleParagraphInfo(paragraphId)).build();
    }

    @POST
    @Path(value="job/{noteId}/{paragraphId}")
    @ZeppelinApi
    public Response runParagraph(@PathParam(value="noteId") String noteId, @PathParam(value="paragraphId") String paragraphId, String message) throws IOException, IllegalArgumentException {
        LOG.info("run paragraph job asynchronously {} {} {}", new Object[]{noteId, paragraphId, message});
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanWrite(noteId, "Insufficient privileges you cannot run job for this note");
        Paragraph paragraph = note.getParagraph(paragraphId);
        this.checkIfParagraphIsNotNull(paragraph);
        this.handleParagraphParams(message, note, paragraph);
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        paragraph.setAuthenticationInfo(subject);
        note.persist(subject);
        note.run(paragraph.getId());
        return new JsonResponse(Response.Status.OK).build();
    }

    @POST
    @Path(value="run/{noteId}/{paragraphId}")
    @ZeppelinApi
    public Response runParagraphSynchronously(@PathParam(value="noteId") String noteId, @PathParam(value="paragraphId") String paragraphId, String message) throws IOException, IllegalArgumentException {
        LOG.info("run paragraph synchronously {} {} {}", new Object[]{noteId, paragraphId, message});
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanWrite(noteId, "Insufficient privileges you cannot run paragraph");
        Paragraph paragraph = note.getParagraph(paragraphId);
        this.checkIfParagraphIsNotNull(paragraph);
        this.handleParagraphParams(message, note, paragraph);
        if (paragraph.getListener() == null) {
            note.initializeJobListenerForParagraph(paragraph);
        }
        paragraph.run();
        InterpreterResult result = paragraph.getResult();
        if (result.code() == InterpreterResult.Code.SUCCESS) {
            return new JsonResponse<InterpreterResult>(Response.Status.OK, result).build();
        }
        return new JsonResponse<InterpreterResult>(Response.Status.INTERNAL_SERVER_ERROR, result).build();
    }

    @DELETE
    @Path(value="job/{noteId}/{paragraphId}")
    @ZeppelinApi
    public Response stopParagraph(@PathParam(value="noteId") String noteId, @PathParam(value="paragraphId") String paragraphId) throws IOException, IllegalArgumentException {
        LOG.info("stop paragraph job {} ", (Object)noteId);
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanWrite(noteId, "Insufficient privileges you cannot stop paragraph");
        Paragraph p = note.getParagraph(paragraphId);
        this.checkIfParagraphIsNotNull(p);
        p.abort();
        return new JsonResponse(Response.Status.OK).build();
    }

    @POST
    @Path(value="cron/{noteId}")
    @ZeppelinApi
    public Response registerCronJob(@PathParam(value="noteId") String noteId, String message) throws IOException, IllegalArgumentException {
        LOG.info("Register cron job note={} request cron msg={}", (Object)noteId, (Object)message);
        CronRequest request = (CronRequest)this.gson.fromJson(message, CronRequest.class);
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanWrite(noteId, "Insufficient privileges you cannot set a cron job for this note");
        if (!CronExpression.isValidExpression((String)request.getCronString())) {
            return new JsonResponse<String>(Response.Status.BAD_REQUEST, "wrong cron expressions.").build();
        }
        Map config = note.getConfig();
        config.put("cron", request.getCronString());
        note.setConfig(config);
        this.notebook.refreshCron(note.getId());
        return new JsonResponse(Response.Status.OK).build();
    }

    @DELETE
    @Path(value="cron/{noteId}")
    @ZeppelinApi
    public Response removeCronJob(@PathParam(value="noteId") String noteId) throws IOException, IllegalArgumentException {
        LOG.info("Remove cron job note {}", (Object)noteId);
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserIsOwner(noteId, "Insufficient privileges you cannot remove this cron job from this note");
        Map config = note.getConfig();
        config.put("cron", null);
        note.setConfig(config);
        this.notebook.refreshCron(note.getId());
        return new JsonResponse(Response.Status.OK).build();
    }

    @GET
    @Path(value="cron/{noteId}")
    @ZeppelinApi
    public Response getCronJob(@PathParam(value="noteId") String noteId) throws IOException, IllegalArgumentException {
        LOG.info("Get cron job note {}", (Object)noteId);
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanRead(noteId, "Insufficient privileges you cannot get cron information");
        return new JsonResponse(Response.Status.OK, note.getConfig().get("cron")).build();
    }

    @GET
    @Path(value="jobmanager/")
    @ZeppelinApi
    public Response getJobListforNote() throws IOException, IllegalArgumentException {
        LOG.info("Get note jobs for job manager");
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        List noteJobs = this.notebook.getJobListByUnixTime(false, 0L, subject);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("lastResponseUnixTime", System.currentTimeMillis());
        response.put("jobs", noteJobs);
        return new JsonResponse(Response.Status.OK, response).build();
    }

    @GET
    @Path(value="jobmanager/{lastUpdateUnixtime}/")
    @ZeppelinApi
    public Response getUpdatedJobListforNote(@PathParam(value="lastUpdateUnixtime") long lastUpdateUnixTime) throws IOException, IllegalArgumentException {
        LOG.info("Get updated note jobs lastUpdateTime {}", (Object)lastUpdateUnixTime);
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        List noteJobs = this.notebook.getJobListByUnixTime(false, lastUpdateUnixTime, subject);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("lastResponseUnixTime", System.currentTimeMillis());
        response.put("jobs", noteJobs);
        return new JsonResponse(Response.Status.OK, response).build();
    }

    @GET
    @Path(value="search")
    @ZeppelinApi
    public Response search(@QueryParam(value="q") String queryTerm) {
        LOG.info("Searching notes for: {}", (Object)queryTerm);
        String principal = SecurityUtils.getPrincipal();
        HashSet<String> roles = SecurityUtils.getRoles();
        HashSet<String> userAndRoles = new HashSet<String>();
        userAndRoles.add(principal);
        userAndRoles.addAll(roles);
        List notesFound = this.noteSearchService.query(queryTerm);
        for (int i = 0; i < notesFound.size(); ++i) {
            String[] Id = ((String)((Map)notesFound.get(i)).get("id")).split("/", 2);
            String noteId = Id[0];
            if (this.notebookAuthorization.isOwner(noteId, userAndRoles) || this.notebookAuthorization.isReader(noteId, userAndRoles) || this.notebookAuthorization.isWriter(noteId, userAndRoles)) continue;
            notesFound.remove(i);
            --i;
        }
        LOG.info("{} notes found", (Object)notesFound.size());
        return new JsonResponse<List>(Response.Status.OK, notesFound).build();
    }

    private void handleParagraphParams(String message, Note note, Paragraph paragraph) throws IOException {
        RunParagraphWithParametersRequest request;
        Map<String, Object> paramsForUpdating;
        if (!StringUtils.isEmpty((CharSequence)message) && (paramsForUpdating = (request = (RunParagraphWithParametersRequest)this.gson.fromJson(message, RunParagraphWithParametersRequest.class)).getParams()) != null) {
            paragraph.settings.getParams().putAll(paramsForUpdating);
            AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
            note.persist(subject);
        }
    }
}

