/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.socket;

import com.google.common.base.Strings;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.AngularObjectRegistryListener;
import org.apache.zeppelin.helium.ApplicationEventListener;
import org.apache.zeppelin.helium.HeliumPackage;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContextRunner;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.remote.RemoteAngularObjectRegistry;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.notebook.Folder;
import org.apache.zeppelin.notebook.JobListenerFactory;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.NotebookAuthorization;
import org.apache.zeppelin.notebook.NotebookEventListener;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.ParagraphJobListener;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.notebook.socket.Message;
import org.apache.zeppelin.notebook.socket.WatcherMessage;
import org.apache.zeppelin.rest.exception.ForbiddenException;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.server.ZeppelinServer;
import org.apache.zeppelin.socket.NotebookSocket;
import org.apache.zeppelin.socket.NotebookSocketListener;
import org.apache.zeppelin.socket.NotebookWebSocketCreator;
import org.apache.zeppelin.ticket.TicketContainer;
import org.apache.zeppelin.types.InterpreterSettingsList;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.util.WatcherSecurityKey;
import org.apache.zeppelin.utils.InterpreterBindingUtils;
import org.apache.zeppelin.utils.SecurityUtils;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotebookServer
extends WebSocketServlet
implements NotebookSocketListener,
JobListenerFactory,
AngularObjectRegistryListener,
RemoteInterpreterProcessListener,
ApplicationEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(NotebookServer.class);
    Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();
    final Map<String, List<NotebookSocket>> noteSocketMap = new HashMap<String, List<NotebookSocket>>();
    final Queue<NotebookSocket> connectedSockets = new ConcurrentLinkedQueue<NotebookSocket>();
    final Map<String, Queue<NotebookSocket>> userConnectedSockets = new ConcurrentHashMap<String, Queue<NotebookSocket>>();
    final Queue<NotebookSocket> watcherSockets = Queues.newConcurrentLinkedQueue();

    private Notebook notebook() {
        return ZeppelinServer.notebook;
    }

    public void configure(WebSocketServletFactory factory) {
        factory.setCreator((WebSocketCreator)new NotebookWebSocketCreator(this));
    }

    public boolean checkOrigin(HttpServletRequest request, String origin) {
        try {
            return SecurityUtils.isValidOrigin(origin, ZeppelinConfiguration.create());
        }
        catch (UnknownHostException e) {
            LOG.error(e.toString(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOG.error(e.toString(), (Throwable)e);
        }
        return false;
    }

    public NotebookSocket doWebSocketConnect(HttpServletRequest req, String protocol) {
        return new NotebookSocket(req, protocol, this);
    }

    @Override
    public void onOpen(NotebookSocket conn) {
        LOG.info("New connection from {} : {}", (Object)conn.getRequest().getRemoteAddr(), (Object)conn.getRequest().getRemotePort());
        this.connectedSockets.add(conn);
    }

    @Override
    public void onMessage(NotebookSocket conn, String msg) {
        Notebook notebook = this.notebook();
        try {
            HashSet roles;
            String ticket;
            Message messagereceived = this.deserializeMessage(msg);
            LOG.debug("RECEIVE << " + messagereceived.op);
            LOG.debug("RECEIVE PRINCIPAL << " + messagereceived.principal);
            LOG.debug("RECEIVE TICKET << " + messagereceived.ticket);
            LOG.debug("RECEIVE ROLES << " + messagereceived.roles);
            if (LOG.isTraceEnabled()) {
                LOG.trace("RECEIVE MSG = " + messagereceived);
            }
            if (!((ticket = TicketContainer.instance.getTicket(messagereceived.principal)) == null || messagereceived.ticket != null && ticket.equals(messagereceived.ticket))) {
                if (StringUtils.isEmpty((String)messagereceived.ticket)) {
                    LOG.debug("{} message: invalid ticket {} != {}", new Object[]{messagereceived.op, messagereceived.ticket, ticket});
                } else if (!messagereceived.op.equals((Object)Message.OP.PING)) {
                    conn.send(this.serializeMessage(new Message(Message.OP.SESSION_LOGOUT).put("info", (Object)"Your ticket is invalid possibly due to server restart. Please login again.")));
                }
                return;
            }
            ZeppelinConfiguration conf = ZeppelinConfiguration.create();
            boolean allowAnonymous = conf.isAnonymousAllowed();
            if (!allowAnonymous && messagereceived.principal.equals("anonymous")) {
                throw new Exception("Anonymous access not allowed ");
            }
            HashSet<String> userAndRoles = new HashSet<String>();
            userAndRoles.add(messagereceived.principal);
            if (!messagereceived.roles.equals("") && (roles = (HashSet)this.gson.fromJson(messagereceived.roles, new TypeToken<HashSet<String>>(){}.getType())) != null) {
                userAndRoles.addAll(roles);
            }
            if (StringUtils.isEmpty((String)conn.getUser())) {
                this.addUserConnection(messagereceived.principal, conn);
            }
            AuthenticationInfo subject = new AuthenticationInfo(messagereceived.principal, messagereceived.ticket);
            switch (messagereceived.op) {
                case LIST_NOTES: {
                    this.unicastNoteList(conn, subject, userAndRoles);
                    break;
                }
                case RELOAD_NOTES_FROM_REPO: {
                    this.broadcastReloadedNoteList(subject, userAndRoles);
                    break;
                }
                case GET_HOME_NOTE: {
                    this.sendHomeNote(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case GET_NOTE: {
                    this.sendNote(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case NEW_NOTE: {
                    this.createNote(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case DEL_NOTE: {
                    this.removeNote(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case REMOVE_FOLDER: {
                    this.removeFolder(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case MOVE_NOTE_TO_TRASH: {
                    this.moveNoteToTrash(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case MOVE_FOLDER_TO_TRASH: {
                    this.moveFolderToTrash(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case EMPTY_TRASH: {
                    this.emptyTrash(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case RESTORE_FOLDER: {
                    this.restoreFolder(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case RESTORE_NOTE: {
                    this.restoreNote(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case RESTORE_ALL: {
                    this.restoreAll(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case CLONE_NOTE: {
                    this.cloneNote(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case IMPORT_NOTE: {
                    this.importNote(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case COMMIT_PARAGRAPH: {
                    this.updateParagraph(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case RUN_PARAGRAPH: {
                    this.runParagraph(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case RUN_ALL_PARAGRAPHS: {
                    this.runAllParagraphs(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case CANCEL_PARAGRAPH: {
                    this.cancelParagraph(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case MOVE_PARAGRAPH: {
                    this.moveParagraph(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case INSERT_PARAGRAPH: {
                    this.insertParagraph(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case COPY_PARAGRAPH: {
                    this.copyParagraph(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case PARAGRAPH_REMOVE: {
                    this.removeParagraph(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case PARAGRAPH_CLEAR_OUTPUT: {
                    this.clearParagraphOutput(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case PARAGRAPH_CLEAR_ALL_OUTPUT: {
                    this.clearAllParagraphOutput(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case NOTE_UPDATE: {
                    this.updateNote(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case NOTE_RENAME: {
                    this.renameNote(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case FOLDER_RENAME: {
                    this.renameFolder(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case UPDATE_PERSONALIZED_MODE: {
                    this.updatePersonalizedMode(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case COMPLETION: {
                    this.completion(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case PING: {
                    break;
                }
                case ANGULAR_OBJECT_UPDATED: {
                    this.angularObjectUpdated(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case ANGULAR_OBJECT_CLIENT_BIND: {
                    this.angularObjectClientBind(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case ANGULAR_OBJECT_CLIENT_UNBIND: {
                    this.angularObjectClientUnbind(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case LIST_CONFIGURATIONS: {
                    this.sendAllConfigurations(conn, userAndRoles, notebook);
                    break;
                }
                case CHECKPOINT_NOTE: {
                    this.checkpointNote(conn, notebook, messagereceived);
                    break;
                }
                case LIST_REVISION_HISTORY: {
                    this.listRevisionHistory(conn, notebook, messagereceived);
                    break;
                }
                case SET_NOTE_REVISION: {
                    this.setNoteRevision(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case NOTE_REVISION: {
                    this.getNoteByRevision(conn, notebook, messagereceived);
                    break;
                }
                case LIST_NOTE_JOBS: {
                    this.unicastNoteJobInfo(conn, messagereceived);
                    break;
                }
                case UNSUBSCRIBE_UPDATE_NOTE_JOBS: {
                    this.unsubscribeNoteJobInfo(conn);
                    break;
                }
                case GET_INTERPRETER_BINDINGS: {
                    this.getInterpreterBindings(conn, messagereceived);
                    break;
                }
                case SAVE_INTERPRETER_BINDINGS: {
                    this.saveInterpreterBindings(conn, messagereceived);
                    break;
                }
                case EDITOR_SETTING: {
                    this.getEditorSetting(conn, messagereceived);
                    break;
                }
                case GET_INTERPRETER_SETTINGS: {
                    this.getInterpreterSettings(conn, subject);
                    break;
                }
                case WATCHER: {
                    this.switchConnectionToWatcher(conn, messagereceived);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.error("Can't handle message", (Throwable)e);
        }
    }

    @Override
    public void onClose(NotebookSocket conn, int code, String reason) {
        LOG.info("Closed connection to {} : {}. ({}) {}", new Object[]{conn.getRequest().getRemoteAddr(), conn.getRequest().getRemotePort(), code, reason});
        this.removeConnectionFromAllNote(conn);
        this.connectedSockets.remove((Object)conn);
        this.removeUserConnection(conn.getUser(), conn);
    }

    private void removeUserConnection(String user, NotebookSocket conn) {
        if (this.userConnectedSockets.containsKey(user)) {
            this.userConnectedSockets.get(user).remove((Object)conn);
        } else {
            LOG.warn("Closing connection that is absent in user connections");
        }
    }

    private void addUserConnection(String user, NotebookSocket conn) {
        conn.setUser(user);
        if (this.userConnectedSockets.containsKey(user)) {
            this.userConnectedSockets.get(user).add(conn);
        } else {
            ConcurrentLinkedQueue<NotebookSocket> socketQueue = new ConcurrentLinkedQueue<NotebookSocket>();
            socketQueue.add(conn);
            this.userConnectedSockets.put(user, socketQueue);
        }
    }

    protected Message deserializeMessage(String msg) {
        return (Message)this.gson.fromJson(msg, Message.class);
    }

    protected String serializeMessage(Message m) {
        return this.gson.toJson((Object)m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConnectionToNote(String noteId, NotebookSocket socket) {
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            this.removeConnectionFromAllNote(socket);
            List<NotebookSocket> socketList = this.noteSocketMap.get(noteId);
            if (socketList == null) {
                socketList = new LinkedList<NotebookSocket>();
                this.noteSocketMap.put(noteId, socketList);
            }
            if (!socketList.contains((Object)socket)) {
                socketList.add(socket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnectionFromNote(String noteId, NotebookSocket socket) {
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            List<NotebookSocket> socketList = this.noteSocketMap.get(noteId);
            if (socketList != null) {
                socketList.remove((Object)socket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNote(String noteId) {
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            List<NotebookSocket> list = this.noteSocketMap.remove(noteId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnectionFromAllNote(NotebookSocket socket) {
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            Set<String> keys = this.noteSocketMap.keySet();
            for (String noteId : keys) {
                this.removeConnectionFromNote(noteId, socket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOpenNoteId(NotebookSocket socket) {
        String id = null;
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            Set<String> keys = this.noteSocketMap.keySet();
            for (String noteId : keys) {
                List<NotebookSocket> sockets = this.noteSocketMap.get(noteId);
                if (!sockets.contains((Object)socket)) continue;
                id = noteId;
            }
        }
        return id;
    }

    private void broadcastToNoteBindedInterpreter(String interpreterGroupId, Message m) {
        Notebook notebook = this.notebook();
        List notes = notebook.getAllNotes();
        for (Note note : notes) {
            List ids = notebook.getInterpreterSettingManager().getInterpreters(note.getId());
            for (String id : ids) {
                if (!id.equals(interpreterGroupId)) continue;
                this.broadcast(note.getId(), m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcast(String noteId, Message m) {
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            this.broadcastToWatchers(noteId, "", m);
            List<NotebookSocket> socketLists = this.noteSocketMap.get(noteId);
            if (socketLists == null || socketLists.size() == 0) {
                return;
            }
            LOG.debug("SEND >> " + m.op);
            for (NotebookSocket conn : socketLists) {
                try {
                    conn.send(this.serializeMessage(m));
                }
                catch (IOException e) {
                    LOG.error("socket error", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastExcept(String noteId, Message m, NotebookSocket exclude) {
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            this.broadcastToWatchers(noteId, "", m);
            List<NotebookSocket> socketLists = this.noteSocketMap.get(noteId);
            if (socketLists == null || socketLists.size() == 0) {
                return;
            }
            LOG.debug("SEND >> " + m.op);
            for (NotebookSocket conn : socketLists) {
                if (((Object)((Object)exclude)).equals((Object)conn)) continue;
                try {
                    conn.send(this.serializeMessage(m));
                }
                catch (IOException e) {
                    LOG.error("socket error", (Throwable)e);
                }
            }
        }
    }

    private void multicastToUser(String user, Message m) {
        if (!this.userConnectedSockets.containsKey(user)) {
            LOG.warn("Multicasting to user {} that is not in connections map", (Object)user);
            return;
        }
        for (NotebookSocket conn : this.userConnectedSockets.get(user)) {
            this.unicast(m, conn);
        }
    }

    private void unicast(Message m, NotebookSocket conn) {
        try {
            conn.send(this.serializeMessage(m));
        }
        catch (IOException e) {
            LOG.error("socket error", (Throwable)e);
        }
        this.broadcastToWatchers("", "", m);
    }

    public void unicastNoteJobInfo(NotebookSocket conn, Message fromMessage) throws IOException {
        this.addConnectionToNote(JOB_MANAGER_SERVICE.JOB_MANAGER_PAGE.getKey(), conn);
        AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
        List noteJobs = this.notebook().getJobListByUnixTime(false, 0L, subject);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("lastResponseUnixTime", System.currentTimeMillis());
        response.put("jobs", noteJobs);
        conn.send(this.serializeMessage(new Message(Message.OP.LIST_NOTE_JOBS).put("noteJobs", response)));
    }

    public void broadcastUpdateNoteJobInfo(long lastUpdateUnixTime) throws IOException {
        LinkedList noteJobs = new LinkedList();
        Notebook notebookObject = this.notebook();
        List jobNotes = null;
        if (notebookObject != null) {
            jobNotes = this.notebook().getJobListByUnixTime(false, lastUpdateUnixTime, null);
            noteJobs = jobNotes == null ? noteJobs : jobNotes;
        }
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        response.put("lastResponseUnixTime", Long.valueOf(System.currentTimeMillis()));
        response.put("jobs", noteJobs != null ? noteJobs : new LinkedList());
        this.broadcast(JOB_MANAGER_SERVICE.JOB_MANAGER_PAGE.getKey(), new Message(Message.OP.LIST_UPDATE_NOTE_JOBS).put("noteRunningJobs", response));
    }

    public void unsubscribeNoteJobInfo(NotebookSocket conn) {
        this.removeConnectionFromNote(JOB_MANAGER_SERVICE.JOB_MANAGER_PAGE.getKey(), conn);
    }

    public void saveInterpreterBindings(NotebookSocket conn, Message fromMessage) {
        String noteId = (String)fromMessage.data.get("noteId");
        try {
            List settingIdList = (List)this.gson.fromJson(String.valueOf(fromMessage.data.get("selectedSettingIds")), new TypeToken<ArrayList<String>>(){}.getType());
            AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
            this.notebook().bindInterpretersToNote(subject.getUser(), noteId, settingIdList);
            this.broadcastInterpreterBindings(noteId, InterpreterBindingUtils.getInterpreterBindings(this.notebook(), noteId));
        }
        catch (Exception e) {
            LOG.error("Error while saving interpreter bindings", (Throwable)e);
        }
    }

    public void getInterpreterBindings(NotebookSocket conn, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.data.get("noteId");
        List<InterpreterSettingsList> settingList = InterpreterBindingUtils.getInterpreterBindings(this.notebook(), noteId);
        conn.send(this.serializeMessage(new Message(Message.OP.INTERPRETER_BINDINGS).put("interpreterBindings", settingList)));
    }

    public List<Map<String, String>> generateNotesInfo(boolean needsReload, AuthenticationInfo subject, Set<String> userAndRoles) {
        Notebook notebook = this.notebook();
        ZeppelinConfiguration conf = notebook.getConf();
        String homescreenNoteId = conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_HOMESCREEN);
        boolean hideHomeScreenNotebookFromList = conf.getBoolean(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_HOMESCREEN_HIDE);
        if (needsReload) {
            try {
                notebook.reloadAllNotes(subject);
            }
            catch (IOException e) {
                LOG.error("Fail to reload notes from repository", (Throwable)e);
            }
        }
        List notes = notebook.getAllNotes(userAndRoles);
        LinkedList<Map<String, String>> notesInfo = new LinkedList<Map<String, String>>();
        for (Note note : notes) {
            HashMap<String, String> info = new HashMap<String, String>();
            if (hideHomeScreenNotebookFromList && note.getId().equals(homescreenNoteId)) continue;
            info.put("id", note.getId());
            info.put("name", note.getName());
            notesInfo.add(info);
        }
        return notesInfo;
    }

    public void broadcastNote(Note note) {
        this.broadcast(note.getId(), new Message(Message.OP.NOTE).put("note", (Object)note));
    }

    public void broadcastInterpreterBindings(String noteId, List settingList) {
        this.broadcast(noteId, new Message(Message.OP.INTERPRETER_BINDINGS).put("interpreterBindings", (Object)settingList));
    }

    public void broadcastParagraph(Note note, Paragraph p) {
        if (note.isPersonalizedMode()) {
            this.broadcastParagraphs(p.getUserParagraphMap());
        } else {
            this.broadcast(note.getId(), new Message(Message.OP.PARAGRAPH).put("paragraph", (Object)p));
        }
    }

    public void broadcastParagraphs(Map<String, Paragraph> userParagraphMap) {
        if (null != userParagraphMap) {
            for (String user : userParagraphMap.keySet()) {
                this.multicastToUser(user, new Message(Message.OP.PARAGRAPH).put("paragraph", (Object)userParagraphMap.get(user)));
            }
        }
    }

    private void broadcastNewParagraph(Note note, Paragraph para) {
        LOG.info("Broadcasting paragraph on run call instead of note.");
        int paraIndex = note.getParagraphs().indexOf(para);
        this.broadcast(note.getId(), new Message(Message.OP.PARAGRAPH_ADDED).put("paragraph", (Object)para).put("index", (Object)paraIndex));
    }

    public void broadcastNoteList(AuthenticationInfo subject, HashSet userAndRoles) {
        if (subject == null) {
            subject = new AuthenticationInfo("");
        }
        List<Map<String, String>> notesInfo = this.generateNotesInfo(false, subject, userAndRoles);
        this.multicastToUser(subject.getUser(), new Message(Message.OP.NOTES_INFO).put("notes", notesInfo));
        this.broadcastNoteListExcept(notesInfo, subject);
    }

    public void unicastNoteList(NotebookSocket conn, AuthenticationInfo subject, HashSet<String> userAndRoles) {
        List<Map<String, String>> notesInfo = this.generateNotesInfo(false, subject, userAndRoles);
        this.unicast(new Message(Message.OP.NOTES_INFO).put("notes", notesInfo), conn);
    }

    public void broadcastReloadedNoteList(AuthenticationInfo subject, HashSet userAndRoles) {
        if (subject == null) {
            subject = new AuthenticationInfo("");
        }
        List<Map<String, String>> notesInfo = this.generateNotesInfo(true, subject, userAndRoles);
        this.multicastToUser(subject.getUser(), new Message(Message.OP.NOTES_INFO).put("notes", notesInfo));
        this.broadcastNoteListExcept(notesInfo, subject);
    }

    private void broadcastNoteListExcept(List<Map<String, String>> notesInfo, AuthenticationInfo subject) {
        NotebookAuthorization authInfo = NotebookAuthorization.getInstance();
        for (String user : this.userConnectedSockets.keySet()) {
            if (subject.getUser().equals(user)) continue;
            Set userAndRoles = authInfo.getRoles(user);
            userAndRoles.add(user);
            notesInfo = this.generateNotesInfo(false, new AuthenticationInfo(user), userAndRoles);
            this.multicastToUser(user, new Message(Message.OP.NOTES_INFO).put("notes", notesInfo));
        }
    }

    void permissionError(NotebookSocket conn, String op, String userName, Set<String> userAndRoles, Set<String> allowed) throws IOException {
        LOG.info("Cannot {}. Connection readers {}. Allowed readers {}", new Object[]{op, userAndRoles, allowed});
        conn.send(this.serializeMessage(new Message(Message.OP.AUTH_INFO).put("info", (Object)("Insufficient privileges to " + op + " note.\n\nAllowed users or roles: " + allowed.toString() + "\n\nBut the user " + userName + " belongs to: " + userAndRoles.toString()))));
    }

    private void sendNote(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        LOG.info("New operation from {} : {} : {} : {} : {}", new Object[]{conn.getRequest().getRemoteAddr(), conn.getRequest().getRemotePort(), fromMessage.principal, fromMessage.op, fromMessage.get("id")});
        String noteId = (String)fromMessage.get("id");
        if (noteId == null) {
            return;
        }
        String user = fromMessage.principal;
        Note note = notebook.getNote(noteId);
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        if (note != null) {
            if (!notebookAuthorization.isReader(noteId, userAndRoles)) {
                this.permissionError(conn, "read", fromMessage.principal, userAndRoles, notebookAuthorization.getReaders(noteId));
                return;
            }
            this.addConnectionToNote(note.getId(), conn);
            if (note.isPersonalizedMode()) {
                note = note.getUserNote(user);
            }
            conn.send(this.serializeMessage(new Message(Message.OP.NOTE).put("note", (Object)note)));
            this.sendAllAngularObjects(note, user, conn);
        } else {
            conn.send(this.serializeMessage(new Message(Message.OP.NOTE).put("note", null)));
        }
    }

    private void sendHomeNote(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        String noteId = notebook.getConf().getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_HOMESCREEN);
        String user = fromMessage.principal;
        Note note = null;
        if (noteId != null) {
            note = notebook.getNote(noteId);
        }
        if (note != null) {
            NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
            if (!notebookAuthorization.isReader(noteId, userAndRoles)) {
                this.permissionError(conn, "read", fromMessage.principal, userAndRoles, notebookAuthorization.getReaders(noteId));
                return;
            }
            this.addConnectionToNote(note.getId(), conn);
            conn.send(this.serializeMessage(new Message(Message.OP.NOTE).put("note", (Object)note)));
            this.sendAllAngularObjects(note, user, conn);
        } else {
            this.removeConnectionFromAllNote(conn);
            conn.send(this.serializeMessage(new Message(Message.OP.NOTE).put("note", null)));
        }
    }

    private void updateNote(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws SchedulerException, IOException {
        String noteId = (String)fromMessage.get("id");
        String name = (String)fromMessage.get("name");
        Map config = (Map)fromMessage.get("config");
        if (noteId == null) {
            return;
        }
        if (config == null) {
            return;
        }
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        if (!notebookAuthorization.isWriter(noteId, userAndRoles)) {
            this.permissionError(conn, "update", fromMessage.principal, userAndRoles, notebookAuthorization.getWriters(noteId));
            return;
        }
        Note note = notebook.getNote(noteId);
        if (note != null) {
            boolean cronUpdated = this.isCronUpdated(config, note.getConfig());
            note.setName(name);
            note.setConfig(config);
            if (cronUpdated) {
                notebook.refreshCron(note.getId());
            }
            AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
            note.persist(subject);
            this.broadcast(note.getId(), new Message(Message.OP.NOTE_UPDATED).put("name", (Object)name).put("config", (Object)config).put("info", (Object)note.getInfo()));
            this.broadcastNoteList(subject, userAndRoles);
        }
    }

    private void updatePersonalizedMode(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws SchedulerException, IOException {
        boolean isPersonalized;
        String noteId = (String)fromMessage.get("id");
        String personalized = (String)fromMessage.get("personalized");
        boolean bl = isPersonalized = personalized.equals("true");
        if (noteId == null) {
            return;
        }
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        if (!notebookAuthorization.isOwner(noteId, userAndRoles)) {
            this.permissionError(conn, "persoanlized ", fromMessage.principal, userAndRoles, notebookAuthorization.getOwners(noteId));
            return;
        }
        Note note = notebook.getNote(noteId);
        if (note != null) {
            note.setPersonalizedMode(Boolean.valueOf(isPersonalized));
            AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
            note.persist(subject);
            this.broadcastNote(note);
        }
    }

    private void renameNote(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws SchedulerException, IOException {
        this.renameNote(conn, userAndRoles, notebook, fromMessage, "rename");
    }

    private void renameNote(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage, String op) throws SchedulerException, IOException {
        String noteId = (String)fromMessage.get("id");
        String name = (String)fromMessage.get("name");
        if (noteId == null) {
            return;
        }
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        if (!notebookAuthorization.isOwner(noteId, userAndRoles)) {
            this.permissionError(conn, "rename", fromMessage.principal, userAndRoles, notebookAuthorization.getOwners(noteId));
            return;
        }
        Note note = notebook.getNote(noteId);
        if (note != null) {
            note.setName(name);
            AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
            note.persist(subject);
            this.broadcastNote(note);
            this.broadcastNoteList(subject, userAndRoles);
        }
    }

    private void renameFolder(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws SchedulerException, IOException {
        this.renameFolder(conn, userAndRoles, notebook, fromMessage, "rename");
    }

    private void renameFolder(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage, String op) throws SchedulerException, IOException {
        String oldFolderId = (String)fromMessage.get("id");
        String newFolderId = (String)fromMessage.get("name");
        if (oldFolderId == null) {
            return;
        }
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        for (Note note : notebook.getNotesUnderFolder(oldFolderId)) {
            String noteId = note.getId();
            if (notebookAuthorization.isOwner(noteId, userAndRoles)) continue;
            this.permissionError(conn, op + " folder of '" + note.getName() + "'", fromMessage.principal, userAndRoles, notebookAuthorization.getOwners(noteId));
            return;
        }
        Folder oldFolder = notebook.renameFolder(oldFolderId, newFolderId);
        if (oldFolder != null) {
            AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
            List renamedNotes = oldFolder.getNotesRecursively();
            for (Note note : renamedNotes) {
                note.persist(subject);
                this.broadcastNote(note);
            }
            this.broadcastNoteList(subject, userAndRoles);
        }
    }

    private boolean isCronUpdated(Map<String, Object> configA, Map<String, Object> configB) {
        boolean cronUpdated = false;
        if (configA.get("cron") != null && configB.get("cron") != null && configA.get("cron").equals(configB.get("cron"))) {
            cronUpdated = true;
        } else if (configA.get("cron") == null && configB.get("cron") == null) {
            cronUpdated = false;
        } else if (configA.get("cron") != null || configB.get("cron") != null) {
            cronUpdated = true;
        }
        return cronUpdated;
    }

    private void createNote(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message message) throws IOException {
        AuthenticationInfo subject = new AuthenticationInfo(message.principal);
        try {
            Note note = null;
            String defaultInterpreterId = (String)message.get("defaultInterpreterId");
            if (!StringUtils.isEmpty((String)defaultInterpreterId)) {
                LinkedList<String> interpreterSettingIds = new LinkedList<String>();
                interpreterSettingIds.add(defaultInterpreterId);
                for (String interpreterSettingId : notebook.getInterpreterSettingManager().getDefaultInterpreterSettingList()) {
                    if (interpreterSettingId.equals(defaultInterpreterId)) continue;
                    interpreterSettingIds.add(interpreterSettingId);
                }
                note = notebook.createNote(interpreterSettingIds, subject);
            } else {
                note = notebook.createNote(subject);
            }
            note.addParagraph(subject);
            if (message != null) {
                String noteName = (String)message.get("name");
                if (StringUtils.isEmpty((String)noteName)) {
                    noteName = "Note " + note.getId();
                }
                note.setName(noteName);
            }
            note.persist(subject);
            this.addConnectionToNote(note.getId(), conn);
            conn.send(this.serializeMessage(new Message(Message.OP.NEW_NOTE).put("note", (Object)note)));
        }
        catch (FileSystemException e) {
            LOG.error("Exception from createNote", (Throwable)e);
            conn.send(this.serializeMessage(new Message(Message.OP.ERROR_INFO).put("info", (Object)"Oops! There is something wrong with the notebook file system. Please check the logs for more details.")));
            return;
        }
        this.broadcastNoteList(subject, userAndRoles);
    }

    private void removeNote(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("id");
        if (noteId == null) {
            return;
        }
        Note note = notebook.getNote(noteId);
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        if (!notebookAuthorization.isOwner(noteId, userAndRoles)) {
            this.permissionError(conn, "remove", fromMessage.principal, userAndRoles, notebookAuthorization.getOwners(noteId));
            return;
        }
        AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
        notebook.removeNote(noteId, subject);
        this.removeNote(noteId);
        this.broadcastNoteList(subject, userAndRoles);
    }

    private void removeFolder(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws SchedulerException, IOException {
        String folderId = (String)fromMessage.get("id");
        if (folderId == null) {
            return;
        }
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        List notes = notebook.getNotesUnderFolder(folderId);
        for (Note note : notes) {
            String noteId = note.getId();
            if (notebookAuthorization.isOwner(noteId, userAndRoles)) continue;
            this.permissionError(conn, "remove folder of '" + note.getName() + "'", fromMessage.principal, userAndRoles, notebookAuthorization.getOwners(noteId));
            return;
        }
        AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
        for (Note note : notes) {
            notebook.removeNote(note.getId(), subject);
            this.removeNote(note.getId());
        }
        this.broadcastNoteList(subject, userAndRoles);
    }

    private void moveNoteToTrash(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws SchedulerException, IOException {
        String noteId = (String)fromMessage.get("id");
        if (noteId == null) {
            return;
        }
        Note note = notebook.getNote(noteId);
        if (note != null && !note.isTrash()) {
            fromMessage.put("name", (Object)("~Trash/" + note.getName()));
            this.renameNote(conn, userAndRoles, notebook, fromMessage, "move");
            notebook.moveNoteToTrash(note.getId());
        }
    }

    private void moveFolderToTrash(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws SchedulerException, IOException {
        String folderId = (String)fromMessage.get("id");
        if (folderId == null) {
            return;
        }
        Folder folder = notebook.getFolder(folderId);
        if (folder != null && !folder.isTrash()) {
            String trashFolderId = "~Trash/" + folderId;
            if (notebook.hasFolder(trashFolderId)) {
                DateTime currentDate = new DateTime();
                DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
                trashFolderId = trashFolderId + " " + formatter.print((ReadableInstant)currentDate);
            }
            fromMessage.put("name", (Object)trashFolderId);
            this.renameFolder(conn, userAndRoles, notebook, fromMessage, "move");
        }
    }

    private void restoreNote(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws SchedulerException, IOException {
        String noteId = (String)fromMessage.get("id");
        if (noteId == null) {
            return;
        }
        Note note = notebook.getNote(noteId);
        if (note != null && note.isTrash()) {
            fromMessage.put("name", (Object)note.getName().replaceFirst("~Trash/", ""));
            this.renameNote(conn, userAndRoles, notebook, fromMessage, "restore");
        }
    }

    private void restoreFolder(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws SchedulerException, IOException {
        String folderId = (String)fromMessage.get("id");
        if (folderId == null) {
            return;
        }
        Folder folder = notebook.getFolder(folderId);
        if (folder != null && folder.isTrash()) {
            String restoreName = folder.getId().replaceFirst("~Trash/", "").trim();
            Pattern p = Pattern.compile("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}$");
            Matcher m = p.matcher(restoreName);
            restoreName = m.replaceAll("").trim();
            fromMessage.put("name", (Object)restoreName);
            this.renameFolder(conn, userAndRoles, notebook, fromMessage, "restore");
        }
    }

    private void restoreAll(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws SchedulerException, IOException {
        Folder trashFolder = notebook.getFolder("~Trash");
        if (trashFolder != null) {
            fromMessage.data = new HashMap();
            fromMessage.put("id", (Object)"~Trash");
            fromMessage.put("name", (Object)"/");
            this.renameFolder(conn, userAndRoles, notebook, fromMessage, "restore trash");
        }
    }

    private void emptyTrash(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws SchedulerException, IOException {
        fromMessage.data = new HashMap();
        fromMessage.put("id", (Object)"~Trash");
        this.removeFolder(conn, userAndRoles, notebook, fromMessage);
    }

    private void updateParagraph(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        String paragraphId = (String)fromMessage.get("id");
        if (paragraphId == null) {
            return;
        }
        Map params = (Map)fromMessage.get("params");
        Map config = (Map)fromMessage.get("config");
        String noteId = this.getOpenNoteId(conn);
        Note note = notebook.getNote(noteId);
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
        if (!notebookAuthorization.isWriter(noteId, userAndRoles)) {
            this.permissionError(conn, "write", fromMessage.principal, userAndRoles, notebookAuthorization.getWriters(noteId));
            return;
        }
        Paragraph p = note.getParagraph(paragraphId);
        if (note.isPersonalizedMode()) {
            p = (Paragraph)p.getUserParagraphMap().get(subject.getUser());
        }
        p.settings.setParams(params);
        p.setConfig(config);
        p.setTitle((String)fromMessage.get("title"));
        p.setText((String)fromMessage.get("paragraph"));
        subject = new AuthenticationInfo(fromMessage.principal);
        if (note.isPersonalizedMode()) {
            p = p.getUserParagraph(subject.getUser());
            p.settings.setParams(params);
            p.setConfig(config);
            p.setTitle((String)fromMessage.get("title"));
            p.setText((String)fromMessage.get("paragraph"));
        }
        note.persist(subject);
        if (note.isPersonalizedMode()) {
            Map userParagraphMap = note.getParagraph(paragraphId).getUserParagraphMap();
            this.broadcastParagraphs(userParagraphMap);
        } else {
            this.broadcastParagraph(note, p);
        }
    }

    private void cloneNote(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException, CloneNotSupportedException {
        String noteId = this.getOpenNoteId(conn);
        String name = (String)fromMessage.get("name");
        Note newNote = notebook.cloneNote(noteId, name, new AuthenticationInfo(fromMessage.principal));
        AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
        this.addConnectionToNote(newNote.getId(), conn);
        conn.send(this.serializeMessage(new Message(Message.OP.NEW_NOTE).put("note", (Object)newNote)));
        this.broadcastNoteList(subject, userAndRoles);
    }

    private void clearAllParagraphOutput(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("id");
        if (StringUtils.isBlank((String)noteId)) {
            return;
        }
        Note note = notebook.getNote(noteId);
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        if (!notebookAuthorization.isWriter(noteId, userAndRoles)) {
            this.permissionError(conn, "clear output", fromMessage.principal, userAndRoles, notebookAuthorization.getOwners(noteId));
            return;
        }
        note.clearAllParagraphOutput();
        this.broadcastNote(note);
    }

    protected Note importNote(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        Note note = null;
        if (fromMessage != null) {
            String noteName = (String)((Map)fromMessage.get("note")).get("name");
            String noteJson = this.gson.toJson(fromMessage.get("note"));
            AuthenticationInfo subject = null;
            subject = fromMessage.principal != null ? new AuthenticationInfo(fromMessage.principal) : new AuthenticationInfo("anonymous");
            note = notebook.importNote(noteJson, noteName, subject);
            note.persist(subject);
            this.broadcastNote(note);
            this.broadcastNoteList(subject, userAndRoles);
        }
        return note;
    }

    private void removeParagraph(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        String paragraphId = (String)fromMessage.get("id");
        if (paragraphId == null) {
            return;
        }
        String noteId = this.getOpenNoteId(conn);
        Note note = notebook.getNote(noteId);
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
        if (!notebookAuthorization.isWriter(noteId, userAndRoles)) {
            this.permissionError(conn, "write", fromMessage.principal, userAndRoles, notebookAuthorization.getWriters(noteId));
            return;
        }
        if (!note.isLastParagraph(paragraphId)) {
            Paragraph para = note.removeParagraph(subject.getUser(), paragraphId);
            note.persist(subject);
            if (para != null) {
                this.broadcast(note.getId(), new Message(Message.OP.PARAGRAPH_REMOVED).put("id", (Object)para.getId()));
            }
        }
    }

    private void clearParagraphOutput(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        String paragraphId = (String)fromMessage.get("id");
        if (paragraphId == null) {
            return;
        }
        String noteId = this.getOpenNoteId(conn);
        Note note = notebook.getNote(noteId);
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        if (!notebookAuthorization.isWriter(noteId, userAndRoles)) {
            this.permissionError(conn, "write", fromMessage.principal, userAndRoles, notebookAuthorization.getWriters(noteId));
            return;
        }
        String user = note.isPersonalizedMode() ? new AuthenticationInfo(fromMessage.principal).getUser() : null;
        Paragraph p = note.clearParagraphOutput(paragraphId, user);
        this.broadcastParagraph(note, p);
    }

    private void completion(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        String paragraphId = (String)fromMessage.get("id");
        String buffer = (String)fromMessage.get("buf");
        int cursor = (int)Double.parseDouble(fromMessage.get("cursor").toString());
        Message resp = new Message(Message.OP.COMPLETION_LIST).put("id", (Object)paragraphId);
        if (paragraphId == null) {
            conn.send(this.serializeMessage(resp));
            return;
        }
        Note note = notebook.getNote(this.getOpenNoteId(conn));
        List candidates = note.completion(paragraphId, buffer, cursor);
        resp.put("completions", (Object)candidates);
        conn.send(this.serializeMessage(resp));
    }

    private void angularObjectUpdated(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) {
        String noteId = (String)fromMessage.get("noteId");
        String paragraphId = (String)fromMessage.get("paragraphId");
        String interpreterGroupId = (String)fromMessage.get("interpreterGroupId");
        String varName = (String)fromMessage.get("name");
        Object varValue = fromMessage.get("value");
        String user = fromMessage.principal;
        AngularObject ao = null;
        boolean global = false;
        Note note = notebook.getNote(noteId);
        if (note != null) {
            List settings = notebook.getInterpreterSettingManager().getInterpreterSettings(note.getId());
            for (InterpreterSetting setting : settings) {
                if (setting.getInterpreterGroup(user, note.getId()) == null || !interpreterGroupId.equals(setting.getInterpreterGroup(user, note.getId()).getId())) continue;
                AngularObjectRegistry angularObjectRegistry = setting.getInterpreterGroup(user, note.getId()).getAngularObjectRegistry();
                ao = angularObjectRegistry.get(varName, noteId, paragraphId);
                if (ao == null) {
                    ao = angularObjectRegistry.get(varName, noteId, null);
                    if (ao == null) {
                        ao = angularObjectRegistry.get(varName, null, null);
                        if (ao == null) {
                            LOG.warn("Object {} is not binded", (Object)varName);
                            break;
                        }
                        ao.set(varValue, false);
                        global = true;
                        break;
                    }
                    ao.set(varValue, false);
                    global = false;
                    break;
                }
                ao.set(varValue, false);
                global = false;
                break;
            }
        }
        if (global) {
            for (Note n : notebook.getAllNotes()) {
                List settings = notebook.getInterpreterSettingManager().getInterpreterSettings(note.getId());
                for (InterpreterSetting setting : settings) {
                    if (setting.getInterpreterGroup(user, n.getId()) == null || !interpreterGroupId.equals(setting.getInterpreterGroup(user, n.getId()).getId())) continue;
                    AngularObjectRegistry angularObjectRegistry = setting.getInterpreterGroup(user, n.getId()).getAngularObjectRegistry();
                    this.broadcastExcept(n.getId(), new Message(Message.OP.ANGULAR_OBJECT_UPDATE).put("angularObject", (Object)ao).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)n.getId()).put("paragraphId", (Object)ao.getParagraphId()), conn);
                }
            }
        } else {
            this.broadcastExcept(note.getId(), new Message(Message.OP.ANGULAR_OBJECT_UPDATE).put("angularObject", ao).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)note.getId()).put("paragraphId", (Object)ao.getParagraphId()), conn);
        }
    }

    protected void angularObjectClientBind(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws Exception {
        String noteId = (String)fromMessage.getType("noteId");
        String varName = (String)fromMessage.getType("name");
        Object varValue = fromMessage.get("value");
        String paragraphId = (String)fromMessage.getType("paragraphId");
        Note note = notebook.getNote(noteId);
        if (paragraphId == null) {
            throw new IllegalArgumentException("target paragraph not specified for angular value bind");
        }
        if (note != null) {
            InterpreterGroup interpreterGroup = this.findInterpreterGroupForParagraph(note, paragraphId);
            AngularObjectRegistry registry = interpreterGroup.getAngularObjectRegistry();
            if (registry instanceof RemoteAngularObjectRegistry) {
                RemoteAngularObjectRegistry remoteRegistry = (RemoteAngularObjectRegistry)registry;
                this.pushAngularObjectToRemoteRegistry(noteId, paragraphId, varName, varValue, remoteRegistry, interpreterGroup.getId(), conn);
            } else {
                this.pushAngularObjectToLocalRepo(noteId, paragraphId, varName, varValue, registry, interpreterGroup.getId(), conn);
            }
        }
    }

    protected void angularObjectClientUnbind(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws Exception {
        String noteId = (String)fromMessage.getType("noteId");
        String varName = (String)fromMessage.getType("name");
        String paragraphId = (String)fromMessage.getType("paragraphId");
        Note note = notebook.getNote(noteId);
        if (paragraphId == null) {
            throw new IllegalArgumentException("target paragraph not specified for angular value unBind");
        }
        if (note != null) {
            InterpreterGroup interpreterGroup = this.findInterpreterGroupForParagraph(note, paragraphId);
            AngularObjectRegistry registry = interpreterGroup.getAngularObjectRegistry();
            if (registry instanceof RemoteAngularObjectRegistry) {
                RemoteAngularObjectRegistry remoteRegistry = (RemoteAngularObjectRegistry)registry;
                this.removeAngularFromRemoteRegistry(noteId, paragraphId, varName, remoteRegistry, interpreterGroup.getId(), conn);
            } else {
                this.removeAngularObjectFromLocalRepo(noteId, paragraphId, varName, registry, interpreterGroup.getId(), conn);
            }
        }
    }

    private InterpreterGroup findInterpreterGroupForParagraph(Note note, String paragraphId) throws Exception {
        Paragraph paragraph = note.getParagraph(paragraphId);
        if (paragraph == null) {
            throw new IllegalArgumentException("Unknown paragraph with id : " + paragraphId);
        }
        return paragraph.getCurrentRepl().getInterpreterGroup();
    }

    private void pushAngularObjectToRemoteRegistry(String noteId, String paragraphId, String varName, Object varValue, RemoteAngularObjectRegistry remoteRegistry, String interpreterGroupId, NotebookSocket conn) {
        AngularObject ao = remoteRegistry.addAndNotifyRemoteProcess(varName, varValue, noteId, paragraphId);
        this.broadcastExcept(noteId, new Message(Message.OP.ANGULAR_OBJECT_UPDATE).put("angularObject", (Object)ao).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId), conn);
    }

    private void removeAngularFromRemoteRegistry(String noteId, String paragraphId, String varName, RemoteAngularObjectRegistry remoteRegistry, String interpreterGroupId, NotebookSocket conn) {
        AngularObject ao = remoteRegistry.removeAndNotifyRemoteProcess(varName, noteId, paragraphId);
        this.broadcastExcept(noteId, new Message(Message.OP.ANGULAR_OBJECT_REMOVE).put("angularObject", (Object)ao).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId), conn);
    }

    private void pushAngularObjectToLocalRepo(String noteId, String paragraphId, String varName, Object varValue, AngularObjectRegistry registry, String interpreterGroupId, NotebookSocket conn) {
        AngularObject angularObject = registry.get(varName, noteId, paragraphId);
        if (angularObject == null) {
            angularObject = registry.add(varName, varValue, noteId, paragraphId);
        } else {
            angularObject.set(varValue, true);
        }
        this.broadcastExcept(noteId, new Message(Message.OP.ANGULAR_OBJECT_UPDATE).put("angularObject", (Object)angularObject).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId), conn);
    }

    private void removeAngularObjectFromLocalRepo(String noteId, String paragraphId, String varName, AngularObjectRegistry registry, String interpreterGroupId, NotebookSocket conn) {
        AngularObject removed = registry.remove(varName, noteId, paragraphId);
        if (removed != null) {
            this.broadcastExcept(noteId, new Message(Message.OP.ANGULAR_OBJECT_REMOVE).put("angularObject", (Object)removed).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId), conn);
        }
    }

    private void moveParagraph(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        String paragraphId = (String)fromMessage.get("id");
        if (paragraphId == null) {
            return;
        }
        int newIndex = (int)Double.parseDouble(fromMessage.get("index").toString());
        String noteId = this.getOpenNoteId(conn);
        Note note = notebook.getNote(noteId);
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
        if (!notebookAuthorization.isWriter(noteId, userAndRoles)) {
            this.permissionError(conn, "write", fromMessage.principal, userAndRoles, notebookAuthorization.getWriters(noteId));
            return;
        }
        note.moveParagraph(paragraphId, newIndex);
        note.persist(subject);
        this.broadcast(note.getId(), new Message(Message.OP.PARAGRAPH_MOVED).put("id", (Object)paragraphId).put("index", (Object)newIndex));
    }

    private String insertParagraph(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        int index = (int)Double.parseDouble(fromMessage.get("index").toString());
        String noteId = this.getOpenNoteId(conn);
        Note note = notebook.getNote(noteId);
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
        if (!notebookAuthorization.isWriter(noteId, userAndRoles)) {
            this.permissionError(conn, "write", fromMessage.principal, userAndRoles, notebookAuthorization.getWriters(noteId));
            return null;
        }
        Paragraph newPara = note.insertParagraph(index, subject);
        note.persist(subject);
        this.broadcastNewParagraph(note, newPara);
        return newPara.getId();
    }

    private void copyParagraph(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        String newParaId = this.insertParagraph(conn, userAndRoles, notebook, fromMessage);
        if (newParaId == null) {
            return;
        }
        fromMessage.put("id", (Object)newParaId);
        this.updateParagraph(conn, userAndRoles, notebook, fromMessage);
    }

    private void cancelParagraph(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        String paragraphId = (String)fromMessage.get("id");
        if (paragraphId == null) {
            return;
        }
        String noteId = this.getOpenNoteId(conn);
        Note note = notebook.getNote(noteId);
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        if (!notebookAuthorization.isWriter(noteId, userAndRoles)) {
            this.permissionError(conn, "write", fromMessage.principal, userAndRoles, notebookAuthorization.getWriters(noteId));
            return;
        }
        Paragraph p = note.getParagraph(paragraphId);
        p.abort();
    }

    private void runAllParagraphs(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("noteId");
        if (StringUtils.isBlank((String)noteId)) {
            return;
        }
        Note note = notebook.getNote(noteId);
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        if (!notebookAuthorization.isWriter(noteId, userAndRoles)) {
            this.permissionError(conn, "run all paragraphs", fromMessage.principal, userAndRoles, notebookAuthorization.getOwners(noteId));
            return;
        }
        List paragraphs = (List)this.gson.fromJson(String.valueOf(fromMessage.data.get("paragraphs")), new TypeToken<List<Map<String, Object>>>(){}.getType());
        for (Map raw : paragraphs) {
            String paragraphId = (String)raw.get("id");
            if (paragraphId == null) continue;
            String text = (String)raw.get("paragraph");
            String title = (String)raw.get("title");
            Map params = (Map)raw.get("params");
            Map config = (Map)raw.get("config");
            Paragraph p = this.setParagraphUsingMessage(note, fromMessage, paragraphId, text, title, params, config);
            this.persistAndExecuteSingleParagraph(conn, note, p);
        }
    }

    private void runParagraph(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        String paragraphId = (String)fromMessage.get("id");
        if (paragraphId == null) {
            return;
        }
        String noteId = this.getOpenNoteId(conn);
        Note note = notebook.getNote(noteId);
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        if (!notebookAuthorization.isWriter(noteId, userAndRoles)) {
            this.permissionError(conn, "write", fromMessage.principal, userAndRoles, notebookAuthorization.getWriters(noteId));
            return;
        }
        String text = (String)fromMessage.get("paragraph");
        String title = (String)fromMessage.get("title");
        Map params = (Map)fromMessage.get("params");
        Map config = (Map)fromMessage.get("config");
        Paragraph p = this.setParagraphUsingMessage(note, fromMessage, paragraphId, text, title, params, config);
        this.persistAndExecuteSingleParagraph(conn, note, p);
    }

    private void persistAndExecuteSingleParagraph(NotebookSocket conn, Note note, Paragraph p) throws IOException {
        block5: {
            boolean isTheLastParagraph = note.isLastParagraph(p.getId());
            if (!p.getText().trim().equals(p.getMagic()) && !Strings.isNullOrEmpty((String)p.getText()) && isTheLastParagraph) {
                Paragraph newPara = note.addParagraph(p.getAuthenticationInfo());
                this.broadcastNewParagraph(note, newPara);
            }
            try {
                note.persist(p.getAuthenticationInfo());
            }
            catch (FileSystemException ex) {
                LOG.error("Exception from run", (Throwable)ex);
                conn.send(this.serializeMessage(new Message(Message.OP.ERROR_INFO).put("info", (Object)"Oops! There is something wrong with the notebook file system. Please check the logs for more details.")));
                return;
            }
            try {
                note.run(p.getId());
            }
            catch (Exception ex) {
                LOG.error("Exception from run", (Throwable)ex);
                if (p == null) break block5;
                p.setReturn(new InterpreterResult(InterpreterResult.Code.ERROR, ex.getMessage()), (Throwable)ex);
                p.setStatus(Job.Status.ERROR);
                this.broadcast(note.getId(), new Message(Message.OP.PARAGRAPH).put("paragraph", (Object)p));
            }
        }
    }

    private Paragraph setParagraphUsingMessage(Note note, Message fromMessage, String paragraphId, String text, String title, Map<String, Object> params, Map<String, Object> config) {
        Paragraph p = note.getParagraph(paragraphId);
        p.setText(text);
        p.setTitle(title);
        AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal, fromMessage.ticket);
        p.setAuthenticationInfo(subject);
        p.settings.setParams(params);
        p.setConfig(config);
        if (note.isPersonalizedMode()) {
            p = note.getParagraph(paragraphId);
            p.setText(text);
            p.setTitle(title);
            p.setAuthenticationInfo(subject);
            p.settings.setParams(params);
            p.setConfig(config);
        }
        return p;
    }

    private void sendAllConfigurations(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook) throws IOException {
        ZeppelinConfiguration conf = notebook.getConf();
        Map configurations = conf.dumpConfigurations(conf, new ZeppelinConfiguration.ConfigurationKeyPredicate(){

            public boolean apply(String key) {
                return !key.contains("password") && !key.equals(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_AZURE_CONNECTION_STRING.getVarName());
            }
        });
        conn.send(this.serializeMessage(new Message(Message.OP.CONFIGURATIONS_INFO).put("configurations", (Object)configurations)));
    }

    private void checkpointNote(NotebookSocket conn, Notebook notebook, Message fromMessage) throws IOException {
        AuthenticationInfo subject;
        String commitMessage;
        String noteId = (String)fromMessage.get("noteId");
        NotebookRepo.Revision revision = notebook.checkpointNote(noteId, commitMessage = (String)fromMessage.get("commitMessage"), subject = new AuthenticationInfo(fromMessage.principal));
        if (!NotebookRepo.Revision.isEmpty((NotebookRepo.Revision)revision)) {
            List revisions = notebook.listRevisionHistory(noteId, subject);
            conn.send(this.serializeMessage(new Message(Message.OP.LIST_REVISION_HISTORY).put("revisionList", (Object)revisions)));
        } else {
            conn.send(this.serializeMessage(new Message(Message.OP.ERROR_INFO).put("info", (Object)"Couldn't checkpoint note revision: possibly storage doesn't support versioning. Please check the logs for more details.")));
        }
    }

    private void listRevisionHistory(NotebookSocket conn, Notebook notebook, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("noteId");
        AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
        List revisions = notebook.listRevisionHistory(noteId, subject);
        conn.send(this.serializeMessage(new Message(Message.OP.LIST_REVISION_HISTORY).put("revisionList", (Object)revisions)));
    }

    private void setNoteRevision(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        boolean setRevisionStatus;
        String noteId = (String)fromMessage.get("noteId");
        String revisionId = (String)fromMessage.get("revisionId");
        AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        if (!notebookAuthorization.isWriter(noteId, userAndRoles)) {
            this.permissionError(conn, "update", fromMessage.principal, userAndRoles, notebookAuthorization.getWriters(noteId));
            return;
        }
        Note headNote = null;
        try {
            headNote = notebook.setNoteRevision(noteId, revisionId, subject);
            setRevisionStatus = headNote != null;
        }
        catch (Exception e) {
            setRevisionStatus = false;
            LOG.error("Failed to set given note revision", (Throwable)e);
        }
        if (setRevisionStatus) {
            notebook.loadNoteFromRepo(noteId, subject);
        }
        conn.send(this.serializeMessage(new Message(Message.OP.SET_NOTE_REVISION).put("status", (Object)setRevisionStatus)));
        if (setRevisionStatus) {
            Note reloadedNote = notebook.getNote(headNote.getId());
            this.broadcastNote(reloadedNote);
        } else {
            conn.send(this.serializeMessage(new Message(Message.OP.ERROR_INFO).put("info", (Object)"Couldn't set note to the given revision. Please check the logs for more details.")));
        }
    }

    private void getNoteByRevision(NotebookSocket conn, Notebook notebook, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("noteId");
        String revisionId = (String)fromMessage.get("revisionId");
        AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
        Note revisionNote = notebook.getNoteByRevision(noteId, revisionId, subject);
        conn.send(this.serializeMessage(new Message(Message.OP.NOTE_REVISION).put("noteId", (Object)noteId).put("revisionId", (Object)revisionId).put("note", (Object)revisionNote)));
    }

    public void onOutputAppend(String noteId, String paragraphId, int index, String output) {
        Message msg = new Message(Message.OP.PARAGRAPH_APPEND_OUTPUT).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId).put("index", (Object)index).put("data", (Object)output);
        this.broadcast(noteId, msg);
    }

    public void onOutputUpdated(String noteId, String paragraphId, int index, InterpreterResult.Type type, String output) {
        Message msg = new Message(Message.OP.PARAGRAPH_UPDATE_OUTPUT).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId).put("index", (Object)index).put("type", (Object)type).put("data", (Object)output);
        Note note = this.notebook().getNote(noteId);
        if (note.isPersonalizedMode()) {
            String user = note.getParagraph(paragraphId).getUser();
            if (null != user) {
                this.multicastToUser(user, msg);
            }
        } else {
            this.broadcast(noteId, msg);
        }
    }

    public void onOutputClear(String noteId, String paragraphId) {
        Notebook notebook = this.notebook();
        Note note = notebook.getNote(noteId);
        note.clearParagraphOutput(paragraphId, null);
        Paragraph paragraph = note.getParagraph(paragraphId);
        this.broadcastParagraph(note, paragraph);
    }

    public void onOutputAppend(String noteId, String paragraphId, int index, String appId, String output) {
        Message msg = new Message(Message.OP.APP_APPEND_OUTPUT).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId).put("index", (Object)index).put("appId", (Object)appId).put("data", (Object)output);
        this.broadcast(noteId, msg);
    }

    public void onOutputUpdated(String noteId, String paragraphId, int index, String appId, InterpreterResult.Type type, String output) {
        Message msg = new Message(Message.OP.APP_UPDATE_OUTPUT).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId).put("index", (Object)index).put("type", (Object)type).put("appId", (Object)appId).put("data", (Object)output);
        this.broadcast(noteId, msg);
    }

    public void onLoad(String noteId, String paragraphId, String appId, HeliumPackage pkg) {
        Message msg = new Message(Message.OP.APP_LOAD).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId).put("appId", (Object)appId).put("pkg", (Object)pkg);
        this.broadcast(noteId, msg);
    }

    public void onStatusChange(String noteId, String paragraphId, String appId, String status) {
        Message msg = new Message(Message.OP.APP_STATUS_CHANGE).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId).put("appId", (Object)appId).put("status", (Object)status);
        this.broadcast(noteId, msg);
    }

    public void onGetParagraphRunners(String noteId, String paragraphId, RemoteInterpreterProcessListener.RemoteWorksEventListener callback) {
        Notebook notebookIns = this.notebook();
        LinkedList<InterpreterContextRunner> runner = new LinkedList<InterpreterContextRunner>();
        if (notebookIns == null) {
            LOG.info("intepreter request notebook instance is null");
            callback.onFinished((Object)notebookIns);
        }
        try {
            Note note = notebookIns.getNote(noteId);
            if (note != null) {
                if (paragraphId != null) {
                    Paragraph paragraph = note.getParagraph(paragraphId);
                    if (paragraph != null) {
                        runner.add(paragraph.getInterpreterContextRunner());
                    }
                } else {
                    for (Paragraph p : note.getParagraphs()) {
                        runner.add(p.getInterpreterContextRunner());
                    }
                }
            }
            callback.onFinished(runner);
        }
        catch (NullPointerException e) {
            LOG.warn(e.getMessage());
            callback.onError();
        }
    }

    public void onRemoteRunParagraph(String noteId, String paragraphId) throws Exception {
        Notebook notebookIns = this.notebook();
        if (notebookIns == null) {
            throw new Exception("onRemoteRunParagraph notebook instance is null");
        }
        Note noteIns = notebookIns.getNote(noteId);
        if (noteIns == null) {
            throw new Exception(String.format("Can't found note id %s", noteId));
        }
        Paragraph paragraph = noteIns.getParagraph(paragraphId);
        if (paragraph == null) {
            throw new Exception(String.format("Can't found paragraph %s %s", noteId, paragraphId));
        }
        HashSet userAndRoles = Sets.newHashSet();
        userAndRoles.add(SecurityUtils.getPrincipal());
        userAndRoles.addAll(SecurityUtils.getRoles());
        if (!notebookIns.getNotebookAuthorization().hasWriteAuthorization((Set)userAndRoles, noteId)) {
            throw new ForbiddenException(String.format("can't execute note %s", noteId));
        }
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        paragraph.setAuthenticationInfo(subject);
        noteIns.run(paragraphId);
    }

    public ParagraphJobListener getParagraphJobListener(Note note) {
        return new ParagraphListenerImpl(this, note);
    }

    public NotebookEventListener getNotebookInformationListener() {
        return new NotebookInformationListener(this);
    }

    private void sendAllAngularObjects(Note note, String user, NotebookSocket conn) throws IOException {
        List settings = this.notebook().getInterpreterSettingManager().getInterpreterSettings(note.getId());
        if (settings == null || settings.size() == 0) {
            return;
        }
        for (InterpreterSetting intpSetting : settings) {
            AngularObjectRegistry registry = intpSetting.getInterpreterGroup(user, note.getId()).getAngularObjectRegistry();
            List objects = registry.getAllWithGlobal(note.getId());
            for (AngularObject object : objects) {
                conn.send(this.serializeMessage(new Message(Message.OP.ANGULAR_OBJECT_UPDATE).put("angularObject", (Object)object).put("interpreterGroupId", (Object)intpSetting.getInterpreterGroup(user, note.getId()).getId()).put("noteId", (Object)note.getId()).put("paragraphId", (Object)object.getParagraphId())));
            }
        }
    }

    public void onAdd(String interpreterGroupId, AngularObject object) {
        this.onUpdate(interpreterGroupId, object);
    }

    public void onUpdate(String interpreterGroupId, AngularObject object) {
        Notebook notebook = this.notebook();
        if (notebook == null) {
            return;
        }
        List notes = notebook.getAllNotes();
        for (Note note : notes) {
            List intpSettings;
            if (object.getNoteId() != null && !note.getId().equals(object.getNoteId()) || (intpSettings = notebook.getInterpreterSettingManager().getInterpreterSettings(note.getId())).isEmpty()) continue;
            this.broadcast(note.getId(), new Message(Message.OP.ANGULAR_OBJECT_UPDATE).put("angularObject", (Object)object).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)note.getId()).put("paragraphId", (Object)object.getParagraphId()));
        }
    }

    public void onRemove(String interpreterGroupId, String name, String noteId, String paragraphId) {
        Notebook notebook = this.notebook();
        List notes = notebook.getAllNotes();
        block0: for (Note note : notes) {
            if (noteId != null && !note.getId().equals(noteId)) continue;
            List settingIds = notebook.getInterpreterSettingManager().getInterpreters(note.getId());
            for (String id : settingIds) {
                if (!interpreterGroupId.contains(id)) continue;
                this.broadcast(note.getId(), new Message(Message.OP.ANGULAR_OBJECT_REMOVE).put("name", (Object)name).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId));
                continue block0;
            }
        }
    }

    private void getEditorSetting(NotebookSocket conn, Message fromMessage) throws IOException {
        String paragraphId = (String)fromMessage.get("paragraphId");
        String replName = (String)fromMessage.get("magic");
        String noteId = this.getOpenNoteId(conn);
        String user = fromMessage.principal;
        Message resp = new Message(Message.OP.EDITOR_SETTING);
        resp.put("paragraphId", (Object)paragraphId);
        Interpreter interpreter = this.notebook().getInterpreterFactory().getInterpreter(user, noteId, replName);
        resp.put("editor", (Object)this.notebook().getInterpreterSettingManager().getEditorSetting(interpreter, user, noteId, replName));
        conn.send(this.serializeMessage(resp));
    }

    private void getInterpreterSettings(NotebookSocket conn, AuthenticationInfo subject) throws IOException {
        List availableSettings = this.notebook().getInterpreterSettingManager().get();
        conn.send(this.serializeMessage(new Message(Message.OP.INTERPRETER_SETTINGS).put("interpreterSettings", (Object)availableSettings)));
    }

    public void onMetaInfosReceived(String settingId, Map<String, String> metaInfos) {
        InterpreterSetting interpreterSetting = this.notebook().getInterpreterSettingManager().get(settingId);
        interpreterSetting.setInfos(metaInfos);
    }

    private void switchConnectionToWatcher(NotebookSocket conn, Message messagereceived) throws IOException {
        if (!this.isSessionAllowedToSwitchToWatcher(conn)) {
            LOG.error("Cannot switch this client to watcher, invalid security key");
            return;
        }
        LOG.info("Going to add {} to watcher socket", (Object)conn);
        if (this.watcherSockets.contains((Object)conn)) {
            LOG.info("connection alrerady present in the watcher");
            return;
        }
        this.watcherSockets.add(conn);
        this.removeConnectionFromAllNote(conn);
        this.connectedSockets.remove((Object)conn);
        this.removeUserConnection(conn.getUser(), conn);
    }

    private boolean isSessionAllowedToSwitchToWatcher(NotebookSocket session) {
        String watcherSecurityKey = session.getRequest().getHeader("X-Watcher-Key");
        return !StringUtils.isBlank((String)watcherSecurityKey) && watcherSecurityKey.equals(WatcherSecurityKey.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastToWatchers(String noteId, String subject, Message message) {
        Queue<NotebookSocket> queue = this.watcherSockets;
        synchronized (queue) {
            if (this.watcherSockets.isEmpty()) {
                return;
            }
            for (NotebookSocket watcher : this.watcherSockets) {
                try {
                    watcher.send(WatcherMessage.builder((String)noteId).subject(subject).message(this.serializeMessage(message)).build().serialize());
                }
                catch (IOException e) {
                    LOG.error("Cannot broadcast message to watcher", (Throwable)e);
                }
            }
        }
    }

    public static class ParagraphListenerImpl
    implements ParagraphJobListener {
        private NotebookServer notebookServer;
        private Note note;

        public ParagraphListenerImpl(NotebookServer notebookServer, Note note) {
            this.notebookServer = notebookServer;
            this.note = note;
        }

        public void onProgressUpdate(Job job, int progress) {
            this.notebookServer.broadcast(this.note.getId(), new Message(Message.OP.PROGRESS).put("id", (Object)job.getId()).put("progress", (Object)progress));
        }

        public void beforeStatusChange(Job job, Job.Status before, Job.Status after) {
        }

        public void afterStatusChange(Job job, Job.Status before, Job.Status after) {
            if (after == Job.Status.ERROR && job.getException() != null) {
                LOG.error("Error", job.getException());
            }
            if (job.isTerminated()) {
                if (job.getStatus() == Job.Status.FINISHED) {
                    LOG.info("Job {} is finished successfully, status: {}", (Object)job.getId(), (Object)job.getStatus());
                } else {
                    LOG.warn("Job {} is finished, status: {}, exception: {}, result: {}", new Object[]{job.getId(), job.getStatus(), job.getException(), job.getReturn()});
                }
                try {
                    this.note.persist(job instanceof Paragraph ? ((Paragraph)job).getAuthenticationInfo() : null);
                }
                catch (IOException e) {
                    LOG.error(e.toString(), (Throwable)e);
                }
            }
            if (job instanceof Paragraph) {
                Paragraph p = (Paragraph)job;
                p.setStatusToUserParagraph(job.getStatus());
                this.notebookServer.broadcastParagraph(this.note, p);
            }
            try {
                this.notebookServer.broadcastUpdateNoteJobInfo(System.currentTimeMillis() - 5000L);
            }
            catch (IOException e) {
                LOG.error("can not broadcast for job manager {}", (Throwable)e);
            }
        }

        public void onOutputAppend(Paragraph paragraph, int idx, String output) {
            Message msg = new Message(Message.OP.PARAGRAPH_APPEND_OUTPUT).put("noteId", (Object)paragraph.getNote().getId()).put("paragraphId", (Object)paragraph.getId()).put("data", (Object)output);
            this.notebookServer.broadcast(paragraph.getNote().getId(), msg);
        }

        public void onOutputUpdate(Paragraph paragraph, int idx, InterpreterResultMessage result) {
            String output = result.getData();
            Message msg = new Message(Message.OP.PARAGRAPH_UPDATE_OUTPUT).put("noteId", (Object)paragraph.getNote().getId()).put("paragraphId", (Object)paragraph.getId()).put("data", (Object)output);
            this.notebookServer.broadcast(paragraph.getNote().getId(), msg);
        }

        public void onOutputUpdateAll(Paragraph paragraph, List<InterpreterResultMessage> msgs) {
        }
    }

    public static class NotebookInformationListener
    implements NotebookEventListener {
        private NotebookServer notebookServer;

        public NotebookInformationListener(NotebookServer notebookServer) {
            this.notebookServer = notebookServer;
        }

        public void onParagraphRemove(Paragraph p) {
            try {
                this.notebookServer.broadcastUpdateNoteJobInfo(System.currentTimeMillis() - 5000L);
            }
            catch (IOException ioe) {
                LOG.error("can not broadcast for job manager {}", (Object)ioe.getMessage());
            }
        }

        public void onNoteRemove(Note note) {
            try {
                this.notebookServer.broadcastUpdateNoteJobInfo(System.currentTimeMillis() - 5000L);
            }
            catch (IOException ioe) {
                LOG.error("can not broadcast for job manager {}", (Object)ioe.getMessage());
            }
            LinkedList notesInfo = new LinkedList();
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("noteId", note.getId());
            LinkedList paragraphsInfo = new LinkedList();
            info.put("isRunningJob", false);
            info.put("unixTimeLastRun", 0);
            info.put("isRemoved", true);
            info.put("paragraphs", paragraphsInfo);
            notesInfo.add(info);
            HashMap<String, Serializable> response = new HashMap<String, Serializable>();
            response.put("lastResponseUnixTime", Long.valueOf(System.currentTimeMillis()));
            response.put("jobs", notesInfo);
            this.notebookServer.broadcast(JOB_MANAGER_SERVICE.JOB_MANAGER_PAGE.getKey(), new Message(Message.OP.LIST_UPDATE_NOTE_JOBS).put("noteRunningJobs", response));
        }

        public void onParagraphCreate(Paragraph p) {
            Notebook notebook = this.notebookServer.notebook();
            List notebookJobs = notebook.getJobListByParagraphId(p.getId());
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("lastResponseUnixTime", System.currentTimeMillis());
            response.put("jobs", notebookJobs);
            this.notebookServer.broadcast(JOB_MANAGER_SERVICE.JOB_MANAGER_PAGE.getKey(), new Message(Message.OP.LIST_UPDATE_NOTE_JOBS).put("noteRunningJobs", response));
        }

        public void onNoteCreate(Note note) {
            Notebook notebook = this.notebookServer.notebook();
            List notebookJobs = notebook.getJobListByNoteId(note.getId());
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("lastResponseUnixTime", System.currentTimeMillis());
            response.put("jobs", notebookJobs);
            this.notebookServer.broadcast(JOB_MANAGER_SERVICE.JOB_MANAGER_PAGE.getKey(), new Message(Message.OP.LIST_UPDATE_NOTE_JOBS).put("noteRunningJobs", response));
        }

        public void onParagraphStatusChange(Paragraph p, Job.Status status) {
            Notebook notebook = this.notebookServer.notebook();
            List notebookJobs = notebook.getJobListByParagraphId(p.getId());
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("lastResponseUnixTime", System.currentTimeMillis());
            response.put("jobs", notebookJobs);
            this.notebookServer.broadcast(JOB_MANAGER_SERVICE.JOB_MANAGER_PAGE.getKey(), new Message(Message.OP.LIST_UPDATE_NOTE_JOBS).put("noteRunningJobs", response));
        }

        public void onUnbindInterpreter(Note note, InterpreterSetting setting) {
            Notebook notebook = this.notebookServer.notebook();
            List notebookJobs = notebook.getJobListByNoteId(note.getId());
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("lastResponseUnixTime", System.currentTimeMillis());
            response.put("jobs", notebookJobs);
            this.notebookServer.broadcast(JOB_MANAGER_SERVICE.JOB_MANAGER_PAGE.getKey(), new Message(Message.OP.LIST_UPDATE_NOTE_JOBS).put("noteRunningJobs", response));
        }
    }

    protected static enum JOB_MANAGER_SERVICE {
        JOB_MANAGER_PAGE("JOB_MANAGER_PAGE");

        private String serviceTypeKey;

        private JOB_MANAGER_SERVICE(String serviceType) {
            this.serviceTypeKey = serviceType;
        }

        String getKey() {
            return this.serviceTypeKey;
        }
    }
}

