/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.realm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.PagedResultsControl;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.crypto.hash.Hash;
import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.crypto.hash.HashService;
import org.apache.shiro.realm.ldap.JndiLdapRealm;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.realm.ldap.LdapUtils;
import org.apache.shiro.subject.MutablePrincipalCollection;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapRealm
extends JndiLdapRealm {
    private static final SearchControls SUBTREE_SCOPE = new SearchControls();
    private static final SearchControls ONELEVEL_SCOPE = new SearchControls();
    private static final SearchControls OBJECT_SCOPE = new SearchControls();
    private static final String SUBJECT_USER_ROLES = "subject.userRoles";
    private static final String SUBJECT_USER_GROUPS = "subject.userGroups";
    private static final String MEMBER_URL = "memberUrl";
    private static final String POSIX_GROUP = "posixGroup";
    private static final String MATCHING_RULE_IN_CHAIN_FORMAT = "(&(objectClass=%s)(%s:1.2.840.113556.1.4.1941:=%s))";
    private static Pattern TEMPLATE_PATTERN = Pattern.compile("\\{(\\d+?)\\}");
    private static String DEFAULT_PRINCIPAL_REGEX = "(.*)";
    private static final String MEMBER_SUBSTITUTION_TOKEN = "{0}";
    private static final String HASHING_ALGORITHM = "SHA-1";
    private static final Logger log = LoggerFactory.getLogger(LdapRealm.class);
    private String searchBase;
    private String userSearchBase;
    private int pagingSize = 100;
    private boolean userLowerCase;
    private String principalRegex = DEFAULT_PRINCIPAL_REGEX;
    private Pattern principalPattern = Pattern.compile(DEFAULT_PRINCIPAL_REGEX);
    private String userDnTemplate = "{0}";
    private String userSearchFilter = null;
    private String userSearchAttributeTemplate = "{0}";
    private String userSearchScope = "subtree";
    private String groupSearchScope = "subtree";
    private boolean groupSearchEnableMatchingRuleInChain;
    private String groupSearchBase;
    private String groupObjectClass = "groupOfNames";
    private String memberAttribute = "member";
    private String groupIdAttribute = "cn";
    private String memberAttributeValuePrefix = "uid={0}";
    private String memberAttributeValueSuffix = "";
    private final Map<String, String> rolesByGroup = new LinkedHashMap<String, String>();
    private final List<String> allowedRolesForAuthentication = new ArrayList<String>();
    private final Map<String, List<String>> permissionsByRole = new LinkedHashMap<String, List<String>>();
    private boolean authorizationEnabled;
    private String userSearchAttributeName;
    private String userObjectClass = "person";
    private HashService hashService = new DefaultHashService();

    public LdapRealm() {
        HashedCredentialsMatcher credentialsMatcher = new HashedCredentialsMatcher(HASHING_ALGORITHM);
        this.setCredentialsMatcher((CredentialsMatcher)credentialsMatcher);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws org.apache.shiro.authc.AuthenticationException {
        return super.doGetAuthenticationInfo(token);
    }

    protected AuthenticationInfo queryForAuthenticationInfo(AuthenticationToken token, LdapContextFactory ldapContextFactory) throws NamingException {
        AuthenticationInfo info = super.queryForAuthenticationInfo(token, ldapContextFactory);
        if (!this.hasAllowedAuthenticationRules(info.getPrincipals(), ldapContextFactory)) {
            throw new NamingException("Principal does not have any of the allowedRolesForAuthentication");
        }
        return info;
    }

    protected AuthorizationInfo queryForAuthorizationInfo(PrincipalCollection principals, LdapContextFactory ldapContextFactory) throws NamingException {
        if (!this.isAuthorizationEnabled()) {
            return null;
        }
        Set<String> roleNames = this.getRoles(principals, ldapContextFactory);
        if (log.isDebugEnabled()) {
            log.debug("RolesNames Authorization: " + roleNames);
        }
        SimpleAuthorizationInfo simpleAuthorizationInfo = new SimpleAuthorizationInfo(roleNames);
        Set<String> stringPermissions = this.permsFor(roleNames);
        simpleAuthorizationInfo.setStringPermissions(stringPermissions);
        return simpleAuthorizationInfo;
    }

    private boolean hasAllowedAuthenticationRules(PrincipalCollection principals, LdapContextFactory ldapContextFactory) throws NamingException {
        boolean allowed = this.allowedRolesForAuthentication.isEmpty();
        if (!allowed) {
            Set<String> roles = this.getRoles(principals, ldapContextFactory);
            for (String allowedRole : this.allowedRolesForAuthentication) {
                if (!roles.contains(allowedRole)) continue;
                log.debug("Allowed role for user [" + allowedRole + "] found.");
                allowed = true;
                break;
            }
        }
        return allowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getRoles(PrincipalCollection principals, LdapContextFactory ldapContextFactory) throws NamingException {
        String username = (String)this.getAvailablePrincipal(principals);
        LdapContext systemLdapCtx = null;
        try {
            systemLdapCtx = ldapContextFactory.getSystemLdapContext();
            Set<String> set = this.rolesFor(principals, username, systemLdapCtx, ldapContextFactory);
            return set;
        }
        catch (AuthenticationException ae) {
            ae.printStackTrace();
            Set<String> set = Collections.emptySet();
            return set;
        }
        finally {
            LdapUtils.closeContext((LdapContext)systemLdapCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> rolesFor(PrincipalCollection principals, String userNameIn, LdapContext ldapCtx, LdapContextFactory ldapContextFactory) throws NamingException {
        String userName;
        HashSet<String> roleNames = new HashSet<String>();
        HashSet<String> groupNames = new HashSet<String>();
        if (this.getUserLowerCase()) {
            log.debug("userLowerCase true");
            userName = userNameIn.toLowerCase();
        } else {
            userName = userNameIn;
        }
        String userDn = this.userSearchAttributeName == null || this.userSearchAttributeName.isEmpty() ? this.memberAttributeValuePrefix + userName + this.memberAttributeValueSuffix : this.getUserDn(userName);
        int pageSize = this.getPagingSize();
        if (log.isDebugEnabled()) {
            log.debug("Ldap PagingSize: " + pageSize);
        }
        int numResults = 0;
        byte[] cookie = null;
        try {
            ldapCtx.addToEnvironment("java.naming.referral", "ignore");
            ldapCtx.setRequestControls(new Control[]{new PagedResultsControl(pageSize, false)});
            do {
                SearchControls searchControls = this.getGroupSearchControls();
                try (NamingEnumeration<SearchResult> searchResultEnum = null;){
                    SearchResult group;
                    if (this.groupSearchEnableMatchingRuleInChain) {
                        searchResultEnum = ldapCtx.search(this.getGroupSearchBase(), String.format(MATCHING_RULE_IN_CHAIN_FORMAT, this.groupObjectClass, this.memberAttribute, userDn), searchControls);
                        while (searchResultEnum != null && searchResultEnum.hasMore()) {
                            ++numResults;
                            group = searchResultEnum.next();
                            Attribute attribute = group.getAttributes().get(this.getGroupIdAttribute());
                            String groupName = attribute.get().toString();
                            String roleName = this.roleNameFor(groupName);
                            if (roleName != null) {
                                roleNames.add(roleName);
                                continue;
                            }
                            roleNames.add(groupName);
                        }
                    } else {
                        searchResultEnum = ldapCtx.search(this.getGroupSearchBase(), "objectClass=" + this.groupObjectClass, searchControls);
                        while (searchResultEnum != null && searchResultEnum.hasMore()) {
                            ++numResults;
                            group = searchResultEnum.next();
                            this.addRoleIfMember(userDn, group, roleNames, groupNames, ldapContextFactory);
                        }
                    }
                }
                ldapCtx.setRequestControls(new Control[]{new PagedResultsControl(pageSize, cookie, true)});
            } while (cookie != null);
        }
        catch (SizeLimitExceededException e) {
            log.info("Only retrieved first " + numResults + " groups due to SizeLimitExceededException.");
        }
        catch (IOException e) {
            log.error("Unabled to setup paged results");
        }
        SecurityUtils.getSubject().getSession().setAttribute((Object)SUBJECT_USER_ROLES, roleNames);
        SecurityUtils.getSubject().getSession().setAttribute((Object)SUBJECT_USER_GROUPS, groupNames);
        if (!groupNames.isEmpty() && principals instanceof MutablePrincipalCollection) {
            ((MutablePrincipalCollection)principals).addAll(groupNames, this.getName());
        }
        if (log.isDebugEnabled()) {
            log.debug("User RoleNames: " + userName + "::" + roleNames);
        }
        return roleNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRoleIfMember(String userDn, SearchResult group, Set<String> roleNames, Set<String> groupNames, LdapContextFactory ldapContextFactory) throws NamingException {
        NamingEnumeration<? extends Attribute> attributeEnum = null;
        NamingEnumeration<?> ne = null;
        try {
            LdapName userLdapDn = new LdapName(userDn);
            Attribute attribute = group.getAttributes().get(this.getGroupIdAttribute());
            String groupName = attribute.get().toString();
            attributeEnum = group.getAttributes().getAll();
            block8: while (attributeEnum.hasMore()) {
                Attribute attr = attributeEnum.next();
                if (!this.memberAttribute.equalsIgnoreCase(attr.getID())) continue;
                ne = attr.getAll();
                while (ne.hasMore()) {
                    String attrValue = ne.next().toString();
                    if (this.memberAttribute.equalsIgnoreCase(MEMBER_URL)) {
                        boolean dynamicGroupMember = this.isUserMemberOfDynamicGroup(userLdapDn, attrValue, ldapContextFactory);
                        if (!dynamicGroupMember) continue;
                        groupNames.add(groupName);
                        String roleName = this.roleNameFor(groupName);
                        if (roleName != null) {
                            roleNames.add(roleName);
                            continue;
                        }
                        roleNames.add(groupName);
                        continue;
                    }
                    if (this.groupObjectClass.equalsIgnoreCase(POSIX_GROUP)) {
                        attrValue = this.memberAttributeValuePrefix + attrValue + this.memberAttributeValueSuffix;
                    }
                    if (!userLdapDn.equals(new LdapName(attrValue))) continue;
                    groupNames.add(groupName);
                    String roleName = this.roleNameFor(groupName);
                    if (roleName != null) {
                        roleNames.add(roleName);
                        continue block8;
                    }
                    roleNames.add(groupName);
                    continue block8;
                }
            }
        }
        finally {
            try {
                if (attributeEnum != null) {
                    attributeEnum.close();
                }
            }
            finally {
                if (ne != null) {
                    ne.close();
                }
            }
        }
    }

    public Map<String, String> getListRoles() {
        Map<String, String> groupToRoles = this.getRolesByGroup();
        HashMap<String, String> roles = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : groupToRoles.entrySet()) {
            roles.put(entry.getValue(), entry.getKey());
        }
        return roles;
    }

    private String roleNameFor(String groupName) {
        return !this.rolesByGroup.isEmpty() ? this.rolesByGroup.get(groupName) : groupName;
    }

    private Set<String> permsFor(Set<String> roleNames) {
        LinkedHashSet<String> perms = new LinkedHashSet<String>();
        for (String role : roleNames) {
            List<String> permsForRole = this.permissionsByRole.get(role);
            if (log.isDebugEnabled()) {
                log.debug("PermsForRole: " + role);
                log.debug("PermByRole: " + permsForRole);
            }
            if (permsForRole == null) continue;
            perms.addAll(permsForRole);
        }
        return perms;
    }

    public String getSearchBase() {
        return this.searchBase;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public String getUserSearchBase() {
        return this.userSearchBase != null && !this.userSearchBase.isEmpty() ? this.userSearchBase : this.searchBase;
    }

    public void setUserSearchBase(String userSearchBase) {
        this.userSearchBase = userSearchBase;
    }

    public int getPagingSize() {
        return this.pagingSize;
    }

    public void setPagingSize(int pagingSize) {
        this.pagingSize = pagingSize;
    }

    public String getGroupSearchBase() {
        return this.groupSearchBase != null && !this.groupSearchBase.isEmpty() ? this.groupSearchBase : this.searchBase;
    }

    public void setGroupSearchBase(String groupSearchBase) {
        this.groupSearchBase = groupSearchBase;
    }

    public String getGroupObjectClass() {
        return this.groupObjectClass;
    }

    public void setGroupObjectClass(String groupObjectClassAttribute) {
        this.groupObjectClass = groupObjectClassAttribute;
    }

    public String getMemberAttribute() {
        return this.memberAttribute;
    }

    public void setMemberAttribute(String memberAttribute) {
        this.memberAttribute = memberAttribute;
    }

    public String getGroupIdAttribute() {
        return this.groupIdAttribute;
    }

    public void setGroupIdAttribute(String groupIdAttribute) {
        this.groupIdAttribute = groupIdAttribute;
    }

    public void setMemberAttributeValueTemplate(String template) {
        if (!StringUtils.hasText((String)template)) {
            String msg = "User DN template cannot be null or empty.";
            throw new IllegalArgumentException(msg);
        }
        int index = template.indexOf(MEMBER_SUBSTITUTION_TOKEN);
        if (index < 0) {
            String msg = "Member attribute value template must contain the '{0}' replacement token to understand how to parse the group members.";
            throw new IllegalArgumentException(msg);
        }
        String prefix = template.substring(0, index);
        String suffix = template.substring(prefix.length() + MEMBER_SUBSTITUTION_TOKEN.length());
        this.memberAttributeValuePrefix = prefix;
        this.memberAttributeValueSuffix = suffix;
    }

    public void setAllowedRolesForAuthentication(List<String> allowedRolesForAuthencation) {
        this.allowedRolesForAuthentication.addAll(allowedRolesForAuthencation);
    }

    public void setRolesByGroup(Map<String, String> rolesByGroup) {
        this.rolesByGroup.putAll(rolesByGroup);
    }

    public Map<String, String> getRolesByGroup() {
        return this.rolesByGroup;
    }

    public void setPermissionsByRole(String permissionsByRoleStr) {
        this.permissionsByRole.putAll(this.parsePermissionByRoleString(permissionsByRoleStr));
    }

    public Map<String, List<String>> getPermissionsByRole() {
        return this.permissionsByRole;
    }

    public boolean isAuthorizationEnabled() {
        return this.authorizationEnabled;
    }

    public void setAuthorizationEnabled(boolean authorizationEnabled) {
        this.authorizationEnabled = authorizationEnabled;
    }

    public String getUserSearchAttributeName() {
        return this.userSearchAttributeName;
    }

    public void setUserSearchAttributeName(String userSearchAttributeName) {
        if (userSearchAttributeName != null) {
            userSearchAttributeName = userSearchAttributeName.trim();
        }
        this.userSearchAttributeName = userSearchAttributeName;
    }

    public String getUserObjectClass() {
        return this.userObjectClass;
    }

    public void setUserObjectClass(String userObjectClass) {
        this.userObjectClass = userObjectClass;
    }

    private Map<String, List<String>> parsePermissionByRoleString(String permissionsByRoleStr) {
        HashMap<String, List<String>> perms = new HashMap<String, List<String>>();
        StringTokenizer stSem = new StringTokenizer(permissionsByRoleStr, ";");
        while (stSem.hasMoreTokens()) {
            String roleAndPerm = stSem.nextToken();
            StringTokenizer stEq = new StringTokenizer(roleAndPerm, "=");
            if (stEq.countTokens() != 2) continue;
            String role = stEq.nextToken().trim();
            String perm = stEq.nextToken().trim();
            StringTokenizer stCom = new StringTokenizer(perm, ",");
            ArrayList<String> permList = new ArrayList<String>();
            while (stCom.hasMoreTokens()) {
                permList.add(stCom.nextToken().trim());
            }
            perms.put(role, permList);
        }
        return perms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isUserMemberOfDynamicGroup(LdapName userLdapDn, String memberUrl, LdapContextFactory ldapContextFactory) throws NamingException {
        if (memberUrl == null) {
            return false;
        }
        String[] tokens = memberUrl.split("\\?");
        if (tokens.length < 4) {
            return false;
        }
        String searchBaseString = tokens[0].substring(tokens[0].lastIndexOf("/") + 1);
        String searchScope = tokens[2];
        String searchFilter = tokens[3];
        LdapName searchBaseDn = new LdapName(searchBaseString);
        if (searchScope.equalsIgnoreCase("base")) {
            log.debug("DynamicGroup SearchScope base");
            return false;
        }
        if (!userLdapDn.toString().endsWith(searchBaseDn.toString())) {
            return false;
        }
        if (searchScope.equalsIgnoreCase("one") && userLdapDn.size() != searchBaseDn.size() - 1) {
            log.debug("DynamicGroup SearchScope one");
            return false;
        }
        LdapContext systemLdapCtx = null;
        systemLdapCtx = ldapContextFactory.getSystemLdapContext();
        boolean member = false;
        NamingEnumeration<SearchResult> searchResultEnum = null;
        try {
            searchResultEnum = systemLdapCtx.search((Name)userLdapDn, searchFilter, searchScope.equalsIgnoreCase("sub") ? SUBTREE_SCOPE : ONELEVEL_SCOPE);
            if (searchResultEnum.hasMore()) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            try {
                if (searchResultEnum != null) {
                    searchResultEnum.close();
                }
            }
            finally {
                LdapUtils.closeContext((LdapContext)systemLdapCtx);
            }
        }
        return member;
    }

    public String getPrincipalRegex() {
        return this.principalRegex;
    }

    public void setPrincipalRegex(String regex) {
        if (regex == null || regex.trim().isEmpty()) {
            this.principalPattern = Pattern.compile(DEFAULT_PRINCIPAL_REGEX);
            this.principalRegex = DEFAULT_PRINCIPAL_REGEX;
        } else {
            Pattern pattern;
            regex = regex.trim();
            this.principalPattern = pattern = Pattern.compile(regex);
            this.principalRegex = regex;
        }
    }

    public String getUserSearchAttributeTemplate() {
        return this.userSearchAttributeTemplate;
    }

    public void setUserSearchAttributeTemplate(String template) {
        this.userSearchAttributeTemplate = template == null ? null : template.trim();
    }

    public String getUserSearchFilter() {
        return this.userSearchFilter;
    }

    public void setUserSearchFilter(String filter) {
        this.userSearchFilter = filter == null ? null : filter.trim();
    }

    public boolean getUserLowerCase() {
        return this.userLowerCase;
    }

    public void setUserLowerCase(boolean userLowerCase) {
        this.userLowerCase = userLowerCase;
    }

    public String getUserSearchScope() {
        return this.userSearchScope;
    }

    public void setUserSearchScope(String scope) {
        this.userSearchScope = scope == null ? null : scope.trim().toLowerCase();
    }

    public String getGroupSearchScope() {
        return this.groupSearchScope;
    }

    public void setGroupSearchScope(String scope) {
        this.groupSearchScope = scope == null ? null : scope.trim().toLowerCase();
    }

    public boolean isGroupSearchEnableMatchingRuleInChain() {
        return this.groupSearchEnableMatchingRuleInChain;
    }

    public void setGroupSearchEnableMatchingRuleInChain(boolean groupSearchEnableMatchingRuleInChain) {
        this.groupSearchEnableMatchingRuleInChain = groupSearchEnableMatchingRuleInChain;
    }

    private SearchControls getUserSearchControls() {
        SearchControls searchControls = SUBTREE_SCOPE;
        if ("onelevel".equalsIgnoreCase(this.userSearchScope)) {
            searchControls = ONELEVEL_SCOPE;
        } else if ("object".equalsIgnoreCase(this.userSearchScope)) {
            searchControls = OBJECT_SCOPE;
        }
        return searchControls;
    }

    private SearchControls getGroupSearchControls() {
        SearchControls searchControls = SUBTREE_SCOPE;
        if ("onelevel".equalsIgnoreCase(this.groupSearchScope)) {
            searchControls = ONELEVEL_SCOPE;
        } else if ("object".equalsIgnoreCase(this.groupSearchScope)) {
            searchControls = OBJECT_SCOPE;
        }
        return searchControls;
    }

    public void setUserDnTemplate(String template) throws IllegalArgumentException {
        this.userDnTemplate = template;
    }

    private Matcher matchPrincipal(String principal) {
        Matcher matchedPrincipal = this.principalPattern.matcher(principal);
        if (!matchedPrincipal.matches()) {
            throw new IllegalArgumentException("Principal " + principal + " does not match " + this.principalRegex);
        }
        return matchedPrincipal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getUserDn(String principal) throws IllegalArgumentException, IllegalStateException {
        Matcher matchedPrincipal = this.matchPrincipal(principal);
        String userSearchBase = this.getUserSearchBase();
        String userSearchAttributeName = this.getUserSearchAttributeName();
        if (userSearchBase == null || userSearchBase.isEmpty() || userSearchAttributeName == null && this.userSearchFilter == null && !"object".equalsIgnoreCase(this.userSearchScope)) {
            String userDn = LdapRealm.expandTemplate(this.userDnTemplate, matchedPrincipal);
            if (log.isDebugEnabled()) {
                log.debug("LDAP UserDN and Principal: " + userDn + "," + principal);
            }
            return userDn;
        }
        String searchBase = LdapRealm.expandTemplate(this.getUserSearchBase(), matchedPrincipal);
        String searchFilter = null;
        searchFilter = this.userSearchFilter == null ? (userSearchAttributeName == null ? String.format("(objectclass=%1$s)", this.getUserObjectClass()) : String.format("(&(objectclass=%1$s)(%2$s=%3$s))", this.getUserObjectClass(), userSearchAttributeName, LdapRealm.expandTemplate(this.getUserSearchAttributeTemplate(), matchedPrincipal))) : LdapRealm.expandTemplate(this.userSearchFilter, matchedPrincipal);
        SearchControls searchControls = this.getUserSearchControls();
        LdapContext systemLdapCtx = null;
        NamingEnumeration<SearchResult> searchResultEnum = null;
        try {
            systemLdapCtx = this.getContextFactory().getSystemLdapContext();
            if (log.isDebugEnabled()) {
                log.debug("SearchBase,SearchFilter,UserSearchScope: " + searchBase + "," + searchFilter + "," + this.userSearchScope);
            }
            if ((searchResultEnum = systemLdapCtx.search(searchBase, searchFilter, searchControls)).hasMore()) {
                SearchResult searchResult = searchResultEnum.next();
                String userDn = searchResult.getNameInNamespace();
                if (log.isDebugEnabled()) {
                    log.debug("UserDN Returned,Principal: " + userDn + "," + principal);
                }
                String string = userDn;
                return string;
            }
            try {
                throw new IllegalArgumentException("Illegal principal name: " + principal);
            }
            catch (AuthenticationException ne) {
                ne.printStackTrace();
                throw new IllegalArgumentException("Illegal principal name: " + principal);
            }
            catch (NamingException ne) {
                throw new IllegalArgumentException("Hit NamingException: " + ne.getMessage());
            }
        }
        finally {
            try {
                if (searchResultEnum != null) {
                    searchResultEnum.close();
                }
            }
            catch (NamingException namingException) {
            }
            finally {
                LdapUtils.closeContext((LdapContext)systemLdapCtx);
            }
        }
    }

    protected AuthenticationInfo createAuthenticationInfo(AuthenticationToken token, Object ldapPrincipal, Object ldapCredentials, LdapContext ldapContext) throws NamingException {
        HashRequest.Builder builder = new HashRequest.Builder();
        Hash credentialsHash = this.hashService.computeHash(builder.setSource(token.getCredentials()).setAlgorithmName(HASHING_ALGORITHM).build());
        return new SimpleAuthenticationInfo(token.getPrincipal(), (Object)credentialsHash.toHex(), credentialsHash.getSalt(), this.getName());
    }

    private static final String expandTemplate(String template, Matcher input) {
        String output = template;
        Matcher matcher = TEMPLATE_PATTERN.matcher(output);
        while (matcher.find()) {
            String lookupStr = matcher.group(1);
            int lookupIndex = Integer.parseInt(lookupStr);
            String lookupValue = input.group(lookupIndex);
            output = matcher.replaceFirst(lookupValue == null ? "" : lookupValue);
            matcher = TEMPLATE_PATTERN.matcher(output);
        }
        return output;
    }

    static {
        SUBTREE_SCOPE.setSearchScope(2);
        ONELEVEL_SCOPE.setSearchScope(1);
        OBJECT_SCOPE.setSearchScope(0);
    }
}

