/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.zeppelin.helium.Helium;
import org.apache.zeppelin.helium.HeliumPackage;
import org.apache.zeppelin.helium.HeliumPackageSuggestion;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.server.JsonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/helium")
@Produces(value={"application/json"})
public class HeliumRestApi {
    Logger logger = LoggerFactory.getLogger(HeliumRestApi.class);
    private Helium helium;
    private Notebook notebook;
    private Gson gson = new Gson();

    public HeliumRestApi() {
    }

    public HeliumRestApi(Helium helium, Notebook notebook) {
        this.helium = helium;
        this.notebook = notebook;
    }

    @GET
    @Path(value="all")
    public Response getAll() {
        return new JsonResponse<Map>(Response.Status.OK, "", this.helium.getAllPackageInfo()).build();
    }

    @GET
    @Path(value="suggest/{noteId}/{paragraphId}")
    public Response suggest(@PathParam(value="noteId") String noteId, @PathParam(value="paragraphId") String paragraphId) {
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "Note " + noteId + " not found").build();
        }
        Paragraph paragraph = note.getParagraph(paragraphId);
        if (paragraph == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "Paragraph " + paragraphId + " not found").build();
        }
        return new JsonResponse<HeliumPackageSuggestion>(Response.Status.OK, "", this.helium.suggestApp(paragraph)).build();
    }

    @POST
    @Path(value="load/{noteId}/{paragraphId}")
    public Response suggest(@PathParam(value="noteId") String noteId, @PathParam(value="paragraphId") String paragraphId, String heliumPackage) {
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "Note " + noteId + " not found").build();
        }
        Paragraph paragraph = note.getParagraph(paragraphId);
        if (paragraph == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "Paragraph " + paragraphId + " not found").build();
        }
        HeliumPackage pkg = (HeliumPackage)this.gson.fromJson(heliumPackage, HeliumPackage.class);
        String appId = this.helium.getApplicationFactory().loadAndRun(pkg, paragraph);
        return new JsonResponse<String>(Response.Status.OK, "", appId).build();
    }

    @GET
    @Path(value="visualizations/load")
    @Produces(value={"text/javascript"})
    public Response visualizationLoad(@QueryParam(value="refresh") String refresh) {
        try {
            File bundle = refresh != null && refresh.equals("true") ? this.helium.recreateVisualizationBundle() : this.helium.getVisualizationFactory().getCurrentBundle();
            if (bundle == null) {
                return Response.ok().build();
            }
            String visBundle = FileUtils.readFileToString((File)bundle);
            return Response.ok((Object)visBundle).build();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return Response.ok((Object)("ERROR: " + e.getMessage())).build();
        }
    }

    @POST
    @Path(value="enable/{packageName}")
    public Response enablePackage(@PathParam(value="packageName") String packageName, String artifact) {
        try {
            this.helium.enable(packageName, artifact);
            return new JsonResponse(Response.Status.OK).build();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new JsonResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage()).build();
        }
    }

    @POST
    @Path(value="disable/{packageName}")
    public Response enablePackage(@PathParam(value="packageName") String packageName) {
        try {
            this.helium.disable(packageName);
            return new JsonResponse(Response.Status.OK).build();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new JsonResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage()).build();
        }
    }

    @GET
    @Path(value="visualizationOrder")
    public Response getVisualizationPackageOrder() {
        List order = this.helium.getVisualizationPackageOrder();
        return new JsonResponse<List>(Response.Status.OK, order).build();
    }

    @POST
    @Path(value="visualizationOrder")
    public Response setVisualizationPackageOrder(String orderedPackageNameList) {
        List orderedList = (List)this.gson.fromJson(orderedPackageNameList, new TypeToken<List<String>>(){}.getType());
        try {
            this.helium.setVisualizationPackageOrder(orderedList);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new JsonResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage()).build();
        }
        return new JsonResponse(Response.Status.OK).build();
    }
}

