/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.realm.jwt;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.zeppelin.realm.jwt.KnoxJwtRealm;
import org.apache.zeppelin.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnoxAuthenticationFilter
extends FormAuthenticationFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnoxAuthenticationFilter.class);

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        Boolean accessAllowed = super.isAccessAllowed(request, response, mappedValue) || !this.isLoginRequest(request, response) && this.isPermissive(mappedValue);
        if (accessAllowed.booleanValue()) {
            accessAllowed = false;
            KnoxJwtRealm knoxJwtRealm = null;
            for (Object realm : SecurityUtils.getRealmsList()) {
                if (!(realm instanceof KnoxJwtRealm)) continue;
                knoxJwtRealm = (KnoxJwtRealm)((Object)realm);
                break;
            }
            if (knoxJwtRealm != null) {
                for (Cookie cookie : ((ShiroHttpServletRequest)request).getCookies()) {
                    if (!cookie.getName().equals(knoxJwtRealm.getCookieName())) continue;
                    if (knoxJwtRealm.validateToken(cookie.getValue())) {
                        accessAllowed = true;
                    }
                    break;
                }
            } else {
                LOGGER.error("Looks like this filter is enabled without enabling KnoxJwtRealm, please refer to https://zeppelin.apache.org/docs/latest/security/shiroauthentication.html#knox-sso");
            }
        }
        return accessAllowed;
    }
}

