/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import com.google.gson.Gson;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.Subject;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.notebook.NotebookAuthorization;
import org.apache.zeppelin.realm.jwt.JWTAuthenticationToken;
import org.apache.zeppelin.realm.jwt.KnoxJwtRealm;
import org.apache.zeppelin.server.JsonResponse;
import org.apache.zeppelin.ticket.TicketContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/login")
@Produces(value={"application/json"})
public class LoginRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(LoginRestApi.class);
    private static final Gson gson = new Gson();

    @GET
    @ZeppelinApi
    public Response getLogin(@Context HttpHeaders headers) {
        JsonResponse response = null;
        if (this.isKnoxSSOEnabled()) {
            KnoxJwtRealm knoxJwtRealm = this.getJTWRealm();
            Cookie cookie = (Cookie)headers.getCookies().get(knoxJwtRealm.getCookieName());
            if (cookie != null && cookie.getValue() != null) {
                Subject currentUser = SecurityUtils.getSubject();
                JWTAuthenticationToken token = new JWTAuthenticationToken(null, cookie.getValue());
                try {
                    String name = knoxJwtRealm.getName(token);
                    if (!currentUser.isAuthenticated() || !currentUser.getPrincipal().equals(name)) {
                        response = this.proceedToLogin(currentUser, token);
                    }
                }
                catch (ParseException e) {
                    LOG.error("ParseException in LoginRestApi: ", (Throwable)e);
                }
            }
            if (response == null) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("redirectURL", this.constructKnoxUrl(knoxJwtRealm, knoxJwtRealm.getLogin()));
                response = new JsonResponse(Response.Status.OK, "", data);
            }
            return response.build();
        }
        return new JsonResponse(Response.Status.METHOD_NOT_ALLOWED).build();
    }

    private KnoxJwtRealm getJTWRealm() {
        Collection realmsList = org.apache.zeppelin.utils.SecurityUtils.getRealmsList();
        if (realmsList != null) {
            for (Realm realm : realmsList) {
                String name = realm.getClass().getName();
                LOG.debug("RealmClass.getName: " + name);
                if (!name.equals("org.apache.zeppelin.realm.jwt.KnoxJwtRealm")) continue;
                return (KnoxJwtRealm)realm;
            }
        }
        return null;
    }

    private boolean isKnoxSSOEnabled() {
        Collection realmsList = org.apache.zeppelin.utils.SecurityUtils.getRealmsList();
        if (realmsList != null) {
            for (Realm realm : realmsList) {
                String name = realm.getClass().getName();
                LOG.debug("RealmClass.getName: " + name);
                if (!name.equals("org.apache.zeppelin.realm.jwt.KnoxJwtRealm")) continue;
                return true;
            }
        }
        return false;
    }

    private JsonResponse proceedToLogin(Subject currentUser, AuthenticationToken token) {
        JsonResponse response = null;
        try {
            this.logoutCurrentUser();
            currentUser.getSession(true);
            currentUser.login(token);
            HashSet<String> roles = org.apache.zeppelin.utils.SecurityUtils.getRoles();
            String principal = org.apache.zeppelin.utils.SecurityUtils.getPrincipal();
            String ticket = "anonymous".equals(principal) ? "anonymous" : TicketContainer.instance.getTicket(principal);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("principal", principal);
            data.put("roles", gson.toJson(roles));
            data.put("ticket", ticket);
            response = new JsonResponse(Response.Status.OK, "", data);
            NotebookAuthorization.getInstance().setRoles(principal, roles);
        }
        catch (UnknownAccountException uae) {
            LOG.error("Exception in login: ", (Throwable)uae);
        }
        catch (IncorrectCredentialsException ice) {
            LOG.error("Exception in login: ", (Throwable)ice);
        }
        catch (LockedAccountException lae) {
            LOG.error("Exception in login: ", (Throwable)lae);
        }
        catch (AuthenticationException ae) {
            LOG.error("Exception in login: ", (Throwable)ae);
        }
        return response;
    }

    @POST
    @ZeppelinApi
    public Response postLogin(@FormParam(value="userName") String userName, @FormParam(value="password") String password) {
        JsonResponse response = null;
        Subject currentUser = SecurityUtils.getSubject();
        if (currentUser.isAuthenticated()) {
            currentUser.logout();
        }
        if (!currentUser.isAuthenticated()) {
            UsernamePasswordToken token = new UsernamePasswordToken(userName, password);
            response = this.proceedToLogin(currentUser, (AuthenticationToken)token);
        }
        if (response == null) {
            response = new JsonResponse(Response.Status.FORBIDDEN, "", "");
        }
        LOG.warn(response.toString());
        return response.build();
    }

    @POST
    @Path(value="logout")
    @ZeppelinApi
    public Response logout() {
        JsonResponse<Object> response;
        this.logoutCurrentUser();
        if (this.isKnoxSSOEnabled()) {
            KnoxJwtRealm knoxJwtRealm = this.getJTWRealm();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("redirectURL", this.constructKnoxUrl(knoxJwtRealm, knoxJwtRealm.getLogout()));
            data.put("isLogoutAPI", knoxJwtRealm.getLogoutAPI().toString());
            response = new JsonResponse(Response.Status.UNAUTHORIZED, "", data);
        } else {
            response = new JsonResponse<String>(Response.Status.UNAUTHORIZED, "", "");
        }
        LOG.warn(response.toString());
        return response.build();
    }

    private String constructKnoxUrl(KnoxJwtRealm knoxJwtRealm, String path) {
        StringBuilder redirectURL = new StringBuilder(knoxJwtRealm.getProviderUrl());
        redirectURL.append(path);
        if (knoxJwtRealm.getRedirectParam() != null) {
            redirectURL.append("?").append(knoxJwtRealm.getRedirectParam()).append("=");
        }
        return redirectURL.toString();
    }

    private void logoutCurrentUser() {
        Subject currentUser = SecurityUtils.getSubject();
        TicketContainer.instance.removeTicket(org.apache.zeppelin.utils.SecurityUtils.getPrincipal());
        currentUser.getSession().stop();
        currentUser.logout();
    }
}

