/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.shell;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.KerberosInterpreter;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.apache.zeppelin.util.ExecutorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellInterpreter
extends KerberosInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShellInterpreter.class);
    private static final String TIMEOUT_PROPERTY = "shell.command.timeout.millisecs";
    private static final String TIMEOUT_CHECK_INTERVAL_PROPERTY = "shell.command.timeout.check.interval";
    private static final String DEFAULT_TIMEOUT = "60000";
    private static final String DEFAULT_CHECK_INTERVAL = "10000";
    private static final String DIRECTORY_USER_HOME = "shell.working.directory.user.home";
    private static final String MAX_CONCURRENCY = "shell.concurrency.max";
    private final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    private final String shell = this.isWindows ? "cmd /c" : "bash -c";
    private ConcurrentHashMap<String, DefaultExecutor> executorMap;
    private ConcurrentHashMap<String, InterpreterContext> contextMap;
    private ScheduledExecutorService shellOutputCheckExecutor = Executors.newSingleThreadScheduledExecutor();

    public ShellInterpreter(Properties property) {
        super(property);
    }

    public void open() {
        super.open();
        long timeoutThreshold = Long.parseLong(this.getProperty(TIMEOUT_PROPERTY, DEFAULT_TIMEOUT));
        long timeoutCheckInterval = Long.parseLong(this.getProperty(TIMEOUT_CHECK_INTERVAL_PROPERTY, DEFAULT_CHECK_INTERVAL));
        LOGGER.info("Command timeout property: {}", (Object)timeoutThreshold);
        this.executorMap = new ConcurrentHashMap();
        this.contextMap = new ConcurrentHashMap();
        this.shellOutputCheckExecutor.scheduleAtFixedRate(() -> {
            try {
                for (Map.Entry<String, DefaultExecutor> entry : this.executorMap.entrySet()) {
                    String paragraphId = entry.getKey();
                    DefaultExecutor executor = entry.getValue();
                    InterpreterContext context = this.contextMap.get(paragraphId);
                    if (context == null) {
                        LOGGER.warn("No InterpreterContext associated with paragraph: {}", (Object)paragraphId);
                        continue;
                    }
                    if (System.currentTimeMillis() - context.out.getLastWriteTimestamp() <= timeoutThreshold) continue;
                    LOGGER.info("No output for paragraph {} for the last {} milli-seconds, so kill it", (Object)paragraphId, (Object)timeoutThreshold);
                    executor.getWatchdog().destroyProcess();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error when checking shell command timeout", (Throwable)e);
            }
        }, timeoutCheckInterval, timeoutCheckInterval, TimeUnit.MILLISECONDS);
    }

    public void close() {
        super.close();
        for (String executorKey : this.executorMap.keySet()) {
            DefaultExecutor executor = this.executorMap.remove(executorKey);
            if (executor == null) continue;
            try {
                executor.getWatchdog().destroyProcess();
            }
            catch (Exception e) {
                LOGGER.error("error destroying executor for paragraphId: " + executorKey, (Throwable)e);
            }
        }
        if (this.shellOutputCheckExecutor != null) {
            ExecutorUtil.softShutdown((String)"ShellOutputCheckExecutor", (ExecutorService)this.shellOutputCheckExecutor, (int)5, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    protected boolean isInterpolate() {
        return Boolean.parseBoolean(this.getProperty("zeppelin.shell.interpolation", "false"));
    }

    public ZeppelinContext getZeppelinContext() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpreterResult internalInterpret(String cmd, InterpreterContext context) {
        LOGGER.debug("Run shell command '{}'", (Object)cmd);
        CommandLine cmdLine = CommandLine.parse((String)this.shell);
        if (this.isWindows) {
            Object[] lines = StringUtils.split((String)cmd, (String)"\n");
            cmd = StringUtils.join((Object[])lines, (String)" && ");
        }
        cmdLine.addArgument(cmd, false);
        try {
            this.contextMap.put(context.getParagraphId(), context);
            DefaultExecutor executor = new DefaultExecutor();
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)context.out, (OutputStream)context.out));
            executor.setWatchdog(new ExecuteWatchdog(Long.MAX_VALUE));
            this.executorMap.put(context.getParagraphId(), executor);
            if (Boolean.valueOf(this.getProperty(DIRECTORY_USER_HOME)).booleanValue()) {
                executor.setWorkingDirectory(new File(System.getProperty("user.home")));
            }
            int exitVal = executor.execute(cmdLine);
            LOGGER.info("Paragraph {} return with exit value: {}", (Object)context.getParagraphId(), (Object)exitVal);
            if (exitVal == 0) {
                InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.SUCCESS);
                return interpreterResult;
            }
            InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR);
            return interpreterResult;
        }
        catch (ExecuteException e) {
            int exitValue = e.getExitValue();
            LOGGER.error("Can not run command: " + cmd, (Throwable)e);
            InterpreterResult.Code code = InterpreterResult.Code.ERROR;
            StringBuilder messageBuilder = new StringBuilder();
            if (exitValue == 143) {
                code = InterpreterResult.Code.INCOMPLETE;
                messageBuilder.append("Paragraph received a SIGTERM\n");
                LOGGER.info("The paragraph {} stopped executing: {}", (Object)context.getParagraphId(), (Object)messageBuilder.toString());
            }
            messageBuilder.append("ExitValue: " + exitValue);
            InterpreterResult interpreterResult = new InterpreterResult(code, messageBuilder.toString());
            return interpreterResult;
        }
        catch (IOException e) {
            LOGGER.error("Can not run command: " + cmd, (Throwable)e);
            InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, e.getMessage());
            return interpreterResult;
        }
        finally {
            this.executorMap.remove(context.getParagraphId());
            this.contextMap.remove(context.getParagraphId());
        }
    }

    public void cancel(InterpreterContext context) {
        DefaultExecutor executor = this.executorMap.remove(context.getParagraphId());
        if (executor != null) {
            try {
                executor.getWatchdog().destroyProcess();
            }
            catch (Exception e) {
                LOGGER.error("error destroying executor for paragraphId: " + context.getParagraphId(), (Throwable)e);
            }
        }
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetParallelScheduler(ShellInterpreter.class.getName() + ((Object)((Object)this)).hashCode(), this.getMaxConcurrent());
    }

    private int getMaxConcurrent() {
        String maxConcurrencyProperty = this.getProperty(MAX_CONCURRENCY, "10");
        try {
            return Integer.valueOf(maxConcurrencyProperty);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Fail to parse {} with value: {}", (Object)MAX_CONCURRENCY, (Object)maxConcurrencyProperty);
            return 10;
        }
    }

    protected boolean runKerberosLogin() {
        try {
            this.createSecureConfiguration();
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Unable to run kinit for zeppelin", (Throwable)e);
            return false;
        }
    }

    public ConcurrentHashMap<String, DefaultExecutor> getExecutorMap() {
        return this.executorMap;
    }

    public void createSecureConfiguration() throws InterpreterException {
        Properties properties = this.getProperties();
        CommandLine cmdLine = CommandLine.parse((String)this.shell);
        cmdLine.addArgument("-c", false);
        String kinitCommand = String.format("kinit -k -t %s %s", properties.getProperty("zeppelin.shell.keytab.location"), properties.getProperty("zeppelin.shell.principal"));
        cmdLine.addArgument(kinitCommand, false);
        DefaultExecutor executor = new DefaultExecutor();
        try {
            executor.execute(cmdLine);
        }
        catch (Exception e) {
            LOGGER.error("Unable to run kinit for zeppelin user " + kinitCommand, (Throwable)e);
            throw new InterpreterException((Throwable)e);
        }
    }

    protected boolean isKerboseEnabled() {
        return StringUtils.isNotBlank((CharSequence)this.getProperty("zeppelin.shell.auth.type")) && this.getProperty("zeppelin.shell.auth.type").equalsIgnoreCase("kerberos");
    }
}

