/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.shell.terminal.service;

import com.google.gson.Gson;
import com.pty4j.PtyProcess;
import com.pty4j.WinSize;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import javax.websocket.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.shell.terminal.helper.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TerminalService.class);
    private String[] termCommand;
    private PtyProcess process;
    private Integer columns = 20;
    private Integer rows = 10;
    private BufferedReader inputReader;
    private BufferedReader errorReader;
    private BufferedWriter outputWriter;
    private Session webSocketSession;
    private LinkedBlockingQueue<String> commandQueue = new LinkedBlockingQueue();

    public void onTerminalInit() {
        LOGGER.info("onTerminalInit");
    }

    public void onTerminalReady() {
        TerminalService.startThread(() -> {
            try {
                this.initializeProcess();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    private void initializeProcess() throws Exception {
        LOGGER.info("initialize TerminalService Process");
        String userHome = System.getProperty("user.home");
        Path dataDir = Paths.get(userHome, new String[0]).resolve(".terminalfx");
        IOHelper.copyLibPty(dataDir);
        boolean isWindows = System.getProperty("os.name").startsWith("Windows");
        this.termCommand = isWindows ? "cmd.exe".split("\\s+") : "/bin/bash -i".split("\\s+");
        HashMap<String, String> envs = new HashMap<String, String>(System.getenv());
        envs.put("TERM", "xterm");
        System.setProperty("PTY_LIB_FOLDER", dataDir.resolve("libpty").toString());
        this.process = PtyProcess.exec((String[])this.termCommand, envs, (String)userHome);
        this.process.setWinSize(new WinSize(this.columns.intValue(), this.rows.intValue()));
        this.inputReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        this.errorReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
        this.outputWriter = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream()));
        TerminalService.startThread(() -> this.printReader(this.inputReader));
        TerminalService.startThread(() -> this.printReader(this.errorReader));
        this.process.waitFor();
    }

    private void print(String text) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", "TERMINAL_PRINT");
        map.put("text", text);
        Gson gson = new Gson();
        String message = gson.toJson(map);
        this.webSocketSession.getBasicRemote().sendText(message);
    }

    private void printReader(BufferedReader bufferedReader) {
        try {
            int nRead;
            char[] data = new char[10240];
            while ((nRead = bufferedReader.read(data, 0, data.length)) != -1) {
                StringBuilder builder = new StringBuilder(nRead);
                builder.append(data, 0, nRead);
                this.print(builder.toString());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void onCommand(String command) {
        if (null == command || StringUtils.isEmpty((CharSequence)command)) {
            return;
        }
        try {
            this.commandQueue.put(command);
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        TerminalService.startThread(() -> {
            try {
                this.outputWriter.write(this.commandQueue.poll());
                this.outputWriter.flush();
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    public void onTerminalResize(String columns, String rows) {
        if (Objects.nonNull(columns) && Objects.nonNull(rows)) {
            this.columns = Integer.valueOf(columns);
            this.rows = Integer.valueOf(rows);
            if (Objects.nonNull(this.process)) {
                this.process.setWinSize(new WinSize(this.columns.intValue(), this.rows.intValue()));
            }
        }
    }

    public void onWebSocketConnect(Session webSocketSession) {
        this.webSocketSession = webSocketSession;
        webSocketSession.setMaxIdleTimeout(3600000L);
    }

    public static void startThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.start();
    }
}

