/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.shell;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hubspot.jinjava.Jinjava;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessageOutput;
import org.apache.zeppelin.interpreter.KerberosInterpreter;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.apache.zeppelin.shell.terminal.TerminalManager;
import org.apache.zeppelin.shell.terminal.TerminalThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalInterpreter
extends KerberosInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TerminalInterpreter.class);
    private TerminalThread terminalThread = null;
    private InterpreterContext intpContext;
    private int terminalPort = 0;
    private HashMap<String, String> mapIpMapping = new HashMap();
    private Gson gson = new Gson();
    public static final String TERMINAL_SOCKET_STATUS = "TERMINAL_SOCKET_STATUS";
    public static final String TERMINAL_SOCKET_CONNECT = "TERMINAL_SOCKET_CONNECT";
    public static final String TERMINAL_SOCKET_CLOSE = "TERMINAL_SOCKET_CLOSE";
    public static final String TERMINAL_SOCKET_ERROR = "TERMINAL_SOCKET_ERROR";

    public TerminalInterpreter(Properties property) {
        super(property);
    }

    public void open() {
        super.open();
    }

    private void setParagraphConfig() {
        this.intpContext.getConfig().put("editorHide", true);
        this.intpContext.getConfig().put("title", false);
    }

    public void close() {
        this.intpContext.getAngularObjectRegistry().add(TERMINAL_SOCKET_STATUS, (Object)TERMINAL_SOCKET_CLOSE, this.intpContext.getNoteId(), this.intpContext.getParagraphId());
        if (null != this.terminalThread) {
            TerminalManager.getInstance().cleanIntpContext(this.intpContext.getNoteId());
            this.terminalThread.stopRunning();
        }
        super.close();
    }

    public ZeppelinContext getZeppelinContext() {
        return null;
    }

    public InterpreterResult internalInterpret(String cmd, InterpreterContext context) {
        this.intpContext = context;
        TerminalManager.getInstance().setInterpreterContext(context);
        if (null == this.terminalThread) {
            try {
                this.terminalPort = RemoteInterpreterUtils.findRandomAvailablePortOnAllLocalInterfaces();
                this.terminalThread = new TerminalThread(this.terminalPort);
                this.terminalThread.start();
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return new InterpreterResult(InterpreterResult.Code.ERROR, e.getMessage());
            }
            for (int i = 0; i < 10 && !this.terminalThread.isRunning(); ++i) {
                try {
                    LOGGER.info("loop = " + i);
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            if (!this.terminalThread.isRunning()) {
                LOGGER.error("Terminal interpreter can not running!");
            }
        }
        this.setParagraphConfig();
        Properties properties = this.getProperties();
        String strIpMapping = properties.getProperty("zeppelin.terminal.ip.mapping");
        if (!StringUtils.isEmpty((CharSequence)strIpMapping)) {
            this.mapIpMapping = (HashMap)this.gson.fromJson(strIpMapping, new TypeToken<Map<String, String>>(){}.getType());
        }
        this.createTerminalDashboard(context.getNoteId(), context.getParagraphId(), this.terminalPort);
        return new InterpreterResult(InterpreterResult.Code.SUCCESS);
    }

    public void createTerminalDashboard(String noteId, String paragraphId, int port) {
        String hostName = "";
        String hostIp = "";
        URL urlTemplate = Resources.getResource((String)"ui_templates/terminal-dashboard.jinja");
        String template = null;
        try {
            template = Resources.toString((URL)urlTemplate, (Charset)Charsets.UTF_8);
            InetAddress addr = InetAddress.getLocalHost();
            hostName = addr.getHostName().toString();
            hostIp = RemoteInterpreterUtils.findAvailableHostAddress();
            if (this.mapIpMapping.containsKey(hostIp)) {
                LOGGER.info("Internal IP: {}", (Object)hostIp);
                hostIp = this.mapIpMapping.get(hostIp);
                LOGGER.info("External IP: {}", (Object)hostIp);
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        Jinjava jinjava = new Jinjava();
        HashMap<String, String> jinjaParams = new HashMap<String, String>();
        Date now = new Date();
        String terminalServerUrl = "http://" + hostIp + ":" + port + "?noteId=" + noteId + "&paragraphId=" + paragraphId + "&t=" + now.getTime();
        jinjaParams.put("HOST_NAME", hostName);
        jinjaParams.put("HOST_IP", hostIp);
        jinjaParams.put("TERMINAL_SERVER_URL", terminalServerUrl);
        String terminalDashboardTemplate = jinjava.render(template, jinjaParams);
        LOGGER.info(terminalDashboardTemplate);
        try {
            this.intpContext.out.setType(InterpreterResult.Type.ANGULAR);
            InterpreterResultMessageOutput outputUI = this.intpContext.out.getOutputAt(0);
            outputUI.clear();
            outputUI.write(terminalDashboardTemplate);
            outputUI.flush();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void cancel(InterpreterContext context) {
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetParallelScheduler(TerminalInterpreter.class.getName() + ((Object)((Object)this)).hashCode(), 10);
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        return null;
    }

    protected boolean runKerberosLogin() {
        try {
            String kinitCommand = String.format("kinit -k -t %s %s", this.properties.getProperty("zeppelin.shell.keytab.location"), this.properties.getProperty("zeppelin.shell.principal"));
            TerminalManager.getInstance().runCommand(kinitCommand);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Unable to run kinit for zeppelin", (Throwable)e);
            return false;
        }
    }

    protected boolean isKerboseEnabled() {
        return !StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{this.getProperty("zeppelin.shell.auth.type")}) && this.getProperty("zeppelin.shell.auth.type").equalsIgnoreCase("kerberos");
    }

    @VisibleForTesting
    public int getTerminalPort() {
        return this.terminalPort;
    }

    @VisibleForTesting
    public boolean terminalThreadIsRunning() {
        return this.terminalThread.isRunning();
    }
}

