/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.shell.security;

import java.util.Properties;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellSecurityImpl {
    private static Logger LOGGER = LoggerFactory.getLogger(ShellSecurityImpl.class);

    public static void createSecureConfiguration(Properties properties, String shell) {
        String authType;
        switch (authType = properties.getProperty("zeppelin.shell.auth.type").trim().toUpperCase()) {
            case "KERBEROS": {
                CommandLine cmdLine = CommandLine.parse((String)shell);
                cmdLine.addArgument("-c", false);
                String kinitCommand = String.format("kinit -k -t %s %s", properties.getProperty("zeppelin.shell.keytab.location"), properties.getProperty("zeppelin.shell.principal"));
                cmdLine.addArgument(kinitCommand, false);
                DefaultExecutor executor = new DefaultExecutor();
                try {
                    int n = executor.execute(cmdLine);
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("Unable to run kinit for zeppelin user " + kinitCommand, (Throwable)e);
                    throw new InterpreterException((Throwable)e);
                }
            }
        }
    }
}

