/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.shell;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.apache.zeppelin.shell.security.ShellSecurityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellInterpreter
extends Interpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShellInterpreter.class);
    private static final String TIMEOUT_PROPERTY = "shell.command.timeout.millisecs";
    private static final String DIRECTORY_USER_HOME = "shell.working.directory.user.home";
    private final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    private final String shell = this.isWindows ? "cmd /c" : "bash -c";
    ConcurrentHashMap<String, DefaultExecutor> executors;

    public ShellInterpreter(Properties property) {
        super(property);
    }

    public void open() {
        LOGGER.info("Command timeout property: {}", (Object)this.getProperty(TIMEOUT_PROPERTY));
        this.executors = new ConcurrentHashMap();
        if (!StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{this.getProperty("zeppelin.shell.auth.type")})) {
            ShellSecurityImpl.createSecureConfiguration(this.getProperty(), this.shell);
        }
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpreterResult interpret(String cmd, InterpreterContext contextInterpreter) {
        LOGGER.debug("Run shell command '" + cmd + "'");
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        CommandLine cmdLine = CommandLine.parse((String)this.shell);
        if (this.isWindows) {
            Object[] lines = StringUtils.split((String)cmd, (String)"\n");
            cmd = StringUtils.join((Object[])lines, (String)" && ");
        }
        cmdLine.addArgument(cmd, false);
        try {
            DefaultExecutor executor = new DefaultExecutor();
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)contextInterpreter.out, (OutputStream)contextInterpreter.out));
            executor.setWatchdog(new ExecuteWatchdog(Long.valueOf(this.getProperty(TIMEOUT_PROPERTY)).longValue()));
            this.executors.put(contextInterpreter.getParagraphId(), executor);
            if (Boolean.valueOf(this.getProperty(DIRECTORY_USER_HOME)).booleanValue()) {
                executor.setWorkingDirectory(new File(System.getProperty("user.home")));
            }
            int exitVal = executor.execute(cmdLine);
            LOGGER.info("Paragraph " + contextInterpreter.getParagraphId() + " return with exit value: " + exitVal);
            InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.SUCCESS, ((Object)outStream).toString());
            return interpreterResult;
        }
        catch (ExecuteException e) {
            int exitValue = e.getExitValue();
            LOGGER.error("Can not run " + cmd, (Throwable)e);
            InterpreterResult.Code code = InterpreterResult.Code.ERROR;
            String message = ((Object)outStream).toString();
            if (exitValue == 143) {
                code = InterpreterResult.Code.INCOMPLETE;
                message = message + "Paragraph received a SIGTERM\n";
                LOGGER.info("The paragraph " + contextInterpreter.getParagraphId() + " stopped executing: " + message);
            }
            message = message + "ExitValue: " + exitValue;
            InterpreterResult interpreterResult = new InterpreterResult(code, message);
            return interpreterResult;
        }
        catch (IOException e) {
            LOGGER.error("Can not run " + cmd, (Throwable)e);
            InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, e.getMessage());
            return interpreterResult;
        }
        finally {
            this.executors.remove(contextInterpreter.getParagraphId());
        }
    }

    public void cancel(InterpreterContext context) {
        DefaultExecutor executor = this.executors.remove(context.getParagraphId());
        if (executor != null) {
            executor.getWatchdog().destroyProcess();
        }
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetParallelScheduler(ShellInterpreter.class.getName() + ((Object)((Object)this)).hashCode(), 10);
    }

    public List<InterpreterCompletion> completion(String buf, int cursor) {
        return null;
    }
}

