/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks;

import com.github.benmanes.caffeine.cache.CacheLoader;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.RsaJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class OidcDefaultJsonWebKeystoreCacheLoader
implements CacheLoader<String, Optional<RsaJsonWebKey>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcDefaultJsonWebKeystoreCacheLoader.class);
    private final Resource jwksFile;

    public OidcDefaultJsonWebKeystoreCacheLoader(Resource jwksFile) {
        this.jwksFile = jwksFile;
    }

    public Optional<RsaJsonWebKey> load(String issuer) throws Exception {
        Optional<JsonWebKeySet> jwks = this.buildJsonWebKeySet();
        if (!jwks.isPresent() || jwks.get().getJsonWebKeys().isEmpty()) {
            return Optional.empty();
        }
        RsaJsonWebKey key = OidcDefaultJsonWebKeystoreCacheLoader.getJsonSigningWebKeyFromJwks(jwks.get());
        if (key == null) {
            return Optional.empty();
        }
        return Optional.of(key);
    }

    private static RsaJsonWebKey getJsonSigningWebKeyFromJwks(JsonWebKeySet jwks) {
        if (jwks.getJsonWebKeys().isEmpty()) {
            LOGGER.warn("No JSON web keys are available in the keystore");
            return null;
        }
        RsaJsonWebKey key = (RsaJsonWebKey)jwks.getJsonWebKeys().get(0);
        if (StringUtils.isBlank((CharSequence)key.getAlgorithm())) {
            LOGGER.warn("Located JSON web key [{}] has no algorithm defined", (Object)key);
        }
        if (StringUtils.isBlank((CharSequence)key.getKeyId())) {
            LOGGER.warn("Located JSON web key [{}] has no key id defined", (Object)key);
        }
        if (key.getPrivateKey() == null) {
            LOGGER.warn("Located JSON web key [{}] has no private key", (Object)key);
            return null;
        }
        return key;
    }

    private static JsonWebKeySet buildJsonWebKeySet(Resource resource) throws Exception {
        String json = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        LOGGER.debug("Retrieved JSON web key from [{}] as [{}]", (Object)resource, (Object)json);
        return OidcDefaultJsonWebKeystoreCacheLoader.buildJsonWebKeySet(json);
    }

    private static JsonWebKeySet buildJsonWebKeySet(String json) throws Exception {
        JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(json);
        RsaJsonWebKey webKey = OidcDefaultJsonWebKeystoreCacheLoader.getJsonSigningWebKeyFromJwks(jsonWebKeySet);
        if (webKey == null || webKey.getPrivateKey() == null) {
            LOGGER.warn("JSON web key retrieved [{}] is not found or has no associated private key", (Object)webKey);
            return null;
        }
        return jsonWebKeySet;
    }

    private Optional<JsonWebKeySet> buildJsonWebKeySet() {
        try {
            LOGGER.debug("Loading default JSON web key from [{}]", (Object)this.jwksFile);
            if (this.jwksFile != null) {
                LOGGER.debug("Retrieving default JSON web key from [{}]", (Object)this.jwksFile);
                JsonWebKeySet jsonWebKeySet = OidcDefaultJsonWebKeystoreCacheLoader.buildJsonWebKeySet(this.jwksFile);
                if (jsonWebKeySet == null || jsonWebKeySet.getJsonWebKeys().isEmpty()) {
                    LOGGER.warn("No JSON web keys could be found");
                    return Optional.empty();
                }
                long badKeysCount = jsonWebKeySet.getJsonWebKeys().stream().filter(k -> StringUtils.isBlank((CharSequence)k.getAlgorithm()) && StringUtils.isBlank((CharSequence)k.getKeyId()) && StringUtils.isBlank((CharSequence)k.getKeyType())).count();
                if (badKeysCount == (long)jsonWebKeySet.getJsonWebKeys().size()) {
                    LOGGER.warn("No valid JSON web keys could be found");
                    return Optional.empty();
                }
                RsaJsonWebKey webKey = OidcDefaultJsonWebKeystoreCacheLoader.getJsonSigningWebKeyFromJwks(jsonWebKeySet);
                if (webKey.getPrivateKey() == null) {
                    LOGGER.warn("JSON web key retrieved [{}] has no associated private key", (Object)webKey.getKeyId());
                    return Optional.empty();
                }
                return Optional.of(jsonWebKeySet);
            }
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        return Optional.empty();
    }
}

