/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import com.fasterxml.jackson.core.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.oidc.token.OidcIdTokenGeneratorService;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.refreshtoken.RefreshToken;

public class OidcAccessTokenResponseGenerator
extends OAuth20AccessTokenResponseGenerator {
    private final OidcIdTokenGeneratorService idTokenGenerator;

    public OidcAccessTokenResponseGenerator(OidcIdTokenGeneratorService idTokenGenerator) {
        this.idTokenGenerator = idTokenGenerator;
    }

    protected void generateJsonInternal(HttpServletRequest request, HttpServletResponse response, JsonGenerator jsonGenerator, AccessToken accessTokenId, RefreshToken refreshTokenId, long timeout, Service service, OAuthRegisteredService registeredService, OAuth20ResponseTypes responseType) throws Exception {
        super.generateJsonInternal(request, response, jsonGenerator, accessTokenId, refreshTokenId, timeout, service, registeredService, responseType);
        OidcRegisteredService oidcRegisteredService = (OidcRegisteredService)registeredService;
        String idToken = this.idTokenGenerator.generate(request, response, accessTokenId, timeout, responseType, (OAuthRegisteredService)oidcRegisteredService);
        jsonGenerator.writeStringField("id_token", idToken);
    }
}

