/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.util.OidcAuthorizationRequestSupport;
import org.apereo.cas.util.Pac4jUtils;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.springframework.web.SecurityInterceptor;

public class OidcSecurityInterceptor
extends SecurityInterceptor {
    private final OidcAuthorizationRequestSupport authorizationRequestSupport;

    public OidcSecurityInterceptor(Config config, String name, OidcAuthorizationRequestSupport support) {
        super(config, name);
        this.authorizationRequestSupport = support;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        J2EContext ctx = Pac4jUtils.getPac4jJ2EContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager manager = Pac4jUtils.getPac4jProfileManager((HttpServletRequest)request, (HttpServletResponse)response);
        boolean clearCreds = false;
        Optional<UserProfile> auth = OidcAuthorizationRequestSupport.isAuthenticationProfileAvailable((WebContext)ctx);
        if (auth.isPresent()) {
            Optional<Long> maxAge = OidcAuthorizationRequestSupport.getOidcMaxAgeFromAuthorizationRequest((WebContext)ctx);
            if (maxAge.isPresent()) {
                clearCreds = this.authorizationRequestSupport.isCasAuthenticationOldForMaxAgeAuthorizationRequest((WebContext)ctx, auth.get());
            }
        }
        Set<String> prompts = OidcAuthorizationRequestSupport.getOidcPromptFromAuthorizationRequest((WebContext)ctx);
        if (!clearCreds) {
            clearCreds = prompts.contains("login");
        }
        if (clearCreds) {
            boolean bl = clearCreds = !prompts.contains("none");
        }
        if (clearCreds) {
            manager.remove(true);
        }
        return super.preHandle(request, response, handler);
    }
}

