/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.config;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderResolver;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcWebFingerProperties;
import org.apereo.cas.configuration.support.RestEndpointProperties;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.authn.OidcAccessTokenAuthenticator;
import org.apereo.cas.oidc.authn.OidcClientConfigurationAccessTokenAuthenticator;
import org.apereo.cas.oidc.authn.OidcClientSecretJwtAuthenticator;
import org.apereo.cas.oidc.authn.OidcPrivateKeyJwtAuthenticator;
import org.apereo.cas.oidc.claims.OidcCustomScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.mapping.OidcAttributeToScopeClaimMapper;
import org.apereo.cas.oidc.claims.mapping.OidcDefaultAttributeToScopeClaimMapper;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettingsFactory;
import org.apereo.cas.oidc.discovery.webfinger.OidcWebFingerDiscoveryService;
import org.apereo.cas.oidc.discovery.webfinger.OidcWebFingerUserInfoRepository;
import org.apereo.cas.oidc.discovery.webfinger.userinfo.OidcEchoingWebFingerUserInfoRepository;
import org.apereo.cas.oidc.discovery.webfinger.userinfo.OidcGroovyWebFingerUserInfoRepository;
import org.apereo.cas.oidc.discovery.webfinger.userinfo.OidcRestfulWebFingerUserInfoRepository;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationRequest;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationRequestSerializer;
import org.apereo.cas.oidc.jwks.OidcDefaultJsonWebKeystoreCacheLoader;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.OidcServiceJsonWebKeystoreCacheExpirationPolicy;
import org.apereo.cas.oidc.jwks.OidcServiceJsonWebKeystoreCacheLoader;
import org.apereo.cas.oidc.profile.OidcProfileScopeToAttributesFilter;
import org.apereo.cas.oidc.profile.OidcUserProfileDataCreator;
import org.apereo.cas.oidc.profile.OidcUserProfileSigningAndEncryptionService;
import org.apereo.cas.oidc.profile.OidcUserProfileViewRenderer;
import org.apereo.cas.oidc.services.OidcServiceRegistryListener;
import org.apereo.cas.oidc.token.OidcIdTokenGeneratorService;
import org.apereo.cas.oidc.token.OidcIdTokenSigningAndEncryptionService;
import org.apereo.cas.oidc.token.OidcRegisteredServiceJwtAccessTokenCipherExecutor;
import org.apereo.cas.oidc.util.OidcAuthorizationRequestSupport;
import org.apereo.cas.oidc.web.OidcAccessTokenResponseGenerator;
import org.apereo.cas.oidc.web.OidcCallbackAuthorizeViewResolver;
import org.apereo.cas.oidc.web.OidcCasClientRedirectActionBuilder;
import org.apereo.cas.oidc.web.OidcConsentApprovalViewResolver;
import org.apereo.cas.oidc.web.OidcHandlerInterceptorAdapter;
import org.apereo.cas.oidc.web.OidcImplicitIdTokenAndTokenAuthorizationResponseBuilder;
import org.apereo.cas.oidc.web.OidcImplicitIdTokenAuthorizationResponseBuilder;
import org.apereo.cas.oidc.web.OidcSecurityInterceptor;
import org.apereo.cas.oidc.web.controllers.authorize.OidcAuthorizeEndpointController;
import org.apereo.cas.oidc.web.controllers.discovery.OidcWellKnownEndpointController;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcClientConfigurationEndpointController;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcDynamicClientRegistrationEndpointController;
import org.apereo.cas.oidc.web.controllers.introspection.OidcIntrospectionEndpointController;
import org.apereo.cas.oidc.web.controllers.jwks.OidcJwksEndpointController;
import org.apereo.cas.oidc.web.controllers.logout.OidcLogoutEndpointController;
import org.apereo.cas.oidc.web.controllers.profile.OidcUserProfileEndpointController;
import org.apereo.cas.oidc.web.controllers.token.OidcAccessTokenEndpointController;
import org.apereo.cas.oidc.web.controllers.token.OidcRevocationEndpointController;
import org.apereo.cas.oidc.web.flow.OidcMultifactorAuthenticationTrigger;
import org.apereo.cas.oidc.web.flow.OidcRegisteredServiceUIAction;
import org.apereo.cas.oidc.web.flow.OidcWebflowConfigurer;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.ServiceRegistryListener;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.authenticator.OAuth20CasAuthenticationBuilder;
import org.apereo.cas.support.oauth.authenticator.OAuthAuthenticationClientProvider;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.profile.OAuth20UserProfileDataCreator;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.OAuth20CasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.views.ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20CallbackAuthorizeViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20UserProfileViewRenderer;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.IdTokenGeneratorService;
import org.apereo.cas.ticket.OAuth20TokenSigningAndEncryptionService;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenFactory;
import org.apereo.cas.ticket.code.OAuth20CodeFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.gen.DefaultRandomStringGenerator;
import org.apereo.cas.util.gen.RandomStringGenerator;
import org.apereo.cas.util.serialization.StringSerializer;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.resolver.impl.mfa.DefaultMultifactorAuthenticationProviderWebflowEventResolver;
import org.jose4j.jwk.RsaJsonWebKey;
import org.pac4j.cas.client.CasClient;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.BearerAuthExtractor;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.JEEHttpActionAdapter;
import org.pac4j.http.client.direct.DirectFormClient;
import org.pac4j.http.client.direct.HeaderClient;
import org.pac4j.springframework.web.SecurityInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="oidcConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class OidcConfiguration
implements WebMvcConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcConfiguration.class);
    @Autowired
    @Qualifier(value="oauthRegisteredServiceCipherExecutor")
    private ObjectProvider<CipherExecutor> oauthRegisteredServiceCipherExecutor;
    @Autowired
    @Qualifier(value="oauthDistributedSessionStore")
    private ObjectProvider<SessionStore> oauthDistributedSessionStore;
    @Autowired
    @Qualifier(value="accessTokenJwtBuilder")
    private ObjectProvider<JwtBuilder> accessTokenJwtBuilder;
    @Autowired
    @Qualifier(value="accessTokenGrantAuditableRequestExtractor")
    private ObjectProvider<AuditableExecution> accessTokenGrantAuditableRequestExtractor;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    @Autowired
    @Qualifier(value="registeredServiceAccessStrategyEnforcer")
    private ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer;
    @Autowired
    @Qualifier(value="oauthAuthorizationRequestValidators")
    private ObjectProvider<Set<OAuth20AuthorizationRequestValidator>> oauthRequestValidators;
    @Autowired
    @Qualifier(value="grantingTicketExpirationPolicy")
    private ObjectProvider<ExpirationPolicyBuilder> grantingTicketExpirationPolicy;
    @Autowired
    @Qualifier(value="oauthTokenGenerator")
    private ObjectProvider<OAuth20TokenGenerator> oauthTokenGenerator;
    @Autowired
    @Qualifier(value="oauthAuthorizationResponseBuilders")
    private ObjectProvider<Set<OAuth20AuthorizationResponseBuilder>> oauthAuthorizationResponseBuilders;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ObjectProvider<ServiceFactory<WebApplicationService>> webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="accessTokenExpirationPolicy")
    private ObjectProvider<ExpirationPolicyBuilder> accessTokenExpirationPolicy;
    @Autowired
    @Qualifier(value="deviceTokenExpirationPolicy")
    private ObjectProvider<ExpirationPolicyBuilder> deviceTokenExpirationPolicy;
    @Autowired
    @Qualifier(value="requiresAuthenticationAccessTokenInterceptor")
    private ObjectProvider<SecurityInterceptor> requiresAuthenticationAccessTokenInterceptor;
    @Autowired
    @Qualifier(value="oauthCasAuthenticationBuilder")
    private ObjectProvider<OAuth20CasAuthenticationBuilder> authenticationBuilder;
    @Autowired
    @Qualifier(value="warnCookieGenerator")
    private ObjectProvider<CasCookieBuilder> warnCookieGenerator;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> loginFlowDefinitionRegistry;
    @Autowired
    @Qualifier(value="logoutFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> logoutFlowDefinitionRegistry;
    @Autowired
    private ObjectProvider<FlowBuilderServices> flowBuilderServices;
    @Autowired
    @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver")
    private ObjectProvider<CasDelegatingWebflowEventResolver> initialAuthenticationAttemptWebflowEventResolver;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;
    @Autowired
    @Qualifier(value="oauth20AuthenticationRequestServiceSelectionStrategy")
    private ObjectProvider<AuthenticationServiceSelectionStrategy> oauth20AuthenticationServiceSelectionStrategy;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    @Qualifier(value="singleLogoutServiceLogoutUrlBuilder")
    private ObjectProvider<SingleLogoutServiceLogoutUrlBuilder> singleLogoutServiceLogoutUrlBuilder;
    @Autowired
    @Qualifier(value="oauthSecConfig")
    private ObjectProvider<Config> oauthSecConfig;
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private ObjectProvider<CasCookieBuilder> ticketGrantingTicketCookieGenerator;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private ObjectProvider<TicketRegistrySupport> ticketRegistrySupport;
    @Autowired
    @Qualifier(value="defaultAccessTokenFactory")
    private ObjectProvider<OAuth20AccessTokenFactory> defaultAccessTokenFactory;
    @Autowired
    @Qualifier(value="defaultDeviceTokenFactory")
    private ObjectProvider<OAuth20DeviceTokenFactory> defaultDeviceTokenFactory;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private ObjectProvider<TicketRegistry> ticketRegistry;
    @Autowired
    @Qualifier(value="defaultOAuthCodeFactory")
    private ObjectProvider<OAuth20CodeFactory> defaultOAuthCodeFactory;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies;
    @Autowired
    @Qualifier(value="accessTokenGrantRequestExtractors")
    private ObjectProvider<Collection<AccessTokenGrantRequestExtractor>> accessTokenGrantRequestExtractors;
    @Autowired
    @Qualifier(value="oauthTokenRequestValidators")
    private ObjectProvider<Collection<OAuth20TokenRequestValidator>> oauthTokenRequestValidators;
    @Autowired
    @Qualifier(value="multifactorAuthenticationProviderResolver")
    private ObjectProvider<MultifactorAuthenticationProviderResolver> multifactorAuthenticationProviderResolver;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.oauthInterceptor()).addPathPatterns(new String[]{"/" + "oidc".concat("/").concat("*")});
    }

    @Bean
    public ConsentApprovalViewResolver consentApprovalViewResolver() {
        return new OidcConsentApprovalViewResolver(this.casProperties);
    }

    @Bean
    public OAuth20CallbackAuthorizeViewResolver callbackAuthorizeViewResolver() {
        return new OidcCallbackAuthorizeViewResolver();
    }

    @Bean
    public OAuth20CasClientRedirectActionBuilder oauthCasClientRedirectActionBuilder() {
        return new OidcCasClientRedirectActionBuilder(this.oidcAuthorizationRequestSupport());
    }

    @Bean
    public HandlerInterceptorAdapter requiresAuthenticationDynamicRegistrationInterceptor() {
        String clients = String.join((CharSequence)",", "clientBasicAuth", "clientAccessTokenAuth", "clientForm", "userForm");
        SecurityInterceptor interceptor = new SecurityInterceptor((Config)this.oauthSecConfig.getObject(), clients, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        interceptor.setAuthorizers("");
        return interceptor;
    }

    @Bean
    public HandlerInterceptorAdapter requiresAuthenticationClientConfigurationInterceptor() {
        String clients = String.join((CharSequence)",", "ClientRegistrationClient");
        SecurityInterceptor interceptor = new SecurityInterceptor((Config)this.oauthSecConfig.getObject(), clients, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        interceptor.setAuthorizers("");
        return interceptor;
    }

    @Bean
    public HandlerInterceptorAdapter requiresAuthenticationAuthorizeInterceptor() {
        String name = ((CasClient)((Config)this.oauthSecConfig.getObject()).getClients().findClient(CasClient.class).get()).getName();
        OidcSecurityInterceptor interceptor = new OidcSecurityInterceptor((Config)this.oauthSecConfig.getObject(), name, this.oidcAuthorizationRequestSupport(), (SessionStore)this.oauthDistributedSessionStore.getObject());
        return interceptor;
    }

    @Bean
    public OAuth20CasClientRedirectActionBuilder oidcCasClientRedirectActionBuilder() {
        return new OidcCasClientRedirectActionBuilder(this.oidcAuthorizationRequestSupport());
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcIdTokenGenerator"})
    @Bean
    public IdTokenGeneratorService oidcIdTokenGenerator() {
        OAuth20ConfigurationContext context = this.buildConfigurationContext();
        context.setIdTokenSigningAndEncryptionService(this.oidcTokenSigningAndEncryptionService());
        return new OidcIdTokenGeneratorService(context);
    }

    @ConditionalOnMissingBean(name={"oidcAccessTokenResponseGenerator"})
    @Bean
    @RefreshScope
    public OAuth20AccessTokenResponseGenerator oidcAccessTokenResponseGenerator() {
        return new OidcAccessTokenResponseGenerator(this.oidcIdTokenGenerator(), (JwtBuilder)this.accessTokenJwtBuilder.getObject());
    }

    @Bean
    public OidcAuthorizationRequestSupport oidcAuthorizationRequestSupport() {
        return new OidcAuthorizationRequestSupport((CasCookieBuilder)this.ticketGrantingTicketCookieGenerator.getObject(), (TicketRegistrySupport)this.ticketRegistrySupport.getObject());
    }

    @ConditionalOnMissingBean(name={"oidcPrincipalFactory"})
    @Bean
    public PrincipalFactory oidcPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @Bean
    @RefreshScope
    public OidcAttributeToScopeClaimMapper oidcAttributeToScopeClaimMapper() {
        Map mappings = this.casProperties.getAuthn().getOidc().getClaimsMap();
        return new OidcDefaultAttributeToScopeClaimMapper(mappings);
    }

    @Bean
    @RefreshScope
    public OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter() {
        return new OidcProfileScopeToAttributesFilter(this.oidcPrincipalFactory(), this.casProperties, this.userDefinedScopeBasedAttributeReleasePolicies());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcServiceRegistryListener"})
    public ServiceRegistryListener oidcServiceRegistryListener() {
        return new OidcServiceRegistryListener(this.userDefinedScopeBasedAttributeReleasePolicies());
    }

    @RefreshScope
    @Bean
    public OidcIntrospectionEndpointController oidcIntrospectionEndpointController() {
        OAuth20ConfigurationContext context = this.buildConfigurationContext();
        return new OidcIntrospectionEndpointController(context);
    }

    @RefreshScope
    @Bean
    public OidcLogoutEndpointController oidcLogoutEndpointController() {
        OAuth20ConfigurationContext context = this.buildConfigurationContext();
        return new OidcLogoutEndpointController(context);
    }

    @RefreshScope
    @Bean
    public OidcRevocationEndpointController oidcRevocationEndpointController() {
        OAuth20ConfigurationContext context = this.buildConfigurationContext();
        return new OidcRevocationEndpointController(context);
    }

    @RefreshScope
    @Bean
    public OidcAccessTokenEndpointController oidcAccessTokenController() {
        OAuth20ConfigurationContext context = this.buildConfigurationContext();
        return new OidcAccessTokenEndpointController(context);
    }

    @ConditionalOnMissingBean(name={"clientRegistrationRequestSerializer"})
    @Bean
    public StringSerializer<OidcClientRegistrationRequest> clientRegistrationRequestSerializer() {
        return new OidcClientRegistrationRequestSerializer();
    }

    @RefreshScope
    @Bean
    public OidcDynamicClientRegistrationEndpointController oidcDynamicClientRegistrationEndpointController() {
        OAuth20ConfigurationContext context = this.buildConfigurationContext();
        return new OidcDynamicClientRegistrationEndpointController(context);
    }

    @RefreshScope
    @Bean
    public OidcClientConfigurationEndpointController oidcClientConfigurationEndpointController() {
        OAuth20ConfigurationContext context = this.buildConfigurationContext();
        return new OidcClientConfigurationEndpointController(context);
    }

    @RefreshScope
    @Bean
    public OidcJwksEndpointController oidcJwksController() {
        OAuth20ConfigurationContext context = this.buildConfigurationContext();
        return new OidcJwksEndpointController(context);
    }

    @Autowired
    @RefreshScope
    @Bean
    public OidcWellKnownEndpointController oidcWellKnownController(@Qualifier(value="oidcServerDiscoverySettingsFactory") OidcServerDiscoverySettings discoverySettings) {
        OAuth20ConfigurationContext context = this.buildConfigurationContext();
        return new OidcWellKnownEndpointController(context, new OidcWebFingerDiscoveryService(this.oidcWebFingerUserInfoRepository(), discoverySettings));
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcWebFingerUserInfoRepository"})
    public OidcWebFingerUserInfoRepository oidcWebFingerUserInfoRepository() {
        OidcWebFingerProperties.UserInfoRepository userInfo = this.casProperties.getAuthn().getOidc().getWebfinger().getUserInfo();
        if (userInfo.getGroovy().getLocation() != null) {
            return new OidcGroovyWebFingerUserInfoRepository(userInfo.getGroovy().getLocation());
        }
        if (StringUtils.isNotBlank((CharSequence)userInfo.getRest().getUrl())) {
            return new OidcRestfulWebFingerUserInfoRepository((RestEndpointProperties)userInfo.getRest());
        }
        LOGGER.warn("Using [{}] to locate webfinger resources, which is NOT appropriate for production purposes, as it will always echo back the given username/email address and is only useful for testing/demo purposes. Consider choosing and configuring a different repository implementation for locating and fetching user information for webfinger resources, etc.", (Object)OidcEchoingWebFingerUserInfoRepository.class.getSimpleName());
        return new OidcEchoingWebFingerUserInfoRepository();
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcProfileController"})
    @Bean
    public OidcUserProfileEndpointController oidcProfileController() {
        OAuth20ConfigurationContext context = this.buildConfigurationContext();
        return new OidcUserProfileEndpointController(context);
    }

    @Bean
    public OAuth20UserProfileDataCreator oidcUserProfileDataCreator() {
        return new OidcUserProfileDataCreator((ServicesManager)this.servicesManager.getObject(), this.profileScopeToAttributesFilter());
    }

    @RefreshScope
    @Bean
    public OidcAuthorizeEndpointController oidcAuthorizeController() {
        OAuth20ConfigurationContext context = this.buildConfigurationContext();
        return new OidcAuthorizeEndpointController(context);
    }

    @Bean
    @RefreshScope
    public MultifactorAuthenticationTrigger oidcMultifactorAuthenticationTrigger() {
        return new OidcMultifactorAuthenticationTrigger(this.casProperties, (MultifactorAuthenticationProviderResolver)this.multifactorAuthenticationProviderResolver.getObject());
    }

    @RefreshScope
    @Bean
    public CasWebflowEventResolver oidcAuthenticationContextWebflowEventResolver() {
        CasWebflowEventResolutionConfigurationContext context = CasWebflowEventResolutionConfigurationContext.builder().authenticationSystemSupport((AuthenticationSystemSupport)this.authenticationSystemSupport.getObject()).centralAuthenticationService((CentralAuthenticationService)this.centralAuthenticationService.getObject()).servicesManager((ServicesManager)this.servicesManager.getObject()).ticketRegistrySupport((TicketRegistrySupport)this.ticketRegistrySupport.getObject()).warnCookieGenerator((CasCookieBuilder)this.warnCookieGenerator.getObject()).authenticationRequestServiceSelectionStrategies((AuthenticationServiceSelectionPlan)this.authenticationRequestServiceSelectionStrategies.getObject()).registeredServiceAccessStrategyEnforcer((AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject()).casProperties(this.casProperties).ticketRegistry((TicketRegistry)this.ticketRegistry.getObject()).eventPublisher((ApplicationEventPublisher)this.applicationContext).applicationContext(this.applicationContext).build();
        DefaultMultifactorAuthenticationProviderWebflowEventResolver r = new DefaultMultifactorAuthenticationProviderWebflowEventResolver(context, this.oidcMultifactorAuthenticationTrigger());
        Objects.requireNonNull((CasDelegatingWebflowEventResolver)this.initialAuthenticationAttemptWebflowEventResolver.getObject()).addDelegate((CasWebflowEventResolver)r);
        return r;
    }

    @ConditionalOnMissingBean(name={"oidcWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer oidcWebflowConfigurer() {
        OidcWebflowConfigurer cfg = new OidcWebflowConfigurer((FlowBuilderServices)this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)this.loginFlowDefinitionRegistry.getObject(), this.oidcRegisteredServiceUIAction(), (ApplicationContext)this.applicationContext, this.casProperties);
        cfg.setLogoutFlowDefinitionRegistry((FlowDefinitionRegistry)this.logoutFlowDefinitionRegistry.getObject());
        return cfg;
    }

    @ConditionalOnMissingBean(name={"oidcRegisteredServiceUIAction"})
    @Bean
    public Action oidcRegisteredServiceUIAction() {
        return new OidcRegisteredServiceUIAction((ServicesManager)this.servicesManager.getObject(), (AuthenticationServiceSelectionStrategy)this.oauth20AuthenticationServiceSelectionStrategy.getObject());
    }

    @Bean
    public OAuth20TokenSigningAndEncryptionService oidcTokenSigningAndEncryptionService() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        return new OidcIdTokenSigningAndEncryptionService(this.oidcDefaultJsonWebKeystoreCache(), this.oidcServiceJsonWebKeystoreCache(), oidc.getIssuer());
    }

    @Bean
    public OAuth20TokenSigningAndEncryptionService oidcUserProfileSigningAndEncryptionService() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        return new OidcUserProfileSigningAndEncryptionService(this.oidcDefaultJsonWebKeystoreCache(), this.oidcServiceJsonWebKeystoreCache(), oidc.getIssuer());
    }

    @Bean
    public LoadingCache<OAuthRegisteredService, Optional<RsaJsonWebKey>> oidcServiceJsonWebKeystoreCache() {
        return Caffeine.newBuilder().maximumSize(1L).expireAfter((Expiry)new OidcServiceJsonWebKeystoreCacheExpirationPolicy(this.casProperties)).build(this.oidcServiceJsonWebKeystoreCacheLoader());
    }

    @Bean
    public LoadingCache<String, Optional<RsaJsonWebKey>> oidcDefaultJsonWebKeystoreCache() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        return Caffeine.newBuilder().maximumSize(1L).expireAfterWrite((long)oidc.getJwksCacheInMinutes(), TimeUnit.MINUTES).build((CacheLoader)this.oidcDefaultJsonWebKeystoreCacheLoader());
    }

    @Bean
    public OidcDefaultJsonWebKeystoreCacheLoader oidcDefaultJsonWebKeystoreCacheLoader() {
        return new OidcDefaultJsonWebKeystoreCacheLoader(this.casProperties.getAuthn().getOidc().getJwksFile());
    }

    @Bean
    public CacheLoader<OAuthRegisteredService, Optional<RsaJsonWebKey>> oidcServiceJsonWebKeystoreCacheLoader() {
        return new OidcServiceJsonWebKeystoreCacheLoader();
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcServerDiscoverySettingsFactory"})
    public FactoryBean<OidcServerDiscoverySettings> oidcServerDiscoverySettingsFactory() {
        return new OidcServerDiscoverySettingsFactory(this.casProperties);
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcJsonWebKeystoreGeneratorService"})
    public OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService() {
        OidcJsonWebKeystoreGeneratorService s = new OidcJsonWebKeystoreGeneratorService(this.casProperties.getAuthn().getOidc());
        s.generate();
        return s;
    }

    @Bean
    public HandlerInterceptorAdapter oauthInterceptor() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        OidcConstants.DynamicClientRegistrationMode mode = OidcConstants.DynamicClientRegistrationMode.valueOf((String)((String)StringUtils.defaultIfBlank((CharSequence)oidc.getDynamicClientRegistrationMode(), (CharSequence)OidcConstants.DynamicClientRegistrationMode.PROTECTED.name())));
        return new OidcHandlerInterceptorAdapter((HandlerInterceptorAdapter)this.requiresAuthenticationAccessTokenInterceptor.getObject(), this.requiresAuthenticationAuthorizeInterceptor(), this.requiresAuthenticationDynamicRegistrationInterceptor(), this.requiresAuthenticationClientConfigurationInterceptor(), mode, (Collection)this.accessTokenGrantRequestExtractors.getObject());
    }

    @RefreshScope
    @Bean
    public Collection<OidcCustomScopeAttributeReleasePolicy> userDefinedScopeBasedAttributeReleasePolicies() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        return oidc.getUserDefinedScopes().entrySet().stream().map(k -> new OidcCustomScopeAttributeReleasePolicy((String)k.getKey(), CollectionUtils.wrapList((Object[])((String)k.getValue()).split(",")))).collect(Collectors.toSet());
    }

    @Bean
    public OAuth20AuthorizationResponseBuilder oidcImplicitIdTokenCallbackUrlBuilder() {
        return new OidcImplicitIdTokenAuthorizationResponseBuilder(this.oidcIdTokenGenerator(), (OAuth20TokenGenerator)this.oauthTokenGenerator.getObject(), (ExpirationPolicyBuilder)this.accessTokenExpirationPolicy.getObject(), (ExpirationPolicyBuilder)this.grantingTicketExpirationPolicy.getObject(), (ServicesManager)this.servicesManager.getObject(), (JwtBuilder)this.accessTokenJwtBuilder.getObject());
    }

    @Bean
    public OAuth20AuthorizationResponseBuilder oidcImplicitIdTokenAndTokenCallbackUrlBuilder() {
        return new OidcImplicitIdTokenAndTokenAuthorizationResponseBuilder(this.oidcIdTokenGenerator(), (OAuth20TokenGenerator)this.oauthTokenGenerator.getObject(), (ExpirationPolicyBuilder)this.accessTokenExpirationPolicy.getObject(), (ExpirationPolicyBuilder)this.grantingTicketExpirationPolicy.getObject(), (ServicesManager)this.servicesManager.getObject(), (JwtBuilder)this.accessTokenJwtBuilder.getObject());
    }

    @Bean
    public RegisteredServiceCipherExecutor oauthRegisteredServiceJwtAccessTokenCipherExecutor() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        return new OidcRegisteredServiceJwtAccessTokenCipherExecutor(this.oidcDefaultJsonWebKeystoreCache(), this.oidcServiceJsonWebKeystoreCache(), oidc.getIssuer());
    }

    @Bean
    public OAuthAuthenticationClientProvider oidcClientConfigurationAuthenticationClientProvider() {
        return () -> {
            HeaderClient accessTokenClient = new HeaderClient();
            accessTokenClient.setCredentialsExtractor((CredentialsExtractor)new BearerAuthExtractor());
            accessTokenClient.setAuthenticator((Authenticator)new OidcClientConfigurationAccessTokenAuthenticator((TicketRegistry)this.ticketRegistry.getObject(), (JwtBuilder)this.accessTokenJwtBuilder.getObject()));
            accessTokenClient.setName("ClientRegistrationClient");
            accessTokenClient.init();
            return accessTokenClient;
        };
    }

    @Bean
    public OAuthAuthenticationClientProvider oidcPrivateKeyJwtClientProvider() {
        return () -> {
            DirectFormClient privateKeyJwtClient = new DirectFormClient((Authenticator)new OidcPrivateKeyJwtAuthenticator((ServicesManager)this.servicesManager.getObject(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject(), (TicketRegistry)this.ticketRegistry.getObject(), (ServiceFactory)this.webApplicationServiceFactory.getObject(), this.casProperties));
            privateKeyJwtClient.setName("ClientPrivateKeyJwtClient");
            privateKeyJwtClient.setUsernameParameter("client_assertion_type");
            privateKeyJwtClient.setPasswordParameter("client_assertion");
            privateKeyJwtClient.init();
            return privateKeyJwtClient;
        };
    }

    @Bean
    public OAuthAuthenticationClientProvider oidcClientSecretJwtClientProvider() {
        return () -> {
            DirectFormClient client = new DirectFormClient((Authenticator)new OidcClientSecretJwtAuthenticator((ServicesManager)this.servicesManager.getObject(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject(), (TicketRegistry)this.ticketRegistry.getObject(), (ServiceFactory)this.webApplicationServiceFactory.getObject(), this.casProperties));
            client.setName("ClientSecretJwtClient");
            client.setUsernameParameter("client_assertion_type");
            client.setPasswordParameter("client_assertion");
            client.init();
            return client;
        };
    }

    @Bean
    public Authenticator<TokenCredentials> oAuthAccessTokenAuthenticator() {
        return new OidcAccessTokenAuthenticator((TicketRegistry)this.ticketRegistry.getObject(), this.oidcTokenSigningAndEncryptionService(), (ServicesManager)this.servicesManager.getObject(), (JwtBuilder)this.accessTokenJwtBuilder.getObject());
    }

    @ConditionalOnMissingBean(name={"oidcCasWebflowExecutionPlanConfigurer"})
    @Bean
    public CasWebflowExecutionPlanConfigurer oidcCasWebflowExecutionPlanConfigurer() {
        return plan -> plan.registerWebflowConfigurer(this.oidcWebflowConfigurer());
    }

    @ConditionalOnMissingBean(name={"oidcUserProfileViewRenderer"})
    @Bean
    @RefreshScope
    public OAuth20UserProfileViewRenderer oidcUserProfileViewRenderer() {
        return new OidcUserProfileViewRenderer(this.casProperties.getAuthn().getOauth(), (ServicesManager)this.servicesManager.getObject(), this.oidcUserProfileSigningAndEncryptionService());
    }

    private OAuth20ConfigurationContext buildConfigurationContext() {
        return OAuth20ConfigurationContext.builder().registeredServiceCipherExecutor((CipherExecutor)this.oauthRegisteredServiceCipherExecutor.getObject()).sessionStore((SessionStore)this.oauthDistributedSessionStore.getObject()).servicesManager((ServicesManager)this.servicesManager.getObject()).ticketRegistry((TicketRegistry)this.ticketRegistry.getObject()).accessTokenFactory((OAuth20AccessTokenFactory)this.defaultAccessTokenFactory.getObject()).deviceTokenFactory((OAuth20DeviceTokenFactory)this.defaultDeviceTokenFactory.getObject()).clientRegistrationRequestSerializer(this.clientRegistrationRequestSerializer()).clientIdGenerator((RandomStringGenerator)new DefaultRandomStringGenerator()).clientSecretGenerator((RandomStringGenerator)new DefaultRandomStringGenerator()).principalFactory(this.oidcPrincipalFactory()).webApplicationServiceServiceFactory((ServiceFactory)this.webApplicationServiceFactory.getObject()).casProperties(this.casProperties).ticketGrantingTicketCookieGenerator((CasCookieBuilder)this.ticketGrantingTicketCookieGenerator.getObject()).resourceLoader(this.resourceLoader).oauthConfig((Config)this.oauthSecConfig.getObject()).registeredServiceAccessStrategyEnforcer((AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject()).centralAuthenticationService((CentralAuthenticationService)this.centralAuthenticationService.getObject()).callbackAuthorizeViewResolver(this.callbackAuthorizeViewResolver()).profileScopeToAttributesFilter(this.profileScopeToAttributesFilter()).accessTokenGenerator((OAuth20TokenGenerator)this.oauthTokenGenerator.getObject()).accessTokenResponseGenerator(this.oidcAccessTokenResponseGenerator()).accessTokenExpirationPolicy((ExpirationPolicyBuilder)this.accessTokenExpirationPolicy.getObject()).deviceTokenExpirationPolicy((ExpirationPolicyBuilder)this.deviceTokenExpirationPolicy.getObject()).accessTokenGrantRequestValidators((Collection)this.oauthTokenRequestValidators.getObject()).accessTokenGrantAuditableRequestExtractor((AuditableExecution)this.accessTokenGrantAuditableRequestExtractor.getObject()).userProfileDataCreator(this.oidcUserProfileDataCreator()).userProfileViewRenderer(this.oidcUserProfileViewRenderer()).oAuthCodeFactory((OAuth20CodeFactory)this.defaultOAuthCodeFactory.getObject()).consentApprovalViewResolver(this.consentApprovalViewResolver()).authenticationBuilder((OAuth20CasAuthenticationBuilder)this.authenticationBuilder.getObject()).oauthAuthorizationResponseBuilders((Set)this.oauthAuthorizationResponseBuilders.getObject()).oauthRequestValidators((Set)this.oauthRequestValidators.getObject()).singleLogoutServiceLogoutUrlBuilder((SingleLogoutServiceLogoutUrlBuilder)this.singleLogoutServiceLogoutUrlBuilder.getObject()).idTokenSigningAndEncryptionService(this.oidcTokenSigningAndEncryptionService()).accessTokenJwtBuilder((JwtBuilder)this.accessTokenJwtBuilder.getObject()).build();
    }
}

