/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.config;

import org.apereo.cas.throttle.AuthenticationThrottlingExecutionPlan;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(value="oidcThrottleConfiguration", proxyBeanMethods=false)
public class OidcThrottleConfiguration
implements WebMvcConfigurer {
    @Autowired
    @Qualifier(value="authenticationThrottlingExecutionPlan")
    private ObjectProvider<AuthenticationThrottlingExecutionPlan> authenticationThrottlingExecutionPlan;

    public void addInterceptors(InterceptorRegistry registry) {
        ((AuthenticationThrottlingExecutionPlan)this.authenticationThrottlingExecutionPlan.getObject()).getAuthenticationThrottleInterceptors().forEach(handler -> {
            String baseUrl = "oidc".concat("/");
            registry.addInterceptor(handler).addPathPatterns(new String[]{baseUrl.concat("introspect").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("jwks").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("register").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("revoke").concat("*")}).addPathPatterns(new String[]{baseUrl.concat("clientConfig").concat("*")});
        });
    }
}

