/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderResolver;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.discovery.CasServerProfileCustomizer;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.oidc.discovery.webfinger.OidcWebFingerDiscoveryService;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.rotation.OidcJsonWebKeystoreRotationService;
import org.apereo.cas.oidc.web.OidcHandlerInterceptorAdapter;
import org.apereo.cas.oidc.web.OidcLocaleChangeInterceptor;
import org.apereo.cas.oidc.web.controllers.authorize.OidcAuthorizeEndpointController;
import org.apereo.cas.oidc.web.controllers.authorize.OidcPushedAuthorizeEndpointController;
import org.apereo.cas.oidc.web.controllers.discovery.OidcWellKnownEndpointController;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcClientConfigurationEndpointController;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcDynamicClientRegistrationEndpointController;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcInitialAccessTokenController;
import org.apereo.cas.oidc.web.controllers.introspection.OidcIntrospectionEndpointController;
import org.apereo.cas.oidc.web.controllers.jwks.OidcJwksEndpointController;
import org.apereo.cas.oidc.web.controllers.jwks.OidcJwksRotationEndpoint;
import org.apereo.cas.oidc.web.controllers.logout.OidcLogoutEndpointController;
import org.apereo.cas.oidc.web.controllers.logout.OidcPostLogoutRedirectUrlMatcher;
import org.apereo.cas.oidc.web.controllers.profile.OidcUserProfileEndpointController;
import org.apereo.cas.oidc.web.controllers.token.OidcAccessTokenEndpointController;
import org.apereo.cas.oidc.web.controllers.token.OidcRevocationEndpointController;
import org.apereo.cas.oidc.web.flow.OidcCasWebflowLoginContextProvider;
import org.apereo.cas.oidc.web.flow.OidcMultifactorAuthenticationTrigger;
import org.apereo.cas.oidc.web.flow.OidcRegisteredServiceUIAction;
import org.apereo.cas.oidc.web.flow.OidcUnmetAuthenticationRequirementWebflowExceptionHandler;
import org.apereo.cas.oidc.web.flow.OidcWebflowConfigurer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantRequestExtractor;
import org.apereo.cas.util.spring.RefreshableHandlerInterceptor;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.validation.CasProtocolViewFactory;
import org.apereo.cas.web.CasWebSecurityConfigurer;
import org.apereo.cas.web.SecurityLogicInterceptor;
import org.apereo.cas.web.UrlValidator;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.CasWebflowLoginContextProvider;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionHandler;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.resolver.impl.mfa.DefaultMultifactorAuthenticationProviderWebflowEventResolver;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.OpenIDConnect})
@AutoConfiguration
public class OidcEndpointsConfiguration {

    @Configuration(value="OidcCasDiscoveryProfileConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnClass(value={CasServerProfileCustomizer.class})
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Discovery})
    public static class OidcCasDiscoveryProfileConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcCasServerProfileCustomizer"})
        @Bean
        public CasServerProfileCustomizer oidcCasServerProfileCustomizer(CasConfigurationProperties casProperties) {
            return profile -> profile.getDetails().put("userDefinedScopes", casProperties.getAuthn().getOidc().getCore().getUserDefinedScopes());
        }
    }

    @Configuration(value="OidcEndpointsWebflowConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcEndpointsWebflowConfiguration {
        @ConditionalOnMissingBean(name={"oidcUnmetAuthenticationRequirementWebflowExceptionHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExceptionHandler oidcUnmetAuthenticationRequirementWebflowExceptionHandler(@Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new OidcUnmetAuthenticationRequirementWebflowExceptionHandler(oidcConfigurationContext);
        }

        @ConditionalOnMissingBean(name={"oidcCasWebflowExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExecutionPlanConfigurer oidcCasWebflowExecutionPlanConfigurer(@Qualifier(value="oidcWebflowConfigurer") CasWebflowConfigurer oidcWebflowConfigurer, @Qualifier(value="oidcLocaleChangeInterceptor") HandlerInterceptor oidcLocaleChangeInterceptor, @Qualifier(value="oidcCasWebflowLoginContextProvider") CasWebflowLoginContextProvider oidcCasWebflowLoginContextProvider) {
            return plan -> {
                plan.registerWebflowConfigurer(oidcWebflowConfigurer);
                plan.registerWebflowInterceptor(oidcLocaleChangeInterceptor);
                plan.registerWebflowLoginContextProvider(oidcCasWebflowLoginContextProvider);
            };
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcCasWebflowLoginContextProvider"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowLoginContextProvider oidcCasWebflowLoginContextProvider(@Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor) {
            return new OidcCasWebflowLoginContextProvider(argumentExtractor);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @Lazy(value=false)
        public CasWebflowEventResolver oidcAuthenticationContextWebflowEventResolver(@Qualifier(value="initialAuthenticationAttemptWebflowEventResolver") CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext, @Qualifier(value="oidcMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger oidcMultifactorAuthenticationTrigger) {
            DefaultMultifactorAuthenticationProviderWebflowEventResolver r = new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, oidcMultifactorAuthenticationTrigger);
            initialAuthenticationAttemptWebflowEventResolver.addDelegate((CasWebflowEventResolver)r);
            return r;
        }

        @ConditionalOnMissingBean(name={"oidcWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer oidcWebflowConfigurer(@Qualifier(value="logoutFlowRegistry") FlowDefinitionRegistry logoutFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            OidcWebflowConfigurer cfg = new OidcWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
            cfg.setLogoutFlowDefinitionRegistry(logoutFlowDefinitionRegistry);
            return cfg;
        }

        @ConditionalOnMissingBean(name={"oidcRegisteredServiceUIAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action oidcRegisteredServiceUIAction(@Qualifier(value="oauth20AuthenticationRequestServiceSelectionStrategy") AuthenticationServiceSelectionStrategy oauth20AuthenticationServiceSelectionStrategy, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new OidcRegisteredServiceUIAction(servicesManager, oauth20AuthenticationServiceSelectionStrategy);
        }
    }

    @Configuration(value="OidcControllerEndpointsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @AutoConfigureOrder(value=0x7FFFFFFF)
    public static class OidcControllerEndpointsConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcWellKnownController"})
        @Bean
        public OidcWellKnownEndpointController oidcWellKnownController(@Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext, @Qualifier(value="oidcWebFingerDiscoveryService") OidcWebFingerDiscoveryService oidcWebFingerDiscoveryService) {
            return new OidcWellKnownEndpointController(oidcConfigurationContext, oidcWebFingerDiscoveryService);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcProfileController"})
        @Bean
        public OidcUserProfileEndpointController oidcProfileController(@Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new OidcUserProfileEndpointController(oidcConfigurationContext);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public OidcAuthorizeEndpointController oidcAuthorizeController(@Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new OidcAuthorizeEndpointController(oidcConfigurationContext);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public OidcPushedAuthorizeEndpointController oidcPushedAuthorizeController(@Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new OidcPushedAuthorizeEndpointController(oidcConfigurationContext);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"oidcLogoutEndpointController"})
        public OidcLogoutEndpointController oidcLogoutEndpointController(@Qualifier(value="postLogoutRedirectUrlMatcher") OidcPostLogoutRedirectUrlMatcher postLogoutRedirectUrlMatcher, @Qualifier(value="urlValidator") UrlValidator urlValidator, @Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new OidcLogoutEndpointController(oidcConfigurationContext, postLogoutRedirectUrlMatcher, urlValidator);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"oidcRevocationEndpointController"})
        public OidcRevocationEndpointController oidcRevocationEndpointController(@Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new OidcRevocationEndpointController(oidcConfigurationContext);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"oidcAccessTokenController"})
        public OidcAccessTokenEndpointController oidcAccessTokenController(@Qualifier(value="accessTokenGrantAuditableRequestExtractor") AuditableExecution accessTokenGrantAuditableRequestExtractor, @Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new OidcAccessTokenEndpointController(oidcConfigurationContext, accessTokenGrantAuditableRequestExtractor);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"oidcDynamicClientRegistrationEndpointController"})
        public OidcDynamicClientRegistrationEndpointController oidcDynamicClientRegistrationEndpointController(@Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new OidcDynamicClientRegistrationEndpointController(oidcConfigurationContext);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcClientConfigurationEndpointController"})
        @Bean
        public OidcClientConfigurationEndpointController oidcClientConfigurationEndpointController(@Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new OidcClientConfigurationEndpointController(oidcConfigurationContext);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcInitialAccessTokenController"})
        @Bean
        public OidcInitialAccessTokenController oidcInitialAccessTokenController(@Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new OidcInitialAccessTokenController(oidcConfigurationContext);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcJwksController"})
        @Bean
        public OidcJwksEndpointController oidcJwksController(@Qualifier(value="oidcJsonWebKeystoreGeneratorService") OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService, @Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new OidcJwksEndpointController(oidcConfigurationContext, oidcJsonWebKeystoreGeneratorService);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"oidcIntrospectionEndpointController"})
        public OidcIntrospectionEndpointController oidcIntrospectionEndpointController(@Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new OidcIntrospectionEndpointController(oidcConfigurationContext);
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OidcJwksRotationEndpoint jwksRotationEndpoint(CasConfigurationProperties casProperties, @Qualifier(value="oidcJsonWebKeystoreRotationService") ObjectProvider<OidcJsonWebKeystoreRotationService> oidcJsonWebKeystoreRotationService) {
            return new OidcJwksRotationEndpoint(casProperties, oidcJsonWebKeystoreRotationService);
        }
    }

    @Configuration(value="OidcEndpointsWebConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcEndpointsWebConfiguration {
        @Generated
        private static final Logger LOGGER = LoggerFactory.getLogger(OidcEndpointsWebConfiguration.class);

        private static String getOidcBaseEndpoint(OidcIssuerService issuerService, CasConfigurationProperties casProperties) {
            String issuer = issuerService.determineIssuer(Optional.empty());
            String endpoint = StringUtils.remove((String)issuer, (String)casProperties.getServer().getPrefix());
            return StringUtils.prependIfMissing((String)endpoint, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public WebMvcConfigurer oidcWebMvcConfigurer(final @Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService, final @Qualifier(value="oauthInterceptor") ObjectProvider<HandlerInterceptor> oauthInterceptor, final CasConfigurationProperties casProperties) {
            return new WebMvcConfigurer(){

                public void addInterceptors(@Nonnull InterceptorRegistry registry) {
                    String baseEndpoint = OidcEndpointsWebConfiguration.getOidcBaseEndpoint(oidcIssuerService, casProperties);
                    LOGGER.info("Registering CAS OpenID Connect endpoints under [{}]. Verify to make sure this value is correctly defined based on your issuer and server settings, defined in CAS configuration. Failure to specify the correct value may interfere with OpenID Connect functionality.", (Object)baseEndpoint);
                    registry.addInterceptor((HandlerInterceptor)new RefreshableHandlerInterceptor(oauthInterceptor)).order(100).addPathPatterns(new String[]{baseEndpoint.concat("/*")});
                }
            };
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcProtocolEndpointConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebSecurityConfigurer<Void> oidcProtocolEndpointConfigurer(@Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService, CasConfigurationProperties casProperties) {
            final String baseEndpoint = OidcEndpointsWebConfiguration.getOidcBaseEndpoint(oidcIssuerService, casProperties);
            return new CasWebSecurityConfigurer<Void>(this){

                public List<String> getIgnoredEndpoints() {
                    return List.of(baseEndpoint);
                }
            };
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcLocaleChangeInterceptor"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public HandlerInterceptor oidcLocaleChangeInterceptor(@Qualifier(value="argumentExtractor") ObjectProvider<ArgumentExtractor> argumentExtractor, @Qualifier(value="servicesManager") ObjectProvider<ServicesManager> servicesManager, ObjectProvider<CasConfigurationProperties> casProperties) {
            OidcLocaleChangeInterceptor interceptor = new OidcLocaleChangeInterceptor(casProperties, argumentExtractor, servicesManager);
            interceptor.setParamName("ui_locales");
            return interceptor;
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcConfirmView"})
        public View oidcConfirmView(ConfigurableApplicationContext applicationContext, @Qualifier(value="casProtocolThymeleafViewFactory") CasProtocolViewFactory casProtocolViewFactory) {
            return casProtocolViewFactory.create(applicationContext, "protocol/oidc/confirm");
        }
    }

    @Configuration(value="OidcInterceptorsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcInterceptorsConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public HandlerInterceptor requiresAuthenticationDynamicRegistrationInterceptor(@Qualifier(value="oauthSecConfig") Config oauthSecConfig) {
            return new SecurityLogicInterceptor(oauthSecConfig, "clientDynamicRegistrationAuth");
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public HandlerInterceptor requiresAuthenticationClientConfigurationInterceptor(@Qualifier(value="oauthSecConfig") Config oauthSecConfig) {
            String clients = String.join((CharSequence)",", "ClientRegistrationClient");
            return new SecurityLogicInterceptor(oauthSecConfig, clients);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public HandlerInterceptor oauthInterceptor(ObjectProvider<List<AccessTokenGrantRequestExtractor>> accessTokenGrantRequestExtractors, ObjectProvider<List<OAuth20AuthorizationRequestValidator>> oauthRequestValidators, @Qualifier(value="oauthDistributedSessionStore") ObjectProvider<SessionStore> oauthDistributedSessionStore, @Qualifier(value="requiresAuthenticationAuthorizeInterceptor") ObjectProvider<HandlerInterceptor> requiresAuthenticationAuthorizeInterceptor, @Qualifier(value="requiresAuthenticationAccessTokenInterceptor") ObjectProvider<HandlerInterceptor> requiresAuthenticationAccessTokenInterceptor, @Qualifier(value="requiresAuthenticationClientConfigurationInterceptor") ObjectProvider<HandlerInterceptor> requiresAuthenticationClientConfigurationInterceptor, @Qualifier(value="requiresAuthenticationDynamicRegistrationInterceptor") ObjectProvider<HandlerInterceptor> requiresAuthenticationDynamicRegistrationInterceptor, @Qualifier(value="oauthRequestParameterResolver") ObjectProvider<OAuth20RequestParameterResolver> oauthRequestParameterResolver, @Qualifier(value="servicesManager") ObjectProvider<ServicesManager> servicesManager, CasConfigurationProperties casProperties) {
            return new OidcHandlerInterceptorAdapter(requiresAuthenticationAccessTokenInterceptor, requiresAuthenticationAuthorizeInterceptor, requiresAuthenticationDynamicRegistrationInterceptor, requiresAuthenticationClientConfigurationInterceptor, casProperties, accessTokenGrantRequestExtractors, servicesManager, oauthDistributedSessionStore, oauthRequestValidators, oauthRequestParameterResolver);
        }
    }

    @Configuration(value="OidcEndpointsLogoutConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcEndpointsLogoutConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"postLogoutRedirectUrlMatcher"})
        public OidcPostLogoutRedirectUrlMatcher postLogoutRedirectUrlMatcher() {
            return String::equalsIgnoreCase;
        }
    }

    @Configuration(value="OidcEndpointsMultifactorAuthenticationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcEndpointsMultifactorAuthenticationConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcMultifactorAuthenticationTrigger"})
        public MultifactorAuthenticationTrigger oidcMultifactorAuthenticationTrigger(@Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="multifactorAuthenticationProviderResolver") MultifactorAuthenticationProviderResolver multifactorAuthenticationProviderResolver, @Qualifier(value="oidcServerDiscoverySettingsFactory") FactoryBean<OidcServerDiscoverySettings> oidcServerDiscoverySettingsFactory, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return new OidcMultifactorAuthenticationTrigger(casProperties, multifactorAuthenticationProviderResolver, (ApplicationContext)applicationContext, oauthRequestParameterResolver, oidcServerDiscoverySettingsFactory);
        }
    }
}

