/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.InvalidPasswordException;
import org.apereo.cas.pm.PasswordChangeBean;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.inspektr.audit.annotation.Audit;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePasswordManagementService
implements PasswordManagementService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BasePasswordManagementService.class);
    protected final PasswordManagementProperties properties;
    private final CipherExecutor<Serializable, String> cipherExecutor;
    private final String issuer;

    @Override
    public String parseToken(String token) {
        try {
            String json = (String)this.cipherExecutor.decode((Object)token);
            JwtClaims claims = JwtClaims.parse((String)json);
            if (!claims.getIssuer().equals(this.issuer)) {
                LOGGER.error("Token issuer does not match CAS");
                return null;
            }
            if (claims.getAudience().isEmpty() || !((String)claims.getAudience().get(0)).equals(this.issuer)) {
                LOGGER.error("Token audience does not match CAS");
                return null;
            }
            if (StringUtils.isBlank((CharSequence)claims.getSubject())) {
                LOGGER.error("Token has no subject identifier");
                return null;
            }
            ClientInfo holder = ClientInfoHolder.getClientInfo();
            if (!claims.getStringClaimValue("origin").equals(holder.getServerIpAddress())) {
                LOGGER.error("Token origin server IP address does not match CAS");
                return null;
            }
            if (!claims.getStringClaimValue("client").equals(holder.getClientIpAddress())) {
                LOGGER.error("Token client IP address does not match CAS");
                return null;
            }
            if (claims.getExpirationTime().isBefore(NumericDate.now())) {
                LOGGER.error("Token has expired.");
                return null;
            }
            return claims.getSubject();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String createToken(String to) {
        try {
            String token = UUID.randomUUID().toString();
            JwtClaims claims = new JwtClaims();
            claims.setJwtId(token);
            claims.setIssuer(this.issuer);
            claims.setAudience(this.issuer);
            claims.setExpirationTimeMinutesInTheFuture(this.properties.getReset().getExpirationMinutes());
            claims.setIssuedAtToNow();
            ClientInfo holder = ClientInfoHolder.getClientInfo();
            if (holder != null) {
                claims.setStringClaim("origin", holder.getServerIpAddress());
                claims.setStringClaim("client", holder.getClientIpAddress());
            }
            claims.setSubject(to);
            String json = claims.toJson();
            return (String)this.cipherExecutor.encode((Object)json);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    @Audit(action="CHANGE_PASSWORD", actionResolverName="CHANGE_PASSWORD_ACTION_RESOLVER", resourceResolverName="CHANGE_PASSWORD_RESOURCE_RESOLVER")
    public boolean change(Credential c, PasswordChangeBean bean) throws InvalidPasswordException {
        return this.changeInternal(c, bean);
    }

    public boolean changeInternal(Credential c, PasswordChangeBean bean) throws InvalidPasswordException {
        return false;
    }

    public static List<String> canonicalizeSecurityQuestions(Map<String, String> questionMap) {
        ArrayList<String> keys = new ArrayList<String>(questionMap.keySet());
        keys.sort(String.CASE_INSENSITIVE_ORDER);
        return keys;
    }

    @Generated
    public BasePasswordManagementService(PasswordManagementProperties properties, CipherExecutor<Serializable, String> cipherExecutor, String issuer) {
        this.properties = properties;
        this.cipherExecutor = cipherExecutor;
        this.issuer = issuer;
    }
}

