/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.aspect;

import java.util.Arrays;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class TraceLogAspect {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ TraceLogAspect ajc$perSingletonInstance;

    @Around(value="(execution (public * org.apereo..*.*(..))) && !(execution( * org.apereo..*.set*(..)))")
    public Object traceMethod(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object object;
        Logger logger = null;
        try {
            logger = this.getLog((JoinPoint)proceedingJoinPoint);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (logger == null) {
            System.err.println("Could not obtain logger object from the proceeding joinpoint");
            return proceedingJoinPoint.proceed();
        }
        Object returnVal = null;
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            object = returnVal = proceedingJoinPoint.proceed();
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    protected Logger getLog(JoinPoint joinPoint) {
        Object target = joinPoint.getTarget();
        if (target != null) {
            return LoggerFactory.getLogger(target.getClass());
        }
        return LoggerFactory.getLogger(this.getClass());
    }

    public static TraceLogAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.apereo.inspektr.aspect.TraceLogAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            TraceLogAspect.ajc$perSingletonInstance = new TraceLogAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

