/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.tool;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Replace;
import org.apache.tools.ant.taskdefs.optional.ReplaceRegExp;
import org.apache.tools.ant.types.FileSet;
import org.appfuse.mojo.installer.AntUtils;

public class ArtifactUninstaller {
    private Log log;
    static final String FILE_SEP = System.getProperty("file.separator");
    Project antProject;
    String pojoName;
    String pojoNameLower;
    String installedDirectory;
    MavenProject project;
    boolean genericCore;

    public ArtifactUninstaller(MavenProject project, String pojoName, String installedDirectory, boolean genericCore) {
        this.project = project;
        this.pojoName = pojoName;
        this.pojoNameLower = this.pojoLowerCase(pojoName);
        this.installedDirectory = installedDirectory;
        this.genericCore = genericCore;
    }

    public void execute() {
        this.antProject = AntUtils.createProject();
        this.log("Removing sample data for DbUnit...");
        this.removeSampleData();
        if (this.project.getPackaging().equals("jar") || this.project.getPackaging().equals("war") && this.project.getParent() == null) {
            this.removeGeneratedFiles(this.installedDirectory, "**/dao/**/" + this.pojoName + "*.java");
            this.removeGeneratedFiles(this.installedDirectory, "**/service/**/" + this.pojoName + "*.java");
            if (this.genericCore) {
                this.log("Removing Spring bean definitions...");
                this.removeGenericBeanDefinitions();
            }
            this.removeiBATISFiles();
        }
        if (this.project.getPackaging().equalsIgnoreCase("war")) {
            this.removeGeneratedFiles(this.installedDirectory, "**/webapp/**/" + this.pojoName + "*.java");
            String webFramework = this.project.getProperties().getProperty("web.framework");
            if ("jsf".equalsIgnoreCase(webFramework)) {
                this.log("Installing JSF views and configuring...");
                this.removeJSFNavigationAndBeans();
                this.removeJSFViews();
            } else if ("struts".equalsIgnoreCase(webFramework)) {
                this.log("Removing Struts views and configuring...");
                this.removeStrutsActionDefinitions();
                this.removeGeneratedFiles(this.installedDirectory + "/src/main/resources", "**/model/" + this.pojoName + "*.xml");
                this.removeGeneratedFiles(this.installedDirectory + "/src/main/resources", "**/webapp/action/" + this.pojoName + "*.xml");
                this.removeStrutsViews();
            } else if ("spring".equalsIgnoreCase(webFramework)) {
                this.log("Removing Spring views and configuring...");
                this.removeSpringControllerBeanDefinitions();
                this.removeSpringValidation();
                this.removeSpringViews();
            } else if ("tapestry".equalsIgnoreCase(webFramework)) {
                this.log("Removing Tapestry views and configuring...");
                this.removeTapestryViews();
            }
            this.log("Removing i18n messages...");
            this.removeInternationalizationKeys();
            this.log("Removing menu...");
            this.removeMenu();
            this.log("Removing UI tests...");
            this.removeUITests();
        }
    }

    protected void removeGeneratedFiles(String installedDirectory, String removePattern) {
        Delete deleteTask = (Delete)this.antProject.createTask("delete");
        FileSet fileSet = AntUtils.createFileset(installedDirectory, removePattern, new ArrayList());
        this.log("Removing generated files (pattern: " + removePattern + ")...");
        deleteTask.addFileset(fileSet);
        deleteTask.execute();
    }

    private String pojoLowerCase(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    private String getPathToApplicationContext() {
        if (this.project.getPackaging().equalsIgnoreCase("war")) {
            return "/src/main/webapp/WEB-INF/applicationContext.xml";
        }
        return "/src/main/resources/applicationContext.xml";
    }

    private void removeSampleData() {
        File existingFile = new File(this.installedDirectory + "/src/test/resources/sample-data.xml");
        this.parseXMLFile(existingFile, null);
    }

    private void removeiBATISFiles() {
        if (this.project.getProperties().getProperty("dao.framework").equals("ibatis")) {
            this.log("Removing iBATIS SQL Maps...");
            File sqlMapConfig = new File(this.installedDirectory + "/src/main/resources/sql-map-config.xml");
            this.parseXMLFile(sqlMapConfig, null);
            File sqlMapsDir = new File(this.installedDirectory + "/src/main/resources/sqlmaps");
            if (!sqlMapsDir.exists()) {
                return;
            }
            this.removeGeneratedFiles(this.installedDirectory + "/src/main/resources/sqlmaps", this.pojoName + "SQL.xml");
        }
    }

    private void removeGenericBeanDefinitions() {
        File generatedFile = new File(this.installedDirectory + this.getPathToApplicationContext());
        this.parseXMLFile(generatedFile, this.pojoName + "Manager");
    }

    private void removeJSFNavigationAndBeans() {
        File generatedFile = new File(this.installedDirectory + "/src/main/webapp/WEB-INF/faces-config.xml");
        this.parseXMLFile(generatedFile, this.pojoName + "-nav");
    }

    private void removeSpringControllerBeanDefinitions() {
        File generatedFile = new File(this.installedDirectory + "/src/main/webapp/WEB-INF/dispatcher-servlet.xml");
        this.parseXMLFile(generatedFile, this.pojoName);
    }

    private void removeSpringValidation() {
        File generatedFile = new File(this.installedDirectory + "/src/main/webapp/WEB-INF/validation.xml");
        this.parseXMLFile(generatedFile, this.pojoName);
    }

    private void removeStrutsActionDefinitions() {
        File existingFile = new File(this.installedDirectory + "/src/main/resources/struts.xml");
        this.parseXMLFile(existingFile, this.pojoName + "Action");
    }

    private void removeJSFViews() {
        this.removeGeneratedFiles(this.installedDirectory + "/src/main/webapp", this.pojoNameLower + "*.xhtml");
    }

    private void removeSpringViews() {
        this.removeGeneratedFiles(this.installedDirectory + "/src/main/webapp/WEB-INF/pages", this.pojoNameLower + "*.jsp");
    }

    private void removeStrutsViews() {
        this.removeGeneratedFiles(this.installedDirectory + "/src/main/webapp/WEB-INF/pages", this.pojoNameLower + "*.jsp");
    }

    private void removeTapestryViews() {
        this.removeGeneratedFiles(this.installedDirectory + "/src/main/webapp", this.pojoName + "*.tml");
    }

    private void removeMenu() {
        File existingFile = new File(this.installedDirectory + "/src/main/webapp/WEB-INF/menu-config.xml");
        if (existingFile.exists()) {
            this.parseXMLFile(existingFile, this.pojoName);
            existingFile = new File(this.installedDirectory + "/src/main/webapp/WEB-INF/menu-config.xml");
            this.parseXMLFile(existingFile, this.pojoName);
            existingFile = new File(this.installedDirectory + "/src/main/webapp/common/menu.jsp");
            this.parseXMLFile(existingFile, this.pojoName);
        } else if (this.isAppFuse()) {
            existingFile = new File(this.installedDirectory + "/src/main/resources/" + this.project.getGroupId().replace(".", "/") + "/webapp/components/Layout.tml");
            this.parseXMLFile(existingFile, this.pojoName);
        } else {
            existingFile = new File(this.installedDirectory + "/src/main/webapp/decorators/default.jsp");
            File jsfConfig = new File(this.installedDirectory + "/src/main/webapp/WEB-INF/faces-config.xml");
            if (jsfConfig.exists()) {
                existingFile = new File(this.installedDirectory + "/src/main/webapp/layouts/default.xhtml");
            }
            this.parseXMLFile(existingFile, this.pojoName);
        }
    }

    private boolean isAppFuse() {
        return this.project.getProperties().getProperty("copyright.year") != null;
    }

    private void removeInternationalizationKeys() {
        File existingFile = new File(this.installedDirectory + "/src/main/resources/ApplicationResources.properties");
        if (!existingFile.exists()) {
            existingFile = new File(this.installedDirectory + "/src/main/resources/messages.properties");
        }
        this.parsePropertiesFile(existingFile, this.pojoName);
    }

    private void removeUITests() {
        File existingFile = new File(this.installedDirectory + "/src/test/resources/web-tests.xml");
        if (existingFile.exists()) {
            this.parseXMLFile(existingFile, this.pojoName);
            Replace replace = (Replace)this.antProject.createTask("replace");
            replace.setFile(existingFile);
            replace.setToken("," + this.pojoName + "Tests");
            replace.execute();
        }
    }

    private void parseXMLFile(File existingFile, String beanName) {
        String nameInComment = beanName;
        if (beanName == null) {
            nameInComment = this.pojoName;
        }
        Replace replace1 = (Replace)this.antProject.createTask("replace");
        replace1.setFile(existingFile);
        replace1.setToken("<!--" + nameInComment + "-START-->");
        replace1.setValue("REGULAR-START");
        replace1.execute();
        Replace replace2 = (Replace)this.antProject.createTask("replace");
        replace2.setFile(existingFile);
        replace2.setToken("<!--" + nameInComment + "-END-->");
        replace2.setValue("REGULAR-END");
        replace2.execute();
        ReplaceRegExp regExpTask = (ReplaceRegExp)this.antProject.createTask("replaceregexp");
        regExpTask.setFile(existingFile);
        regExpTask.setMatch("REGULAR-START(?s:.)*REGULAR-END");
        regExpTask.setReplace("");
        regExpTask.setFlags("g");
        regExpTask.execute();
    }

    private void parsePropertiesFile(File existingFile, String beanName) {
        String nameInComment = beanName;
        if (beanName == null) {
            nameInComment = this.pojoName;
        }
        Replace replace1 = (Replace)this.antProject.createTask("replace");
        replace1.setFile(existingFile);
        replace1.setToken("# -- " + nameInComment + "-START");
        replace1.setValue("REGULAR-START");
        replace1.execute();
        Replace replace2 = (Replace)this.antProject.createTask("replace");
        replace2.setFile(existingFile);
        replace2.setToken("# -- " + nameInComment + "-END");
        replace2.setValue("REGULAR-END");
        replace2.execute();
        ReplaceRegExp regExpTask = (ReplaceRegExp)this.antProject.createTask("replaceregexp");
        regExpTask.setFile(existingFile);
        regExpTask.setMatch("REGULAR-START(?s:.)*REGULAR-END");
        regExpTask.setReplace("");
        regExpTask.setFlags("g");
        regExpTask.execute();
    }

    private void log(String msg) {
        this.getLog().info((CharSequence)("[AppFuse] " + msg));
    }

    public Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setGenericCore(boolean genericCore) {
        this.genericCore = genericCore;
    }
}

