/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi;

import java.io.IOException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.asteriskjava.fastagi.AbstractAgiServer;
import org.asteriskjava.fastagi.AgiScript;
import org.asteriskjava.fastagi.AgiServer;
import org.asteriskjava.fastagi.ClassNameMappingStrategy;
import org.asteriskjava.fastagi.CompositeMappingStrategy;
import org.asteriskjava.fastagi.MappingStrategy;
import org.asteriskjava.fastagi.ResourceBundleMappingStrategy;
import org.asteriskjava.fastagi.StaticMappingStrategy;
import org.asteriskjava.fastagi.internal.FastAgiConnectionHandler;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.ReflectionUtil;
import org.asteriskjava.util.ServerSocketFacade;
import org.asteriskjava.util.SocketConnectionFacade;
import org.asteriskjava.util.internal.ServerSocketFacadeImpl;

public class DefaultAgiServer
extends AbstractAgiServer
implements AgiServer {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String DEFAULT_CONFIG_RESOURCE_BUNDLE_NAME = "fastagi";
    private static final int DEFAULT_BIND_PORT = 4573;
    private ServerSocketFacade serverSocket;
    private String configResourceBundleName = "fastagi";
    private int port = 4573;

    public DefaultAgiServer() {
        this(null, null);
    }

    public DefaultAgiServer(String configResourceBundleName) {
        this(configResourceBundleName, null);
    }

    public DefaultAgiServer(MappingStrategy mappingStrategy) {
        this(null, mappingStrategy);
    }

    public DefaultAgiServer(AgiScript agiScript) {
        this(null, new StaticMappingStrategy(agiScript));
    }

    public DefaultAgiServer(String configResourceBundleName, MappingStrategy mappingStrategy) {
        if (mappingStrategy == null) {
            CompositeMappingStrategy compositeMappingStrategy = new CompositeMappingStrategy();
            compositeMappingStrategy.addStrategy(new ResourceBundleMappingStrategy());
            compositeMappingStrategy.addStrategy(new ClassNameMappingStrategy());
            if (ReflectionUtil.isClassAvailable("javax.script.ScriptEngineManager")) {
                MappingStrategy scriptEngineMappingStrategy = (MappingStrategy)ReflectionUtil.newInstance("org.asteriskjava.fastagi.ScriptEngineMappingStrategy");
                if (scriptEngineMappingStrategy != null) {
                    compositeMappingStrategy.addStrategy(scriptEngineMappingStrategy);
                }
            } else {
                this.logger.warn("ScriptEngine support disabled: It is only availble when running at least Java 6");
            }
            this.setMappingStrategy(compositeMappingStrategy);
        } else {
            this.setMappingStrategy(mappingStrategy);
        }
        if (configResourceBundleName != null) {
            this.configResourceBundleName = configResourceBundleName;
        }
        this.loadConfig();
    }

    public void setBindPort(int bindPort) {
        this.port = bindPort;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    private void loadConfig() {
        ResourceBundle resourceBundle;
        try {
            resourceBundle = ResourceBundle.getBundle(this.configResourceBundleName);
        }
        catch (MissingResourceException e) {
            return;
        }
        try {
            String portString;
            try {
                portString = resourceBundle.getString("port");
            }
            catch (MissingResourceException e) {
                portString = resourceBundle.getString("bindPort");
            }
            this.port = Integer.parseInt(portString);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.setPoolSize(Integer.parseInt(resourceBundle.getString("poolSize")));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.setMaximumPoolSize(Integer.parseInt(resourceBundle.getString("maximumPoolSize")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ServerSocketFacade createServerSocket() throws IOException {
        return new ServerSocketFacadeImpl(this.port, 0, null);
    }

    public void startup() throws IOException, IllegalStateException {
        try {
            this.serverSocket = this.createServerSocket();
        }
        catch (IOException e) {
            this.logger.error("Unable start AgiServer: cannot to bind to *:" + this.port + ".", e);
            throw e;
        }
        this.logger.info("Listening on *:" + this.port + ".");
        while (true) {
            try {
                while (true) {
                    SocketConnectionFacade socket = this.serverSocket.accept();
                    this.logger.info("Received connection from " + socket.getRemoteAddress());
                    FastAgiConnectionHandler connectionHandler = new FastAgiConnectionHandler(this.getMappingStrategy(), socket);
                    this.execute(connectionHandler);
                }
            }
            catch (IOException e) {
                if (!this.isDie()) {
                    this.handleException("IOException while waiting for connections.", e);
                    continue;
                }
                this.logger.info("AgiServer shut down.");
                return;
            }
            break;
        }
    }

    public void run() {
        try {
            this.startup();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void shutdown() throws IllegalStateException {
        super.shutdown();
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                this.logger.warn("IOException while closing server socket.", e);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) throws Exception {
        DefaultAgiServer server = new DefaultAgiServer();
        server.startup();
    }
}

