/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.asteriskjava.fastagi.AgiChannel;
import org.asteriskjava.fastagi.AgiException;
import org.asteriskjava.fastagi.AgiRequest;
import org.asteriskjava.fastagi.AgiScript;
import org.asteriskjava.fastagi.MappingStrategy;
import org.asteriskjava.fastagi.NamedAgiScript;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class ScriptEngineMappingStrategy
implements MappingStrategy {
    protected final Log logger = LogFactory.getLog(this.getClass());
    public static final String REQUEST = "request";
    public static final String CHANNEL = "channel";
    private static final String[] DEFAULT_SCRIPT_PATH = new String[]{"agi"};
    private static final String[] DEFAULT_LIB_PATH = new String[]{"lib"};
    protected String[] scriptPath;
    protected String[] libPath;
    protected ScriptEngineManager scriptEngineManager = null;

    public ScriptEngineMappingStrategy() {
        this(DEFAULT_SCRIPT_PATH, DEFAULT_LIB_PATH);
    }

    public ScriptEngineMappingStrategy(String[] scriptPath, String[] libPath) {
        this.scriptPath = scriptPath;
        this.libPath = libPath;
    }

    public void setScriptPath(String[] scriptPath) {
        this.scriptPath = scriptPath;
    }

    public void setLibPath(String[] libPath) {
        this.libPath = libPath;
    }

    public AgiScript determineScript(AgiRequest request) {
        File file = this.searchFile(request.getScript(), this.scriptPath);
        if (file == null) {
            return null;
        }
        ScriptEngine scriptEngine = this.getScriptEngine(file);
        if (scriptEngine == null) {
            this.logger.debug("No ScriptEngine found that can handle '" + file.getPath() + "'");
            return null;
        }
        return new ScriptEngineAgiScript(file, scriptEngine);
    }

    protected ScriptEngine getScriptEngine(File file) {
        String extension = ScriptEngineMappingStrategy.getExtension(file.getName());
        if (extension == null) {
            return null;
        }
        return this.getScriptEngineManager().getEngineByExtension(extension);
    }

    protected synchronized ScriptEngineManager getScriptEngineManager() {
        if (this.scriptEngineManager == null) {
            this.scriptEngineManager = new ScriptEngineManager(this.getClassLoader());
        }
        return this.scriptEngineManager;
    }

    protected ClassLoader getClassLoader() {
        ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<URL> jarFileUrls = new ArrayList<URL>();
        if (this.libPath == null || this.libPath.length == 0) {
            return parentClassLoader;
        }
        for (String libPathEntry : this.libPath) {
            File[] jarFiles;
            File libDir = new File(libPathEntry);
            if (!libDir.isDirectory()) continue;
            for (File jarFile : jarFiles = libDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            })) {
                try {
                    jarFileUrls.add(jarFile.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
        }
        if (jarFileUrls.size() == 0) {
            return parentClassLoader;
        }
        return new URLClassLoader(jarFileUrls.toArray(new URL[jarFileUrls.size()]), parentClassLoader);
    }

    protected File searchFile(String scriptName, String[] path) {
        if (scriptName == null || path == null) {
            return null;
        }
        for (String pathElement : path) {
            File file;
            File pathElementDir = new File(pathElement);
            if (!pathElementDir.isDirectory() || !(file = new File(pathElementDir, scriptName.replaceAll("/", Matcher.quoteReplacement(File.separator)))).exists()) continue;
            try {
                if (!this.isInside(file, pathElementDir)) {
                    return null;
                }
            }
            catch (IOException e) {
                this.logger.warn("Unable to check whether '" + file.getPath() + "' is below '" + pathElementDir.getPath() + "'");
                continue;
            }
            try {
                return file.getCanonicalFile();
            }
            catch (IOException e) {
                this.logger.error("Unable to get canonical file for '" + file.getPath() + "'", e);
            }
        }
        return null;
    }

    protected final boolean isInside(File file, File dir) throws IOException {
        return file.getCanonicalPath().startsWith(dir.getCanonicalPath());
    }

    protected static String getExtension(String scriptName) {
        String fileName;
        int extensionPosition;
        if (scriptName == null) {
            return null;
        }
        int filePosition = scriptName.lastIndexOf("/");
        if (scriptName.lastIndexOf("\\") > filePosition) {
            filePosition = scriptName.lastIndexOf("\\");
        }
        if ((extensionPosition = (fileName = filePosition >= 0 ? scriptName.substring(filePosition + 1) : scriptName).lastIndexOf(".")) >= 0) {
            return fileName.substring(extensionPosition + 1);
        }
        return null;
    }

    protected static Reader getReader(File file) throws FileNotFoundException {
        FileInputStream is = new FileInputStream(file);
        return new InputStreamReader(is);
    }

    protected void populateBindings(File file, AgiRequest request, AgiChannel channel, Bindings bindings) {
    }

    protected class ScriptEngineAgiScript
    implements NamedAgiScript {
        final File file;
        final ScriptEngine scriptEngine;

        public ScriptEngineAgiScript(File file, ScriptEngine scriptEngine) {
            this.file = file;
            this.scriptEngine = scriptEngine;
        }

        public String getName() {
            return this.file == null ? null : this.file.getName();
        }

        public void service(AgiRequest request, AgiChannel channel) throws AgiException {
            Bindings bindings = this.scriptEngine.createBindings();
            bindings.put("javax.script.filename", (Object)this.file.getPath());
            bindings.put(ScriptEngineMappingStrategy.REQUEST, (Object)request);
            bindings.put(ScriptEngineMappingStrategy.CHANNEL, (Object)channel);
            ScriptEngineMappingStrategy.this.populateBindings(this.file, request, channel, bindings);
            try {
                this.scriptEngine.eval(ScriptEngineMappingStrategy.getReader(this.file), bindings);
            }
            catch (ScriptException e) {
                throw new AgiException("Execution of script '" + this.file.getPath() + "' with ScriptEngine failed", e);
            }
            catch (FileNotFoundException e) {
                throw new AgiException("Script '" + this.file.getPath() + "' not found", e);
            }
        }
    }
}

