/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.internal;

import org.asteriskjava.fastagi.AgiChannel;
import org.asteriskjava.fastagi.AgiException;
import org.asteriskjava.fastagi.AgiHangupException;
import org.asteriskjava.fastagi.AgiRequest;
import org.asteriskjava.fastagi.AgiSpeechException;
import org.asteriskjava.fastagi.InvalidCommandSyntaxException;
import org.asteriskjava.fastagi.InvalidOrUnknownCommandException;
import org.asteriskjava.fastagi.SpeechRecognitionResult;
import org.asteriskjava.fastagi.command.AgiCommand;
import org.asteriskjava.fastagi.command.AnswerCommand;
import org.asteriskjava.fastagi.command.ChannelStatusCommand;
import org.asteriskjava.fastagi.command.ControlStreamFileCommand;
import org.asteriskjava.fastagi.command.DatabaseDelCommand;
import org.asteriskjava.fastagi.command.DatabaseDelTreeCommand;
import org.asteriskjava.fastagi.command.DatabaseGetCommand;
import org.asteriskjava.fastagi.command.DatabasePutCommand;
import org.asteriskjava.fastagi.command.ExecCommand;
import org.asteriskjava.fastagi.command.GetDataCommand;
import org.asteriskjava.fastagi.command.GetFullVariableCommand;
import org.asteriskjava.fastagi.command.GetOptionCommand;
import org.asteriskjava.fastagi.command.GetVariableCommand;
import org.asteriskjava.fastagi.command.HangupCommand;
import org.asteriskjava.fastagi.command.RecordFileCommand;
import org.asteriskjava.fastagi.command.SayAlphaCommand;
import org.asteriskjava.fastagi.command.SayDateTimeCommand;
import org.asteriskjava.fastagi.command.SayDigitsCommand;
import org.asteriskjava.fastagi.command.SayNumberCommand;
import org.asteriskjava.fastagi.command.SayPhoneticCommand;
import org.asteriskjava.fastagi.command.SayTimeCommand;
import org.asteriskjava.fastagi.command.SetAutoHangupCommand;
import org.asteriskjava.fastagi.command.SetCallerIdCommand;
import org.asteriskjava.fastagi.command.SetContextCommand;
import org.asteriskjava.fastagi.command.SetExtensionCommand;
import org.asteriskjava.fastagi.command.SetMusicOffCommand;
import org.asteriskjava.fastagi.command.SetMusicOnCommand;
import org.asteriskjava.fastagi.command.SetPriorityCommand;
import org.asteriskjava.fastagi.command.SetVariableCommand;
import org.asteriskjava.fastagi.command.SpeechActivateGrammarCommand;
import org.asteriskjava.fastagi.command.SpeechCreateCommand;
import org.asteriskjava.fastagi.command.SpeechDeactivateGrammarCommand;
import org.asteriskjava.fastagi.command.SpeechDestroyCommand;
import org.asteriskjava.fastagi.command.SpeechLoadGrammarCommand;
import org.asteriskjava.fastagi.command.SpeechRecognizeCommand;
import org.asteriskjava.fastagi.command.SpeechSetCommand;
import org.asteriskjava.fastagi.command.SpeechUnloadGrammarCommand;
import org.asteriskjava.fastagi.command.StreamFileCommand;
import org.asteriskjava.fastagi.command.VerboseCommand;
import org.asteriskjava.fastagi.command.WaitForDigitCommand;
import org.asteriskjava.fastagi.internal.AgiReader;
import org.asteriskjava.fastagi.internal.AgiWriter;
import org.asteriskjava.fastagi.internal.FastAgiReader;
import org.asteriskjava.fastagi.internal.FastAgiWriter;
import org.asteriskjava.fastagi.reply.AgiReply;
import org.asteriskjava.util.SocketConnectionFacade;

public class AgiChannelImpl
implements AgiChannel {
    private final AgiRequest request;
    private final AgiWriter agiWriter;
    private final AgiReader agiReader;
    private AgiReply lastReply;

    AgiChannelImpl(AgiRequest request, SocketConnectionFacade socket) {
        this.request = request;
        this.agiWriter = new FastAgiWriter(socket);
        this.agiReader = new FastAgiReader(socket);
        this.lastReply = null;
    }

    AgiChannelImpl(AgiRequest request, AgiWriter agiWriter, AgiReader agiReader) {
        this.request = request;
        this.agiWriter = agiWriter;
        this.agiReader = agiReader;
        this.lastReply = null;
    }

    public String getName() {
        return this.request.getChannel();
    }

    public String getUniqueId() {
        return this.request.getUniqueId();
    }

    public AgiReply getLastReply() {
        return this.lastReply;
    }

    public synchronized AgiReply sendCommand(AgiCommand command) throws AgiException {
        this.agiWriter.sendCommand(command);
        this.lastReply = this.agiReader.readReply();
        if (this.lastReply.getStatus() == 510) {
            throw new InvalidOrUnknownCommandException(command.buildCommand());
        }
        if (this.lastReply.getStatus() == 511) {
            throw new AgiHangupException();
        }
        if (this.lastReply.getStatus() == 520) {
            throw new InvalidCommandSyntaxException(this.lastReply.getSynopsis(), this.lastReply.getUsage());
        }
        return this.lastReply;
    }

    public void answer() throws AgiException {
        this.sendCommand(new AnswerCommand());
    }

    public void hangup() throws AgiException {
        this.sendCommand(new HangupCommand());
    }

    public void setAutoHangup(int time) throws AgiException {
        this.sendCommand(new SetAutoHangupCommand(time));
    }

    public void setCallerId(String callerId) throws AgiException {
        this.sendCommand(new SetCallerIdCommand(callerId));
    }

    public void playMusicOnHold() throws AgiException {
        this.sendCommand(new SetMusicOnCommand());
    }

    public void playMusicOnHold(String musicOnHoldClass) throws AgiException {
        this.sendCommand(new SetMusicOnCommand(musicOnHoldClass));
    }

    public void stopMusicOnHold() throws AgiException {
        this.sendCommand(new SetMusicOffCommand());
    }

    public int getChannelStatus() throws AgiException {
        this.sendCommand(new ChannelStatusCommand());
        return this.lastReply.getResultCode();
    }

    public String getData(String file) throws AgiException {
        this.sendCommand(new GetDataCommand(file));
        return this.lastReply.getResult();
    }

    public String getData(String file, long timeout) throws AgiException {
        this.sendCommand(new GetDataCommand(file, timeout));
        return this.lastReply.getResult();
    }

    public String getData(String file, long timeout, int maxDigits) throws AgiException {
        this.sendCommand(new GetDataCommand(file, timeout, maxDigits));
        return this.lastReply.getResult();
    }

    public char getOption(String file, String escapeDigits) throws AgiException {
        this.sendCommand(new GetOptionCommand(file, escapeDigits));
        return this.lastReply.getResultCodeAsChar();
    }

    public char getOption(String file, String escapeDigits, long timeout) throws AgiException {
        this.sendCommand(new GetOptionCommand(file, escapeDigits, timeout));
        return this.lastReply.getResultCodeAsChar();
    }

    public int exec(String application) throws AgiException {
        this.sendCommand(new ExecCommand(application));
        return this.lastReply.getResultCode();
    }

    public int exec(String application, String options) throws AgiException {
        this.sendCommand(new ExecCommand(application, options));
        return this.lastReply.getResultCode();
    }

    public void setContext(String context) throws AgiException {
        this.sendCommand(new SetContextCommand(context));
    }

    public void setExtension(String extension) throws AgiException {
        this.sendCommand(new SetExtensionCommand(extension));
    }

    public void setPriority(String priority) throws AgiException {
        this.sendCommand(new SetPriorityCommand(priority));
    }

    public void streamFile(String file) throws AgiException {
        this.sendCommand(new StreamFileCommand(file));
    }

    public char streamFile(String file, String escapeDigits) throws AgiException {
        this.sendCommand(new StreamFileCommand(file, escapeDigits));
        return this.lastReply.getResultCodeAsChar();
    }

    public char streamFile(String file, String escapeDigits, int offset) throws AgiException {
        this.sendCommand(new StreamFileCommand(file, escapeDigits, offset));
        return this.lastReply.getResultCodeAsChar();
    }

    public void sayDigits(String digits) throws AgiException {
        this.sendCommand(new SayDigitsCommand(digits));
    }

    public char sayDigits(String digits, String escapeDigits) throws AgiException {
        this.sendCommand(new SayDigitsCommand(digits, escapeDigits));
        return this.lastReply.getResultCodeAsChar();
    }

    public void sayNumber(String number) throws AgiException {
        this.sendCommand(new SayNumberCommand(number));
    }

    public char sayNumber(String number, String escapeDigits) throws AgiException {
        this.sendCommand(new SayNumberCommand(number, escapeDigits));
        return this.lastReply.getResultCodeAsChar();
    }

    public void sayPhonetic(String text) throws AgiException {
        this.sendCommand(new SayPhoneticCommand(text));
    }

    public char sayPhonetic(String text, String escapeDigits) throws AgiException {
        this.sendCommand(new SayPhoneticCommand(text, escapeDigits));
        return this.lastReply.getResultCodeAsChar();
    }

    public void sayAlpha(String text) throws AgiException {
        this.sendCommand(new SayAlphaCommand(text));
    }

    public char sayAlpha(String text, String escapeDigits) throws AgiException {
        this.sendCommand(new SayAlphaCommand(text, escapeDigits));
        return this.lastReply.getResultCodeAsChar();
    }

    public void sayTime(long time) throws AgiException {
        this.sendCommand(new SayTimeCommand(time));
    }

    public char sayTime(long time, String escapeDigits) throws AgiException {
        this.sendCommand(new SayTimeCommand(time, escapeDigits));
        return this.lastReply.getResultCodeAsChar();
    }

    public String getVariable(String name) throws AgiException {
        this.sendCommand(new GetVariableCommand(name));
        if (this.lastReply.getResultCode() != 1) {
            return null;
        }
        return this.lastReply.getExtra();
    }

    public void setVariable(String name, String value) throws AgiException {
        this.sendCommand(new SetVariableCommand(name, value));
    }

    public char waitForDigit(int timeout) throws AgiException {
        this.sendCommand(new WaitForDigitCommand(timeout));
        return this.lastReply.getResultCodeAsChar();
    }

    public String getFullVariable(String name) throws AgiException {
        this.sendCommand(new GetFullVariableCommand(name));
        if (this.lastReply.getResultCode() != 1) {
            return null;
        }
        return this.lastReply.getExtra();
    }

    public String getFullVariable(String name, String channel) throws AgiException {
        this.sendCommand(new GetFullVariableCommand(name, channel));
        if (this.lastReply.getResultCode() != 1) {
            return null;
        }
        return this.lastReply.getExtra();
    }

    public char sayDateTime(long time, String escapeDigits, String format, String timezone) throws AgiException {
        this.sendCommand(new SayDateTimeCommand(time, escapeDigits, format, timezone));
        return this.lastReply.getResultCodeAsChar();
    }

    public char sayDateTime(long time, String escapeDigits, String format) throws AgiException {
        this.sendCommand(new SayDateTimeCommand(time, escapeDigits, format));
        return this.lastReply.getResultCodeAsChar();
    }

    public char sayDateTime(long time, String escapeDigits) throws AgiException {
        this.sendCommand(new SayDateTimeCommand(time, escapeDigits));
        return this.lastReply.getResultCodeAsChar();
    }

    public void sayDateTime(long time) throws AgiException {
        this.sendCommand(new SayDateTimeCommand(time));
    }

    public String databaseGet(String family, String key) throws AgiException {
        this.sendCommand(new DatabaseGetCommand(family, key));
        if (this.lastReply.getResultCode() != 1) {
            return null;
        }
        return this.lastReply.getExtra();
    }

    public void databasePut(String family, String key, String value) throws AgiException {
        this.sendCommand(new DatabasePutCommand(family, key, value));
    }

    public void databaseDel(String family, String key) throws AgiException {
        this.sendCommand(new DatabaseDelCommand(family, key));
    }

    public void databaseDelTree(String family) throws AgiException {
        this.sendCommand(new DatabaseDelTreeCommand(family));
    }

    public void databaseDelTree(String family, String keytree) throws AgiException {
        this.sendCommand(new DatabaseDelTreeCommand(family, keytree));
    }

    public void verbose(String message, int level) throws AgiException {
        this.sendCommand(new VerboseCommand(message, level));
    }

    public char recordFile(String file, String format, String escapeDigits, int timeout) throws AgiException {
        this.sendCommand(new RecordFileCommand(file, format, escapeDigits, timeout));
        return this.lastReply.getResultCodeAsChar();
    }

    public char recordFile(String file, String format, String escapeDigits, int timeout, int offset, boolean beep, int maxSilence) throws AgiException {
        this.sendCommand(new RecordFileCommand(file, format, escapeDigits, timeout, offset, beep, maxSilence));
        return this.lastReply.getResultCodeAsChar();
    }

    public void controlStreamFile(String file) throws AgiException {
        this.sendCommand(new ControlStreamFileCommand(file));
    }

    public char controlStreamFile(String file, String escapeDigits) throws AgiException {
        this.sendCommand(new ControlStreamFileCommand(file, escapeDigits));
        return this.lastReply.getResultCodeAsChar();
    }

    public char controlStreamFile(String file, String escapeDigits, int offset) throws AgiException {
        this.sendCommand(new ControlStreamFileCommand(file, escapeDigits, offset));
        return this.lastReply.getResultCodeAsChar();
    }

    public char controlStreamFile(String file, String escapeDigits, int offset, String forwardDigit, String rewindDigit, String pauseDigit) throws AgiException {
        this.sendCommand(new ControlStreamFileCommand(file, escapeDigits, offset, forwardDigit, rewindDigit, pauseDigit));
        return this.lastReply.getResultCodeAsChar();
    }

    public void speechCreate() throws AgiException {
        this.speechCreate("");
    }

    public void speechCreate(String engine) throws AgiException {
        this.sendCommand(new SpeechCreateCommand(engine));
        if (this.lastReply.getResultCode() != 1) {
            if (engine == null || "".equals(engine)) {
                throw new AgiSpeechException("Speech object for default engine cannot be created");
            }
            throw new AgiSpeechException("Speech object for engine '" + engine + "' cannot be created");
        }
    }

    public void speechSet(String name, String value) throws AgiException {
        this.sendCommand(new SpeechSetCommand(name, value));
        if (this.lastReply.getResultCode() != 1) {
            throw new AgiSpeechException("Setting '" + name + "' cannot be set to '" + value + "'");
        }
    }

    public void speechDestroy() throws AgiException {
        this.sendCommand(new SpeechDestroyCommand());
        if (this.lastReply.getResultCode() != 1) {
            throw new AgiSpeechException("Speech object cannot be destroyed");
        }
    }

    public void speechLoadGrammar(String name, String path) throws AgiException {
        this.sendCommand(new SpeechLoadGrammarCommand(name, path));
        if (this.lastReply.getResultCode() != 1) {
            throw new AgiSpeechException("Grammar '" + name + "' cannot be loaded from '" + path + "'");
        }
    }

    public void speechUnloadGrammar(String name) throws AgiException {
        this.sendCommand(new SpeechUnloadGrammarCommand(name));
        if (this.lastReply.getResultCode() != 1) {
            throw new AgiSpeechException("Grammar '" + name + "' cannot be unloaded");
        }
    }

    public void speechActivateGrammar(String name) throws AgiException {
        this.sendCommand(new SpeechActivateGrammarCommand(name));
        if (this.lastReply.getResultCode() != 1) {
            throw new AgiSpeechException("Grammar '" + name + "' cannot be activated");
        }
    }

    public void speechDeactivateGrammar(String name) throws AgiException {
        this.sendCommand(new SpeechDeactivateGrammarCommand(name));
        if (this.lastReply.getResultCode() != 1) {
            throw new AgiSpeechException("Grammar '" + name + "' cannot be deactivated");
        }
    }

    public SpeechRecognitionResult speechRecognize(String prompt, int timeout) throws AgiException {
        return this.speechRecognize(new SpeechRecognizeCommand(prompt, timeout));
    }

    public SpeechRecognitionResult speechRecognize(String prompt, int timeout, int offset) throws AgiException {
        return this.speechRecognize(new SpeechRecognizeCommand(prompt, timeout, offset));
    }

    private SpeechRecognitionResult speechRecognize(SpeechRecognizeCommand command) throws AgiException {
        this.sendCommand(command);
        if (this.lastReply.getResultCode() != 1) {
            throw new AgiSpeechException("Cannot recognize speech");
        }
        if ("hangup".equals(this.lastReply.getExtra())) {
            throw new AgiHangupException();
        }
        AgiReply speechRecognizeReply = this.lastReply;
        return new SpeechRecognitionResult(speechRecognizeReply);
    }

    public void continueAt(String context, String extension, String priority) throws AgiException {
        this.setContext(context);
        this.setExtension(extension);
        this.setPriority(priority);
    }
}

