/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.internal;

import org.asteriskjava.fastagi.AgiChannel;
import org.asteriskjava.fastagi.AgiException;
import org.asteriskjava.fastagi.AgiRequest;
import org.asteriskjava.fastagi.AgiScript;
import org.asteriskjava.fastagi.MappingStrategy;
import org.asteriskjava.fastagi.NamedAgiScript;
import org.asteriskjava.fastagi.command.VerboseCommand;
import org.asteriskjava.fastagi.internal.AgiChannelImpl;
import org.asteriskjava.fastagi.internal.AgiReader;
import org.asteriskjava.fastagi.internal.AgiWriter;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public abstract class AgiConnectionHandler
implements Runnable {
    private static final String AJ_AGISTATUS_VARIABLE = "AJ_AGISTATUS";
    private static final String AJ_AGISTATUS_NOT_FOUND = "NOT_FOUND";
    private static final String AJ_AGISTATUS_SUCCESS = "SUCCESS";
    private static final String AJ_AGISTATUS_FAILED = "FAILED";
    private static final ThreadLocal<AgiChannel> channel = new ThreadLocal();
    private final Log logger = LogFactory.getLog(this.getClass());
    private boolean ignoreMissingScripts = false;
    private AgiScript script = null;
    private final MappingStrategy mappingStrategy;

    protected AgiConnectionHandler(MappingStrategy mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
    }

    protected boolean isIgnoreMissingScripts() {
        return this.ignoreMissingScripts;
    }

    protected void setIgnoreMissingScripts(boolean ignoreMissingScripts) {
        this.ignoreMissingScripts = ignoreMissingScripts;
    }

    protected AgiScript getScript() {
        return this.script;
    }

    protected abstract AgiReader createReader();

    protected abstract AgiWriter createWriter();

    protected abstract void release();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        AgiChannelImpl channel = null;
        try {
            AgiReader reader = this.createReader();
            AgiWriter writer = this.createWriter();
            AgiRequest request = reader.readRequest();
            channel = new AgiChannelImpl(request, writer, reader);
            AgiConnectionHandler.channel.set(channel);
            if (this.mappingStrategy != null) {
                this.script = this.mappingStrategy.determineScript(request);
            }
            if (this.script == null && !this.ignoreMissingScripts) {
                String errorMessage = "No script configured for URL '" + request.getRequestURL() + "' (script '" + request.getScript() + "')";
                this.logger.error(errorMessage);
                this.setStatusVariable(channel, AJ_AGISTATUS_NOT_FOUND);
                this.logToAsterisk(channel, errorMessage);
            } else if (this.script != null) {
                this.runScript(this.script, request, channel);
            }
        }
        catch (AgiException e) {
            this.setStatusVariable(channel, AJ_AGISTATUS_FAILED);
            this.logger.error("AgiException while handling request", e);
        }
        catch (Exception e) {
            this.setStatusVariable(channel, AJ_AGISTATUS_FAILED);
            this.logger.error("Unexpected Exception while handling request", e);
        }
        finally {
            AgiConnectionHandler.channel.set(null);
            this.release();
        }
    }

    private void runScript(AgiScript script, AgiRequest request, AgiChannel channel) {
        String threadName = Thread.currentThread().getName();
        this.logger.info("Begin AgiScript " + this.getScriptName(script) + " on " + threadName);
        try {
            script.service(request, channel);
            this.setStatusVariable(channel, AJ_AGISTATUS_SUCCESS);
        }
        catch (AgiException e) {
            this.logger.error("AgiException running AgiScript " + this.getScriptName(script) + " on " + threadName, e);
            this.setStatusVariable(channel, AJ_AGISTATUS_FAILED);
        }
        catch (Exception e) {
            this.logger.error("Exception running AgiScript " + this.getScriptName(script) + " on " + threadName, e);
            this.setStatusVariable(channel, AJ_AGISTATUS_FAILED);
        }
        this.logger.info("End AgiScript " + this.getScriptName(script) + " on " + threadName);
    }

    protected String getScriptName(AgiScript script) {
        if (script == null) {
            return null;
        }
        if (script instanceof NamedAgiScript) {
            return ((NamedAgiScript)script).getName();
        }
        return script.getClass().getName();
    }

    private void setStatusVariable(AgiChannel channel, String value) {
        if (channel == null) {
            return;
        }
        try {
            channel.setVariable(AJ_AGISTATUS_VARIABLE, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logToAsterisk(AgiChannel channel, String message) {
        if (channel == null) {
            return;
        }
        try {
            channel.sendCommand(new VerboseCommand(message, 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static AgiChannel getChannel() {
        return channel.get();
    }
}

