/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.asteriskjava.manager.event.UserEvent;
import org.asteriskjava.util.AstUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractBuilder {
    protected final Log logger = LogFactory.getLog(this.getClass());

    AbstractBuilder() {
    }

    protected void setAttributes(Object target, Map<String, Object> attributes, Set<String> ignoredAttributes) {
        Map<String, Method> setters = ReflectionUtil.getSetters(target.getClass());
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            Object value;
            Method setter;
            if (ignoredAttributes != null && ignoredAttributes.contains(entry.getKey())) continue;
            String setterName = ReflectionUtil.stripIllegalCharacters(entry.getKey());
            if ("source".equals(setterName)) {
                setterName = "src";
            }
            if ((setter = setters.get(setterName)) == null && !setterName.endsWith("s") && (setter = setters.get(setterName + "s")) != null && !setter.getParameterTypes()[0].isAssignableFrom(Map.class)) {
                setter = null;
            }
            if (setter == null && !(target instanceof UserEvent)) {
                this.logger.warn("Unable to set property '" + entry.getKey() + "' to '" + entry.getValue() + "' on " + target.getClass().getName() + ": no setter. Please report at http://jira.reucon.org/browse/AJ");
            }
            if (setter == null) continue;
            Class<Object> dataType = setter.getParameterTypes()[0];
            if (dataType == Boolean.class) {
                value = AstUtil.isTrue(entry.getValue());
            } else if (dataType.isAssignableFrom(String.class)) {
                value = entry.getValue();
                if (AstUtil.isNull(value)) {
                    value = null;
                }
            } else if (dataType.isAssignableFrom(Map.class)) {
                if (entry.getValue() instanceof List) {
                    List list = (List)entry.getValue();
                    value = this.buildMap(list.toArray(new String[list.size()]));
                } else {
                    value = entry.getValue() instanceof String ? this.buildMap((String)entry.getValue()) : null;
                }
            } else {
                try {
                    Constructor<?> constructor = dataType.getConstructor(String.class);
                    value = constructor.newInstance(entry.getValue());
                }
                catch (Exception e) {
                    this.logger.error("Unable to convert value '" + entry.getValue() + "' of property '" + entry.getKey() + "' on " + target.getClass().getName() + " to required type " + dataType, e);
                    continue;
                }
            }
            try {
                setter.invoke(target, value);
            }
            catch (Exception e) {
                this.logger.error("Unable to set property '" + entry.getKey() + "' to '" + entry.getValue() + "' on " + target.getClass().getName(), e);
            }
        }
    }

    private Map<String, String> buildMap(String ... lines) {
        if (lines == null) {
            return null;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String line : lines) {
            int index = line.indexOf(61);
            if (index > 0) {
                String key = line.substring(0, index);
                String value = line.substring(index + 1, line.length());
                map.put(key, value);
                continue;
            }
            this.logger.warn("Malformed line '" + line + "' for a map property");
        }
        return map;
    }
}

