/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.util;

import io.netty.buffer.ByteBuf;
import java.io.UTFDataFormatException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.asynchttpclient.util.UsAsciiByteBufDecoder;
import org.asynchttpclient.util.Utf8ByteBufDecoder;

public final class ByteBufUtils {
    private ByteBufUtils() {
    }

    public static String byteBuf2Utf8String(ByteBuf buf) throws CharacterCodingException {
        return Utf8ByteBufDecoder.getCachedDecoder().decode(Collections.singleton(buf));
    }

    public static String byteBuf2UsAsciiString(ByteBuf buf) throws CharacterCodingException {
        return UsAsciiByteBufDecoder.getCachedDecoder().decode(Collections.singleton(buf));
    }

    public static String byteBuf2String(ByteBuf buf, Charset charset) throws UTFDataFormatException, IndexOutOfBoundsException, CharacterCodingException {
        if (charset.equals(StandardCharsets.US_ASCII)) {
            return ByteBufUtils.byteBuf2UsAsciiString(buf);
        }
        if (charset.equals(StandardCharsets.UTF_8)) {
            return ByteBufUtils.byteBuf2Utf8String(buf);
        }
        return buf.toString(charset);
    }

    public static byte[] byteBuf2Bytes(ByteBuf buf) {
        byte[] array;
        int readable = buf.readableBytes();
        int readerIndex = buf.readerIndex();
        if (buf.hasArray()) {
            array = buf.array();
            if (buf.arrayOffset() == 0 && readerIndex == 0 && array.length == readable) {
                return array;
            }
        }
        array = new byte[readable];
        buf.getBytes(readerIndex, array);
        return array;
    }
}

