/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.oauth;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import org.asynchttpclient.Param;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilderBase;
import org.asynchttpclient.SignatureCalculator;
import org.asynchttpclient.oauth.ConsumerKey;
import org.asynchttpclient.oauth.RequestToken;
import org.asynchttpclient.oauth.ThreadSafeHMAC;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.Base64;
import org.asynchttpclient.util.MiscUtils;
import org.asynchttpclient.util.StringUtils;
import org.asynchttpclient.util.Utf8UrlEncoder;

public class OAuthSignatureCalculator
implements SignatureCalculator {
    public static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String KEY_OAUTH_CONSUMER_KEY = "oauth_consumer_key";
    private static final String KEY_OAUTH_NONCE = "oauth_nonce";
    private static final String KEY_OAUTH_SIGNATURE = "oauth_signature";
    private static final String KEY_OAUTH_SIGNATURE_METHOD = "oauth_signature_method";
    private static final String KEY_OAUTH_TIMESTAMP = "oauth_timestamp";
    private static final String KEY_OAUTH_TOKEN = "oauth_token";
    private static final String KEY_OAUTH_VERSION = "oauth_version";
    private static final String OAUTH_VERSION_1_0 = "1.0";
    private static final String OAUTH_SIGNATURE_METHOD = "HMAC-SHA1";
    protected static final ThreadLocal<byte[]> NONCE_BUFFER = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[16];
        }
    };
    protected final ThreadSafeHMAC mac;
    protected final ConsumerKey consumerAuth;
    protected final RequestToken userAuth;
    private static final Pattern STAR_CHAR_PATTERN = Pattern.compile("*", 16);
    private static final Pattern PLUS_CHAR_PATTERN = Pattern.compile("+", 16);
    private static final Pattern ENCODED_TILDE_PATTERN = Pattern.compile("%7E", 16);

    public OAuthSignatureCalculator(ConsumerKey consumerAuth, RequestToken userAuth) {
        this.mac = new ThreadSafeHMAC(consumerAuth, userAuth);
        this.consumerAuth = consumerAuth;
        this.userAuth = userAuth;
    }

    @Override
    public void calculateAndAddSignature(Request request, RequestBuilderBase<?> requestBuilder) {
        String nonce = this.generateNonce();
        long timestamp = this.generateTimestamp();
        String signature = this.calculateSignature(request, timestamp, nonce);
        String headerValue = this.constructAuthHeader(signature, nonce, timestamp);
        requestBuilder.setHeader((CharSequence)HEADER_AUTHORIZATION, headerValue);
    }

    private String encodedParams(long oauthTimestamp, String nonce, List<Param> formParams, List<Param> queryParams) {
        int allParametersSize = 5 + (this.userAuth.getKey() != null ? 1 : 0) + (formParams != null ? formParams.size() : 0) + (queryParams != null ? queryParams.size() : 0);
        OAuthParameterSet allParameters = new OAuthParameterSet(allParametersSize);
        allParameters.add(KEY_OAUTH_CONSUMER_KEY, Utf8UrlEncoder.encodeQueryElement(this.consumerAuth.getKey()));
        allParameters.add(KEY_OAUTH_NONCE, Utf8UrlEncoder.encodeQueryElement(nonce));
        allParameters.add(KEY_OAUTH_SIGNATURE_METHOD, OAUTH_SIGNATURE_METHOD);
        allParameters.add(KEY_OAUTH_TIMESTAMP, String.valueOf(oauthTimestamp));
        if (this.userAuth.getKey() != null) {
            allParameters.add(KEY_OAUTH_TOKEN, Utf8UrlEncoder.encodeQueryElement(this.userAuth.getKey()));
        }
        allParameters.add(KEY_OAUTH_VERSION, OAUTH_VERSION_1_0);
        if (formParams != null) {
            for (Param param : formParams) {
                allParameters.add(Utf8UrlEncoder.encodeQueryElement(param.getName()), Utf8UrlEncoder.encodeQueryElement(param.getValue()));
            }
        }
        if (queryParams != null) {
            for (Param param : queryParams) {
                allParameters.add(this.percentEncodeAlreadyFormUrlEncoded(param.getName()), this.percentEncodeAlreadyFormUrlEncoded(param.getValue()));
            }
        }
        return allParameters.sortAndConcat();
    }

    private String baseUrl(Uri uri) {
        String scheme = uri.getScheme();
        StringBuilder sb = StringUtils.stringBuilder();
        sb.append(scheme).append("://").append(uri.getHost());
        int port = uri.getPort();
        if (scheme.equals("http")) {
            if (port == 80) {
                port = -1;
            }
        } else if (scheme.equals("https") && port == 443) {
            port = -1;
        }
        if (port != -1) {
            sb.append(':').append(port);
        }
        if (MiscUtils.isNonEmpty(uri.getPath())) {
            sb.append(uri.getPath());
        }
        return sb.toString();
    }

    private String percentEncodeAlreadyFormUrlEncoded(String s) {
        s = STAR_CHAR_PATTERN.matcher(s).replaceAll("%2A");
        s = PLUS_CHAR_PATTERN.matcher(s).replaceAll("%20");
        s = ENCODED_TILDE_PATTERN.matcher(s).replaceAll("~");
        return s;
    }

    StringBuilder signatureBaseString(Request request, long oauthTimestamp, String nonce) {
        String baseUrl = this.baseUrl(request.getUri());
        String encodedParams = this.encodedParams(oauthTimestamp, nonce, request.getFormParams(), request.getQueryParams());
        StringBuilder sb = StringUtils.stringBuilder();
        sb.append(request.getMethod());
        sb.append('&');
        Utf8UrlEncoder.encodeAndAppendQueryElement(sb, baseUrl);
        sb.append('&');
        Utf8UrlEncoder.encodeAndAppendQueryElement(sb, encodedParams);
        return sb;
    }

    String calculateSignature(Request request, long oauthTimestamp, String nonce) {
        StringBuilder sb = this.signatureBaseString(request, oauthTimestamp, nonce);
        ByteBuffer rawBase = StringUtils.charSequence2ByteBuffer(sb, StandardCharsets.UTF_8);
        byte[] rawSignature = this.mac.digest(rawBase);
        return Base64.encode(rawSignature);
    }

    private String constructAuthHeader(String signature, String nonce, long oauthTimestamp) {
        StringBuilder sb = StringUtils.stringBuilder();
        sb.append("OAuth ");
        sb.append(KEY_OAUTH_CONSUMER_KEY).append("=\"").append(this.consumerAuth.getKey()).append("\", ");
        if (this.userAuth.getKey() != null) {
            sb.append(KEY_OAUTH_TOKEN).append("=\"").append(this.userAuth.getKey()).append("\", ");
        }
        sb.append(KEY_OAUTH_SIGNATURE_METHOD).append("=\"").append(OAUTH_SIGNATURE_METHOD).append("\", ");
        sb.append(KEY_OAUTH_SIGNATURE).append("=\"");
        Utf8UrlEncoder.encodeAndAppendQueryElement(sb, signature).append("\", ");
        sb.append(KEY_OAUTH_TIMESTAMP).append("=\"").append(oauthTimestamp).append("\", ");
        sb.append(KEY_OAUTH_NONCE).append("=\"");
        Utf8UrlEncoder.encodeAndAppendQueryElement(sb, nonce);
        sb.append("\", ");
        sb.append(KEY_OAUTH_VERSION).append("=\"").append(OAUTH_VERSION_1_0).append("\"");
        return sb.toString();
    }

    protected long generateTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    protected String generateNonce() {
        byte[] nonceBuffer = NONCE_BUFFER.get();
        ThreadLocalRandom.current().nextBytes(nonceBuffer);
        return Base64.encode(nonceBuffer);
    }

    static final class Parameter
    implements Comparable<Parameter> {
        private final String key;
        private final String value;

        public Parameter(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        @Override
        public int compareTo(Parameter other) {
            int diff = this.key.compareTo(other.key);
            if (diff == 0) {
                diff = this.value.compareTo(other.value);
            }
            return diff;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            if (!this.key.equals(parameter.key)) {
                return false;
            }
            return this.value.equals(parameter.value);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }
    }

    static final class OAuthParameterSet {
        private final ArrayList<Parameter> allParameters;

        public OAuthParameterSet(int size) {
            this.allParameters = new ArrayList(size);
        }

        public OAuthParameterSet add(String key, String value) {
            this.allParameters.add(new Parameter(key, value));
            return this;
        }

        public String sortAndConcat() {
            Object[] params = this.allParameters.toArray(new Parameter[this.allParameters.size()]);
            Arrays.sort(params);
            StringBuilder encodedParams = new StringBuilder(100);
            for (Object param : params) {
                if (encodedParams.length() > 0) {
                    encodedParams.append('&');
                }
                encodedParams.append(((Parameter)param).key()).append('=').append(((Parameter)param).value());
            }
            return encodedParams.toString();
        }
    }
}

