/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.util.ForkJoinPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorsFactory {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorsFactory.class);
    public static final int DEFAULT_ASYNC_THREAD = 200;
    public static final int DEFAULT_MESSAGE_THREAD = -1;
    public static final int DEFAULT_KEEP_ALIVE = 30;
    public static final String ASYNC_WRITE_THREAD_POOL = "asyncWriteService";
    public static final String SCHEDULER_THREAD_POOL = "scheduler";
    public static final String BROADCASTER_THREAD_POOL = "executorService";

    public static ExecutorService getMessageDispatcher(AtmosphereConfig config, String name) {
        boolean shared = config.framework().isShareExecutorServices();
        boolean useForkJoinPool = config.getInitParameter("org.atmosphere.useForkJoinPool", true);
        if (!shared || config.properties().get(BROADCASTER_THREAD_POOL) == null) {
            int numberOfMessageProcessingThread = -1;
            String s = config.getInitParameter("org.atmosphere.cpr.broadcaster.maxProcessingThreads");
            if (s != null) {
                numberOfMessageProcessingThread = Integer.parseInt(s);
            }
            if (shared && numberOfMessageProcessingThread == 1) {
                logger.warn("Not enough numberOfMessageProcessingThread for a shareable thread pool {}, Setting it to a newCachedThreadPool", (Object)numberOfMessageProcessingThread);
                numberOfMessageProcessingThread = -1;
            }
            logger.trace("Max number of DispatchOp {}", numberOfMessageProcessingThread == -1 ? "Unlimited" : Integer.valueOf(numberOfMessageProcessingThread));
            String threadName = name + "-DispatchOp-";
            AbstractExecutorService messageService = numberOfMessageProcessingThread == -1 ? (!useForkJoinPool ? (ThreadPoolExecutor)Executors.newCachedThreadPool(new AtmosphereThreadFactory(shared, threadName)) : new ForkJoinPool(shared, threadName)) : (ThreadPoolExecutor)Executors.newFixedThreadPool(numberOfMessageProcessingThread, new AtmosphereThreadFactory(shared, threadName));
            ExecutorsFactory.keepAliveThreads(messageService, config);
            if (shared) {
                config.properties().put(BROADCASTER_THREAD_POOL, messageService);
            }
            return messageService;
        }
        return (ExecutorService)config.properties().get(BROADCASTER_THREAD_POOL);
    }

    private static void keepAliveThreads(AbstractExecutorService t, AtmosphereConfig config) {
        if (!ThreadPoolExecutor.class.isAssignableFrom(t.getClass())) {
            return;
        }
        ThreadPoolExecutor e = (ThreadPoolExecutor)t;
        int keepAlive = 30;
        String s = config.getInitParameter("org.atmosphere.cpr.threadPool.maxKeepAliveThreads");
        if (s != null) {
            keepAlive = Integer.parseInt(s);
        }
        e.setKeepAliveTime(keepAlive, TimeUnit.SECONDS);
        e.allowCoreThreadTimeOut(config.getInitParameter("org.atmosphere.cpr.allowCoreThreadTimeOut", true));
    }

    public static ExecutorService getAsyncOperationExecutor(AtmosphereConfig config, String name) {
        boolean shared = config.framework().isShareExecutorServices();
        if (!shared || config.properties().get(ASYNC_WRITE_THREAD_POOL) == null) {
            int numberOfAsyncThread = 200;
            String s = config.getInitParameter("org.atmosphere.cpr.broadcaster.maxAsyncWriteThreads");
            if (s != null) {
                numberOfAsyncThread = Integer.parseInt(s);
            }
            if (shared && numberOfAsyncThread == 1) {
                logger.warn("Not enough numberOfAsyncThread for a shareable thread pool {}, Setting it to a newCachedThreadPool", (Object)numberOfAsyncThread);
                numberOfAsyncThread = -1;
            }
            boolean useForkJoinPool = config.getInitParameter("org.atmosphere.useForkJoinPool", true);
            logger.trace("Max number of AsyncOp {}", numberOfAsyncThread == -1 ? "Unlimited" : Integer.valueOf(numberOfAsyncThread));
            String threadName = name + "-AsyncOp-";
            AbstractExecutorService asyncWriteService = numberOfAsyncThread == -1 ? (!useForkJoinPool ? (ThreadPoolExecutor)Executors.newCachedThreadPool(new AtmosphereThreadFactory(shared, threadName)) : new ForkJoinPool(shared, threadName)) : (ThreadPoolExecutor)Executors.newFixedThreadPool(numberOfAsyncThread, new AtmosphereThreadFactory(shared, threadName));
            ExecutorsFactory.keepAliveThreads(asyncWriteService, config);
            if (shared) {
                config.properties().put(ASYNC_WRITE_THREAD_POOL, asyncWriteService);
            }
            return asyncWriteService;
        }
        return (ExecutorService)config.properties().get(ASYNC_WRITE_THREAD_POOL);
    }

    public static ScheduledExecutorService getScheduler(AtmosphereConfig config) {
        boolean shared = config.framework().isShareExecutorServices();
        if (!shared || config.properties().get(SCHEDULER_THREAD_POOL) == null) {
            int threads = config.getInitParameter("org.atmosphere.cpr.maxSchedulerThread", Runtime.getRuntime().availableProcessors());
            logger.trace("Max number of Atmosphere-Scheduler {}", (Object)threads);
            ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(threads, new ThreadFactory(){
                private final AtomicInteger count = new AtomicInteger();

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread t = new Thread(runnable, "Atmosphere-Scheduler-" + this.count.getAndIncrement());
                    t.setDaemon(true);
                    return t;
                }
            });
            if (shared) {
                config.properties().put(SCHEDULER_THREAD_POOL, scheduler);
            }
            ExecutorsFactory.keepAliveThreads((ThreadPoolExecutor)((Object)scheduler), config);
            return scheduler;
        }
        return (ScheduledExecutorService)config.properties().get(SCHEDULER_THREAD_POOL);
    }

    public static void reset(AtmosphereConfig config) {
        ExecutorService e = (ExecutorService)config.properties().get(ASYNC_WRITE_THREAD_POOL);
        if (e != null) {
            e.shutdown();
        }
        config.properties().remove(ASYNC_WRITE_THREAD_POOL);
        e = (ExecutorService)config.properties().get(SCHEDULER_THREAD_POOL);
        if (e != null) {
            e.shutdown();
        }
        config.properties().remove(SCHEDULER_THREAD_POOL);
        e = (ExecutorService)config.properties().get(BROADCASTER_THREAD_POOL);
        if (e != null) {
            e.shutdown();
        }
        config.properties().remove(BROADCASTER_THREAD_POOL);
    }

    public static final class AtmosphereThreadFactory
    implements ThreadFactory {
        private final AtomicInteger count = new AtomicInteger();
        private final boolean shared;
        private final String name;

        public AtmosphereThreadFactory(boolean shared, String name) {
            this.shared = shared;
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable, (this.shared ? "Atmosphere-Shared-" : this.name) + this.count.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }
}

