/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.util.Optional;
import javax.annotation.Nonnull;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.DomainEventSequenceAware;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.messaging.StreamableMessageSource;

public interface EventStore
extends EventBus,
StreamableMessageSource<TrackedEventMessage<?>>,
DomainEventSequenceAware {
    public DomainEventStream readEvents(@Nonnull String var1);

    default public DomainEventStream readEvents(@Nonnull String aggregateIdentifier, long firstSequenceNumber) {
        DomainEventStream wholeStream = this.readEvents(aggregateIdentifier);
        return DomainEventStream.of(wholeStream.asStream().filter(event -> event.getSequenceNumber() >= firstSequenceNumber), wholeStream::getLastSequenceNumber);
    }

    public void storeSnapshot(@Nonnull DomainEventMessage<?> var1);

    default public Optional<Long> lastSequenceNumberFor(String aggregateIdentifier) {
        return this.readEvents(aggregateIdentifier).asStream().map(DomainEventMessage::getSequenceNumber).max(Long::compareTo);
    }
}

