/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command;

import java.util.concurrent.Callable;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.Scope;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.modelling.command.Aggregate;
import org.axonframework.modelling.command.AggregateInvocationException;
import org.axonframework.modelling.command.AggregateScopeDescriptor;
import org.axonframework.modelling.command.ApplyMore;

public abstract class AggregateLifecycle
extends Scope {
    public static ApplyMore apply(Object payload, MetaData metaData) {
        return AggregateLifecycle.getInstance().doApply(payload, metaData);
    }

    public static ApplyMore apply(Object payload) {
        return AggregateLifecycle.getInstance().doApply(payload, MetaData.emptyInstance());
    }

    public static <T> Aggregate<T> createNew(Class<T> aggregateType, Callable<T> factoryMethod) throws Exception {
        if (!AggregateLifecycle.isLive()) {
            throw new UnsupportedOperationException("Aggregate is still initializing its state, creation of new aggregates is not possible");
        }
        return AggregateLifecycle.getInstance().doCreateNew(aggregateType, factoryMethod);
    }

    public static boolean isLive() {
        return AggregateLifecycle.getInstance().getIsLive();
    }

    public static Long getVersion() {
        return AggregateLifecycle.getInstance().version();
    }

    public static void markDeleted() {
        AggregateLifecycle.getInstance().doMarkDeleted();
    }

    protected static AggregateLifecycle getInstance() {
        return (AggregateLifecycle)Scope.getCurrentScope();
    }

    protected abstract boolean getIsLive();

    protected abstract Long version();

    protected abstract void doMarkDeleted();

    protected abstract <T> ApplyMore doApply(T var1, MetaData var2);

    protected abstract <T> Aggregate<T> doCreateNew(Class<T> var1, Callable<T> var2) throws Exception;

    protected void execute(Runnable task) {
        try {
            this.executeWithResult(() -> {
                task.run();
                return null;
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AggregateInvocationException("Exception while invoking a task for an aggregate", e);
        }
    }

    public ScopeDescriptor describeScope() {
        return new AggregateScopeDescriptor(this.type(), this::identifier);
    }

    protected abstract String type();

    protected abstract Object identifier();
}

