/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.config;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.config.utils.ConfigFileParserException;
import org.ballerinalang.config.utils.parser.ConfigFileParser;
import org.ballerinalang.config.utils.parser.ConfigParamParser;

public class ConfigProcessor {
    private static final String BALLERINA_CONF = "ballerina.conf";
    private static final String USER_DIR = "user.dir";
    private static final String BALLERINA_CONF_DEFAULT_PATH = System.getProperty("user.dir") + File.separator + "ballerina.conf";
    private Map<String, String> runtimeParams = new HashMap<String, String>();
    private Map<String, String> resolvedGlobalConfigs = new HashMap<String, String>();
    private Map<String, Map<String, String>> resolvedInstanceConfigs = new HashMap<String, Map<String, String>>();
    private ConfigRegistry configRegistry;

    public ConfigProcessor(ConfigRegistry configRegistry) {
        this.configRegistry = configRegistry;
    }

    public void setRuntimeConfiguration(Map<String, String> params) {
        this.runtimeParams = params;
    }

    public void processConfiguration() throws ConfigFileParserException {
        ConfigParamParser paramParser = new ConfigParamParser(this.runtimeParams);
        Map<String, String> runtimeGlobalConfigs = paramParser.getGlobalConfigs();
        Map<String, Map<String, String>> runtimeInstanceConfigs = paramParser.getInstanceConfigs();
        File confFile = this.getConfigFile(this.runtimeParams.get(BALLERINA_CONF));
        if (confFile != null) {
            ConfigFileParser parser = new ConfigFileParser(confFile);
            Map<String, String> fileGlobalConfigs = parser.getGlobalConfigs();
            Map<String, Map<String, String>> fileInstanceConfigs = parser.getInstanceConfigs();
            this.lookUpVariables(fileGlobalConfigs, fileInstanceConfigs);
            this.resolvedGlobalConfigs.putAll(fileGlobalConfigs);
            this.resolvedInstanceConfigs.forEach((key, val) -> {
                Map map2 = (Map)fileInstanceConfigs.get(key);
                if (map2 != null) {
                    val.putAll(map2);
                }
            });
            fileInstanceConfigs.forEach((key, val) -> this.resolvedInstanceConfigs.putIfAbsent((String)key, (Map<String, String>)val));
        }
        this.resolvedGlobalConfigs.putAll(runtimeGlobalConfigs);
        this.resolvedInstanceConfigs.forEach((key, val) -> {
            if (runtimeInstanceConfigs.containsKey(key)) {
                val.putAll((Map)runtimeInstanceConfigs.get(key));
            }
        });
        runtimeInstanceConfigs.forEach((key, val) -> this.resolvedInstanceConfigs.putIfAbsent((String)key, (Map<String, String>)val));
        this.configRegistry.setGlobalConfigs(this.resolvedGlobalConfigs);
        this.configRegistry.setInstanceConfigs(this.resolvedInstanceConfigs);
    }

    private void lookUpVariables(Map<String, String> globalConfigs, Map<String, Map<String, String>> instanceConfigs) {
        globalConfigs.keySet().forEach(key -> {
            String value = System.getenv(this.convertToEnvVarFormat((String)key));
            String string = value = value == null ? System.getProperty(key) : value;
            if (value != null) {
                this.resolvedGlobalConfigs.put((String)key, value);
                globalConfigs.remove(key);
            }
        });
        instanceConfigs.keySet().forEach(instanceId -> {
            Map configInstance = (Map)instanceConfigs.get(instanceId);
            configInstance.keySet().forEach(key -> {
                String value = System.getenv(this.convertToEnvVarFormat((String)key, (String)instanceId));
                String string2 = value = value == null ? System.getProperty(key) : value;
                if (value != null) {
                    if (this.resolvedInstanceConfigs.containsKey(instanceId)) {
                        this.resolvedInstanceConfigs.get(instanceId).put((String)key, value);
                    } else {
                        HashMap<String, String> map2 = new HashMap<String, String>();
                        map2.put((String)key, value);
                        this.resolvedInstanceConfigs.put((String)instanceId, (Map<String, String>)map2);
                    }
                    configInstance.remove(key);
                }
            });
        });
    }

    private String convertToEnvVarFormat(String var) {
        return var.toUpperCase(Locale.ROOT).replace('.', '_');
    }

    private String convertToEnvVarFormat(String var, String instanceId) {
        return instanceId.toUpperCase(Locale.ROOT) + "__" + this.convertToEnvVarFormat(var);
    }

    private File getConfigFile(String fileLocation) {
        File confFile;
        if (fileLocation != null) {
            confFile = new File(fileLocation);
            if (!confFile.exists()) {
                throw new RuntimeException("failed to start ballerina runtime: file not found: " + fileLocation);
            }
        } else {
            confFile = new File(BALLERINA_CONF_DEFAULT_PATH);
            if (!confFile.exists()) {
                return null;
            }
        }
        return confFile;
    }
}

