/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.config.utils.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractConfigParser {
    protected static final String CONFIG_KEY_FORMAT = "([a-zA-Z0-9._]+\\s*)";
    protected static final String INSTANCE_ID_FORMAT = "\\[[a-zA-Z0-9._]+\\]";
    protected static final String COMMENT_OR_WS_FORMAT = "[\\s]*#[\\ -~]*|[\\s]*";
    protected static final String VARIABLE_FORMAT = "\\$\\{(env|sys):([a-zA-Z_]+[a-zA-Z0-9_\\.]*)\\}";
    protected static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{(env|sys):([a-zA-Z_]+[a-zA-Z0-9_\\.]*)\\}");
    private static final String ENVIRONMENT_VARIABLE = "env";
    private static final String SYSTEM_PROPERTY = "sys";
    protected Map<String, String> globalConfigs = new HashMap<String, String>();
    protected Map<String, Map<String, String>> instanceConfigs = new HashMap<String, Map<String, String>>();

    public Map<String, String> getGlobalConfigs() {
        return this.globalConfigs;
    }

    public Map<String, Map<String, String>> getInstanceConfigs() {
        return this.instanceConfigs;
    }

    protected String parseConfigValue(String value) {
        Matcher matcher = VARIABLE_PATTERN.matcher(value);
        if (!matcher.find()) {
            return value;
        }
        StringBuilder varReplacedValue = new StringBuilder();
        int i = 0;
        do {
            if (matcher.start() != i) {
                varReplacedValue.append(value.substring(i, matcher.start()));
            }
            String varType = matcher.group(1);
            String key = matcher.group(2);
            switch (varType) {
                case "env": {
                    varReplacedValue.append(System.getenv(key));
                    break;
                }
                case "sys": {
                    varReplacedValue.append(System.getProperty(key));
                    break;
                }
                default: {
                    throw new RuntimeException("invalid config variable type: " + varType);
                }
            }
            i = matcher.end();
        } while (matcher.find());
        return varReplacedValue.toString();
    }

    protected String extractInstanceId(String id) {
        return id.substring(1, id.length() - 1);
    }
}

