/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.config.utils.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.config.utils.ConfigFileParserException;
import org.ballerinalang.config.utils.parser.AbstractConfigParser;

public class ConfigFileParser
extends AbstractConfigParser {
    private static final String CONFIG_ENTRY_FORMAT = "([a-zA-Z0-9._]+\\s*)=(.*)";
    private static final PrintStream console = System.err;
    private List<Integer> invalidConfigs;
    private int currentLine;

    public ConfigFileParser(File configFile) throws ConfigFileParserException {
        this.parse(configFile);
    }

    private void parse(File file) throws ConfigFileParserException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
            String line;
            this.invalidConfigs = new ArrayList<Integer>();
            this.currentLine = 1;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).matches(CONFIG_ENTRY_FORMAT)) {
                    this.parseGlobalConfigEntry(line);
                } else {
                    if (line.matches("\\[[a-zA-Z0-9._]+\\]")) {
                        ++this.currentLine;
                        break;
                    }
                    if (!line.matches("[\\s]*#[\\ -~]*|[\\s]*")) {
                        this.collectConfigError(this.currentLine);
                    }
                }
                ++this.currentLine;
            }
            if (line == null) {
                return;
            }
            String currentInstance = this.extractInstanceId(line);
            this.instanceConfigs.put(currentInstance, new HashMap());
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).matches(CONFIG_ENTRY_FORMAT)) {
                    this.parseInstanceConfigEntry(currentInstance, line);
                } else if (line.matches("\\[[a-zA-Z0-9._]+\\]")) {
                    currentInstance = this.extractInstanceId(line);
                } else if (!line.matches("[\\s]*#[\\ -~]*|[\\s]*")) {
                    this.collectConfigError(this.currentLine);
                }
                ++this.currentLine;
            }
            if (this.invalidConfigs.size() > 0) {
                throw new RuntimeException("invalid configuration(s) in the file at line(s): " + this.invalidConfigs.toString() + ", config entries should conform to " + CONFIG_ENTRY_FORMAT);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ConfigFileParserException("unsupported encoding detected", e);
        }
        catch (FileNotFoundException e) {
            throw new ConfigFileParserException("file not found: " + file.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw new ConfigFileParserException("failed to read the configuration file" + file.getAbsolutePath(), e);
        }
    }

    private void parseGlobalConfigEntry(String configEntry) {
        String[] entryParts = this.getConfigKeyAndValue(configEntry);
        this.globalConfigs.put(entryParts[0], this.parseConfigValue(entryParts[1]));
    }

    private void parseInstanceConfigEntry(String instanceId, String configEntry) {
        String[] entryParts = this.getConfigKeyAndValue(configEntry);
        if (this.instanceConfigs.containsKey(instanceId)) {
            ((Map)this.instanceConfigs.get(instanceId)).put(entryParts[0], this.parseConfigValue(entryParts[1]));
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(entryParts[0], this.parseConfigValue(entryParts[1]));
            this.instanceConfigs.put(instanceId, map);
        }
    }

    private String[] getConfigKeyAndValue(String configEntry) {
        String[] entryParts = configEntry.split("=");
        this.trimConfigEntry(entryParts);
        return entryParts;
    }

    private void collectConfigError(int invalidLine) {
        this.invalidConfigs.add(invalidLine);
    }

    private void trimConfigEntry(String[] entryParts) {
        entryParts[0] = entryParts[0].trim();
        entryParts[1] = entryParts[1].trim();
    }
}

