/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.config.utils.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ballerinalang.config.utils.parser.AbstractConfigParser;

public class ConfigParamParser
extends AbstractConfigParser {
    private static final String INSTANCE_CONFIG_KEY_FORMAT = "(\\[[a-zA-Z0-9._]+\\])\\.([a-zA-Z0-9._]+)";
    private static final Pattern INSTANCE_CONFIG_KEY_PATTERN = Pattern.compile("(\\[[a-zA-Z0-9._]+\\])\\.([a-zA-Z0-9._]+)");

    public ConfigParamParser(Map<String, String> cliParams) {
        this.parse(cliParams);
    }

    private void parse(Map<String, String> cliParams) {
        cliParams.forEach((key, val) -> {
            if (key.matches("([a-zA-Z0-9._]+\\s*)")) {
                this.globalConfigs.put(key, this.parseConfigValue((String)val));
            } else if (key.matches(INSTANCE_CONFIG_KEY_FORMAT)) {
                Matcher matcher = INSTANCE_CONFIG_KEY_PATTERN.matcher((CharSequence)key);
                matcher.find();
                String instanceId = this.extractInstanceId(matcher.group(1));
                String configKey = matcher.group(2);
                if (this.instanceConfigs.containsKey(instanceId)) {
                    ((Map)this.instanceConfigs.get(instanceId)).put(configKey, this.parseConfigValue((String)val));
                } else {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(configKey, this.parseConfigValue((String)val));
                    this.instanceConfigs.put(instanceId, map);
                }
            } else {
                throw new RuntimeException("invalid configuration parameter key: " + key + ", key should conform to " + "([a-zA-Z0-9._]+\\s*)" + " or " + INSTANCE_CONFIG_KEY_FORMAT);
            }
        });
    }
}

