/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.config.cipher;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.ballerinalang.config.cipher.AESCipherToolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESCipherTool {
    private static final Logger log = LoggerFactory.getLogger(AESCipherTool.class);
    private static final String ALGORITHM_AES_CBC_PKCS5 = "AES/CBC/PKCS5Padding";
    private static final String ALGORITHM_AES = "AES";
    private static final String ALGORITHM_SHA_256 = "SHA-256";
    private static final int IV_SIZE = 16;
    private static final int SECRET_KEY_LENGTH = 16;
    private final SecretKey secretKey;
    private final SecureRandom secureRandom;

    public AESCipherTool(String userSecret) throws AESCipherToolException {
        this.secretKey = new SecretKeySpec(this.getSHA256Key(userSecret, 16), ALGORITHM_AES);
        this.secureRandom = new SecureRandom();
    }

    public AESCipherTool(Path userSecretFile) throws IOException, AESCipherToolException {
        List<String> userSecret = Files.readAllLines(userSecretFile, StandardCharsets.UTF_8);
        Files.deleteIfExists(userSecretFile);
        if (userSecret.size() > 1) {
            throw new AESCipherToolException("Multi-line user secrets not allowed");
        }
        this.secretKey = new SecretKeySpec(this.getSHA256Key(userSecret.get(0), 16), ALGORITHM_AES);
        this.secureRandom = new SecureRandom();
    }

    public String encrypt(String value) throws AESCipherToolException {
        try {
            byte[] ivByteArray = this.getSecureRandomBytes();
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ivByteArray);
            Cipher encryptionCipher = Cipher.getInstance(ALGORITHM_AES_CBC_PKCS5);
            encryptionCipher.init(1, (Key)this.secretKey, ivParameterSpec);
            byte[] encryptedBytes = encryptionCipher.doFinal(this.getBytes(value));
            return this.encodeBase64(this.appendByteArrays(ivByteArray, encryptedBytes));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException err) {
            log.error("Failed to encrypt value: " + value, (Throwable)err);
            throw new AESCipherToolException(err.getMessage(), err);
        }
    }

    public String decrypt(String value) throws AESCipherToolException {
        try {
            byte[] decodedByteArray = this.decodeBase64(value);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(Arrays.copyOfRange(decodedByteArray, 0, 16));
            Cipher decryptionCipher = Cipher.getInstance(ALGORITHM_AES_CBC_PKCS5);
            decryptionCipher.init(2, (Key)this.secretKey, ivParameterSpec);
            byte[] encryptedByteArray = Arrays.copyOfRange(decodedByteArray, 16, decodedByteArray.length);
            return new String(decryptionCipher.doFinal(encryptedByteArray), StandardCharsets.UTF_8);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException err) {
            log.error("Failed to decrypt value: " + value, (Throwable)err);
            throw new AESCipherToolException(err.getMessage(), err);
        }
    }

    private byte[] appendByteArrays(byte[] ivArray, byte[] encryptedArray) {
        int arrayLength = ivArray.length + encryptedArray.length;
        byte[] bytes = new byte[arrayLength];
        System.arraycopy(ivArray, 0, bytes, 0, ivArray.length);
        System.arraycopy(encryptedArray, 0, bytes, ivArray.length, encryptedArray.length);
        return bytes;
    }

    private byte[] getSecureRandomBytes() {
        byte[] bytes = new byte[16];
        this.secureRandom.nextBytes(bytes);
        return bytes;
    }

    private byte[] getSHA256Key(String key, int keyLengthInBytes) throws AESCipherToolException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(ALGORITHM_SHA_256);
            messageDigest.update(this.getBytes(key));
            byte[] keyBytes = new byte[keyLengthInBytes];
            System.arraycopy(messageDigest.digest(), 0, keyBytes, 0, keyBytes.length);
            return keyBytes;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Failed to generate SHA256 digest for: " + key, (Throwable)e);
            throw new AESCipherToolException(e.getMessage(), e);
        }
    }

    private String encodeBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    private byte[] decodeBase64(String encodedValue) {
        return Base64.getDecoder().decode(this.getBytes(encodedValue));
    }

    private byte[] getBytes(String value) {
        return value.getBytes(StandardCharsets.UTF_8);
    }
}

