/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.InputStream;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ballerinalang.net.grpc.ClientConnectorListener;
import org.ballerinalang.net.grpc.Codec;
import org.ballerinalang.net.grpc.Compressor;
import org.ballerinalang.net.grpc.CompressorRegistry;
import org.ballerinalang.net.grpc.DecompressorRegistry;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.MethodDescriptor;
import org.ballerinalang.net.grpc.OutboundMessage;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.StreamListener;
import org.ballerinalang.net.grpc.exception.StatusRuntimeException;
import org.ballerinalang.net.grpc.stubs.AbstractStub;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;

public final class ClientCall {
    private static final Logger log = Logger.getLogger(ClientCall.class.getName());
    private final MethodDescriptor method;
    private final boolean unaryRequest;
    private HttpClientConnector connector;
    private final OutboundMessage outboundMessage;
    private ClientConnectorListener connectorListener;
    private boolean cancelCalled;
    private boolean halfCloseCalled;
    private DecompressorRegistry decompressorRegistry = DecompressorRegistry.getDefaultInstance();
    private CompressorRegistry compressorRegistry = CompressorRegistry.getDefaultInstance();

    public ClientCall(HttpClientConnector connector, OutboundMessage outboundMessage, MethodDescriptor method) {
        this.method = method;
        this.unaryRequest = method.getType() == MethodDescriptor.MethodType.UNARY || method.getType() == MethodDescriptor.MethodType.SERVER_STREAMING;
        this.connector = connector;
        this.outboundMessage = outboundMessage;
    }

    private void prepareHeaders(Compressor compressor) {
        this.outboundMessage.removeHeader("grpc-encoding");
        if (compressor != Codec.Identity.NONE) {
            this.outboundMessage.setHeader("grpc-encoding", compressor.getMessageEncoding());
        }
        String advertisedEncodings = String.join((CharSequence)",", this.decompressorRegistry.getAdvertisedMessageEncodings());
        this.outboundMessage.setHeader("grpc-accept-encoding", advertisedEncodings);
        this.outboundMessage.setProperty("TO", "/" + this.method.getFullMethodName());
        this.outboundMessage.setHttpMethod("POST");
        this.outboundMessage.setHttpVersion("2.0");
        this.outboundMessage.setHeader("content-type", "application/grpc");
        this.outboundMessage.setHeader("te", "trailers");
    }

    public void start(AbstractStub.Listener observer) {
        Compressor compressor;
        if (this.connectorListener != null) {
            throw new IllegalStateException("Client connection us already setup.");
        }
        if (this.cancelCalled) {
            throw new IllegalStateException("Client call was cancelled.");
        }
        String compressorName = this.outboundMessage.getHeader("grpc-encoding");
        if (compressorName != null) {
            compressor = this.compressorRegistry.lookupCompressor(compressorName);
            if (compressor == null) {
                this.closeObserver(observer, Status.Code.INTERNAL.toStatus().withDescription(String.format("Unable to find compressor by name %s", compressorName)), (HttpHeaders)new DefaultHttpHeaders());
                return;
            }
        } else {
            compressor = Codec.Identity.NONE;
        }
        this.prepareHeaders(compressor);
        ClientStreamListener clientStreamListener = new ClientStreamListener(observer);
        this.connectorListener = new ClientConnectorListener(clientStreamListener);
        this.outboundMessage.framer().setCompressor(compressor);
        this.connectorListener.setDecompressorRegistry(this.decompressorRegistry);
        HttpResponseFuture responseFuture = this.connector.send(this.outboundMessage.getResponseMessage());
        responseFuture.setHttpConnectorListener((HttpConnectorListener)this.connectorListener);
    }

    public void cancel(String message, Throwable cause) {
        if (message == null && cause == null) {
            cause = new CancellationException("Cancelled without a message or cause");
            log.log(Level.WARNING, "Cancelling without a message or cause is suboptimal", cause);
        }
        if (this.cancelCalled) {
            return;
        }
        this.cancelCalled = true;
        if (this.outboundMessage != null) {
            Status status = Status.Code.CANCELLED.toStatus();
            status = message != null ? status.withDescription(message) : status.withDescription("Call cancelled without message");
            if (cause != null) {
                status = status.withCause(cause);
            }
            this.outboundMessage.complete(status, (HttpHeaders)new DefaultHttpHeaders());
        }
    }

    public void halfClose() {
        if (this.outboundMessage == null) {
            throw new IllegalStateException("Client call did not start properly.");
        }
        if (this.cancelCalled) {
            throw new IllegalStateException("Client call was called.");
        }
        if (this.halfCloseCalled) {
            throw new IllegalStateException("Client call was already closed.");
        }
        this.halfCloseCalled = true;
        this.outboundMessage.halfClose();
    }

    public void sendMessage(Message message) {
        if (this.connectorListener == null) {
            throw new IllegalStateException("Connector listener didn't initialize properly.");
        }
        if (this.cancelCalled) {
            throw new IllegalStateException("Client call was already called.");
        }
        if (this.halfCloseCalled) {
            throw new IllegalStateException("Client call was already closed.");
        }
        try {
            InputStream resp = this.method.streamRequest(message);
            this.outboundMessage.sendMessage(resp);
        }
        catch (StatusRuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw Status.Code.CANCELLED.toStatus().withCause(ex).withDescription("Failed to stream message").asRuntimeException();
        }
        if (!this.unaryRequest) {
            this.outboundMessage.flush();
        }
    }

    public void setMessageCompression(boolean enabled) {
        if (this.outboundMessage == null) {
            throw new IllegalStateException("Client call did not start properly.");
        }
        this.outboundMessage.setMessageCompression(enabled);
    }

    private void closeObserver(AbstractStub.Listener observer, Status status, HttpHeaders trailers) {
        observer.onClose(status, trailers);
    }

    public boolean isReady() {
        return this.outboundMessage.isReady();
    }

    public class ClientStreamListener
    implements StreamListener {
        private final AbstractStub.Listener observer;
        private boolean closed;
        private HttpHeaders responseHeaders;

        ClientStreamListener(AbstractStub.Listener observer) {
            this.observer = observer;
        }

        public void headersRead(HttpHeaders headers) {
            try {
                if (this.closed) {
                    return;
                }
                this.responseHeaders = headers;
                this.observer.onHeaders(headers);
            }
            catch (Exception ex) {
                Status status = Status.Code.CANCELLED.toStatus().withCause(ex).withDescription("Failed to read headers");
                this.close(status, (HttpHeaders)new DefaultHttpHeaders());
            }
        }

        @Override
        public void messagesAvailable(InputStream message) {
            if (this.closed) {
                MessageUtils.closeQuietly(message);
                return;
            }
            try {
                Message responseMessage = ClientCall.this.method.parseResponse(message);
                responseMessage.setHeaders(this.responseHeaders);
                this.observer.onMessage(responseMessage);
                message.close();
            }
            catch (Exception ex) {
                MessageUtils.closeQuietly(message);
                Status status = Status.Code.CANCELLED.toStatus().withCause(ex).withDescription("Failed to read message.");
                this.close(status, (HttpHeaders)new DefaultHttpHeaders());
            }
        }

        private void close(Status status, HttpHeaders trailers) {
            this.closed = true;
            ClientCall.this.closeObserver(this.observer, status, trailers);
        }

        public void closed(Status status, HttpHeaders trailers) {
            if (this.closed) {
                return;
            }
            this.close(status, trailers);
        }
    }
}

