/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ballerinalang.net.grpc.Codec;
import org.ballerinalang.net.grpc.Compressor;
import org.ballerinalang.net.grpc.CompressorRegistry;
import org.ballerinalang.net.grpc.DecompressorRegistry;
import org.ballerinalang.net.grpc.InboundMessage;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.MethodDescriptor;
import org.ballerinalang.net.grpc.OutboundMessage;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.StreamListener;
import org.ballerinalang.net.grpc.exception.ServerRuntimeException;
import org.ballerinalang.net.grpc.listener.ServerCallHandler;
import org.wso2.transport.http.netty.contract.exceptions.ServerConnectorException;

public final class ServerCall {
    private static final String MESSAGE_ACCEPT_ENCODING = "grpc-accept-encoding";
    private static final String TOO_MANY_RESPONSES = "Too many responses";
    private static final String MISSING_RESPONSE = "Completed without a response";
    private final InboundMessage inboundMessage;
    private final OutboundMessage outboundMessage;
    private final MethodDescriptor method;
    private volatile boolean cancelled;
    private boolean sendHeadersCalled;
    private boolean closeCalled;
    private boolean messageSent;
    private Compressor compressor;
    private final String messageAcceptEncoding;
    private DecompressorRegistry decompressorRegistry;
    private CompressorRegistry compressorRegistry;

    ServerCall(InboundMessage inboundMessage, OutboundMessage outboundMessage, MethodDescriptor method, DecompressorRegistry decompressorRegistry, CompressorRegistry compressorRegistry) {
        this.inboundMessage = inboundMessage;
        this.outboundMessage = outboundMessage;
        this.method = method;
        this.decompressorRegistry = decompressorRegistry;
        this.compressorRegistry = compressorRegistry;
        this.messageAcceptEncoding = inboundMessage.getHeader(MESSAGE_ACCEPT_ENCODING);
    }

    public void sendHeaders(HttpHeaders headers) {
        if (this.sendHeadersCalled) {
            throw new IllegalStateException("sendHeaders has already been called");
        }
        if (this.closeCalled) {
            throw new IllegalStateException("call is closed");
        }
        this.outboundMessage.removeHeader("grpc-encoding");
        if (this.compressor == null) {
            this.compressor = Codec.Identity.NONE;
        } else if (this.messageAcceptEncoding != null) {
            List acceptEncodings = Arrays.stream(this.messageAcceptEncoding.split("\\s*,\\s*")).map(mediaType -> mediaType.split("\\s*;\\s*")[0]).collect(Collectors.toList());
            if (!acceptEncodings.contains(this.compressor.getMessageEncoding())) {
                this.compressor = Codec.Identity.NONE;
            }
        } else {
            this.compressor = Codec.Identity.NONE;
        }
        this.outboundMessage.setHeader("grpc-encoding", this.compressor.getMessageEncoding());
        this.outboundMessage.framer().setCompressor(this.compressor);
        this.outboundMessage.removeHeader(MESSAGE_ACCEPT_ENCODING);
        String advertisedEncodings = String.join((CharSequence)",", this.decompressorRegistry.getAdvertisedMessageEncodings());
        if (advertisedEncodings != null) {
            this.outboundMessage.setHeader(MESSAGE_ACCEPT_ENCODING, advertisedEncodings);
        }
        if (headers != null) {
            for (Map.Entry headerEntry : headers.entries()) {
                this.outboundMessage.setHeader((String)headerEntry.getKey(), (String)headerEntry.getValue());
            }
        }
        try {
            this.inboundMessage.respond(this.outboundMessage.getResponseMessage());
        }
        catch (ServerConnectorException e) {
            throw new ServerRuntimeException("Error while sending the response.", e);
        }
        this.sendHeadersCalled = true;
    }

    public void sendMessage(Message message) {
        if (!this.sendHeadersCalled) {
            throw new IllegalStateException("sendHeaders has not been called");
        }
        if (this.closeCalled) {
            throw new IllegalStateException("call is closed");
        }
        if (this.method.getType().serverSendsOneMessage() && this.messageSent) {
            this.outboundMessage.complete(Status.Code.INTERNAL.toStatus().withDescription(TOO_MANY_RESPONSES), (HttpHeaders)new DefaultHttpHeaders());
            return;
        }
        this.messageSent = true;
        try {
            InputStream resp = this.method.streamResponse(message);
            this.outboundMessage.sendMessage(resp);
        }
        catch (Exception e) {
            this.close(Status.fromThrowable(e), (HttpHeaders)new DefaultHttpHeaders());
        }
    }

    public void setCompression(String compressorName) {
        if (this.sendHeadersCalled) {
            throw new IllegalStateException("sendHeaders has been called");
        }
        this.compressor = this.compressorRegistry.lookupCompressor(compressorName);
        if (this.compressor == null) {
            throw new IllegalArgumentException("Unable to find compressor by name " + compressorName);
        }
    }

    public void setMessageCompression(boolean enable) {
        this.outboundMessage.setMessageCompression(enable);
    }

    public boolean isReady() {
        return this.outboundMessage.isReady();
    }

    public void close(Status status, HttpHeaders trailers) {
        if (this.closeCalled) {
            throw new ServerRuntimeException("call already closed");
        }
        this.closeCalled = true;
        if (status.isOk() && this.method.getType().serverSendsOneMessage() && !this.messageSent) {
            this.outboundMessage.complete(Status.Code.INTERNAL.toStatus().withDescription(MISSING_RESPONSE), (HttpHeaders)new DefaultHttpHeaders());
            return;
        }
        this.outboundMessage.complete(status, trailers);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    ServerStreamListener newServerStreamListener(ServerCallHandler.Listener listener) {
        return new ServerStreamListener(this, listener);
    }

    public MethodDescriptor getMethodDescriptor() {
        return this.method;
    }

    public static final class ServerStreamListener
    implements StreamListener {
        private final ServerCall call;
        private final ServerCallHandler.Listener listener;

        ServerStreamListener(ServerCall call, ServerCallHandler.Listener listener) {
            this.call = call;
            this.listener = listener;
        }

        @Override
        public void messagesAvailable(InputStream message) {
            if (this.call.cancelled) {
                MessageUtils.closeQuietly(message);
                return;
            }
            try {
                Message request = this.call.method.parseRequest(message);
                request.setHeaders(this.call.inboundMessage.getHeaders());
                this.listener.onMessage(request);
            }
            catch (Exception ex) {
                MessageUtils.closeQuietly(message);
                throw new ServerRuntimeException(ex);
            }
            finally {
                try {
                    message.close();
                }
                catch (IOException iOException) {}
            }
        }

        public void halfClosed() {
            if (this.call.cancelled) {
                return;
            }
            this.listener.onHalfClose();
        }

        public void closed(Status status) {
            if (status.isOk()) {
                this.listener.onComplete();
            } else {
                this.call.cancelled = true;
                this.listener.onCancel();
            }
        }
    }
}

