/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.builder.components;

import com.google.protobuf.DescriptorProtos;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.MethodDescriptor;
import org.ballerinalang.net.grpc.builder.utils.BalGenerationUtils;

public class Method {
    private String methodName;
    private String methodId;
    private String inputType;
    private String outputType;
    private MethodDescriptor.MethodType methodType;

    private Method(String methodName, String methodId, String inputType, String outputType, MethodDescriptor.MethodType methodType) {
        this.methodName = methodName;
        this.methodType = methodType;
        this.methodId = methodId;
        this.inputType = inputType;
        this.outputType = outputType;
    }

    public static Builder newBuilder(String methodId) {
        return new Builder(methodId);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodId() {
        return this.methodId;
    }

    public String getInputType() {
        return this.inputType;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public MethodDescriptor.MethodType getMethodType() {
        return this.methodType;
    }

    public boolean containsEmptyType() {
        return this.inputType == null || this.outputType == null;
    }

    public static class Builder {
        String methodId;
        DescriptorProtos.MethodDescriptorProto methodDescriptor;

        private Builder(String methodId) {
            this.methodId = methodId;
        }

        public Builder setMethodDescriptor(DescriptorProtos.MethodDescriptorProto methodDescriptor) {
            this.methodDescriptor = methodDescriptor;
            return this;
        }

        public Method build() {
            MethodDescriptor.MethodType methodType = MessageUtils.getMethodType(this.methodDescriptor);
            String methodName = this.methodDescriptor.getName();
            String inputType = this.methodDescriptor.getInputType();
            inputType = inputType != null ? BalGenerationUtils.getMappingBalType(inputType.substring(inputType.lastIndexOf(".") + 1)) : null;
            String outputType = this.methodDescriptor.getOutputType();
            outputType = outputType != null ? BalGenerationUtils.getMappingBalType(outputType.substring(outputType.lastIndexOf(".") + 1)) : null;
            return new Method(methodName, this.methodId, inputType, outputType, methodType);
        }
    }
}

