/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.builder.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.net.grpc.builder.components.Method;
import org.ballerinalang.net.grpc.exception.BalGenerationException;

public class ServiceStub {
    private String stubType;
    private String serviceName;
    private List<Method> blockingFunctions = new ArrayList<Method>();
    private List<Method> nonBlockingFunctions = new ArrayList<Method>();
    private List<Method> streamingFunctions = new ArrayList<Method>();

    private ServiceStub(String serviceName, String stubType) {
        this.serviceName = serviceName;
        this.stubType = stubType;
    }

    public static Builder newBuilder(String serviceName) {
        return new Builder(serviceName);
    }

    public String getStubType() {
        return this.stubType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public List<Method> getBlockingFunctions() {
        return Collections.unmodifiableList(this.blockingFunctions);
    }

    public List<Method> getNonBlockingFunctions() {
        return Collections.unmodifiableList(this.nonBlockingFunctions);
    }

    public List<Method> getStreamingFunctions() {
        return Collections.unmodifiableList(this.streamingFunctions);
    }

    public static enum StubType {
        BLOCKING("blocking"),
        NONBLOCKING("non-blocking");

        private String type;

        private StubType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }

    public static class Builder {
        String serviceName;
        List<Method> methodList = new ArrayList<Method>();
        StubType stubType;

        private Builder(String serviceName) {
            this.serviceName = serviceName;
        }

        public Builder addMethod(Method method) {
            this.methodList.add(method);
            return this;
        }

        public Builder setType(StubType stubType) {
            this.stubType = stubType;
            return this;
        }

        public ServiceStub build() {
            ServiceStub serviceStub = new ServiceStub(this.serviceName, this.stubType.getType());
            block5: for (Method method : this.methodList) {
                switch (method.getMethodType()) {
                    case UNARY: {
                        if (this.stubType == StubType.BLOCKING) {
                            serviceStub.blockingFunctions.add(method);
                            continue block5;
                        }
                        serviceStub.nonBlockingFunctions.add(method);
                        continue block5;
                    }
                    case SERVER_STREAMING: {
                        serviceStub.nonBlockingFunctions.add(method);
                        continue block5;
                    }
                    case CLIENT_STREAMING: 
                    case BIDI_STREAMING: {
                        serviceStub.streamingFunctions.add(method);
                        continue block5;
                    }
                }
                throw new BalGenerationException("Method type is unknown or not supported.");
            }
            return serviceStub;
        }
    }
}

