/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.builder.utils;

import java.util.Locale;

public class BalGenerationUtils {
    public static String bytesToHex(byte[] data) {
        char[] hexChars = new char[data.length * 2];
        for (int j = 0; j < data.length; ++j) {
            int v = data[j] & 0xFF;
            hexChars[j * 2] = "0123456789ABCDEF".toCharArray()[v >>> 4];
            hexChars[j * 2 + 1] = "0123456789ABCDEF".toCharArray()[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String getMappingBalType(String protoType) {
        switch (protoType) {
            case "DoubleValue": 
            case "FloatValue": {
                return "float";
            }
            case "Int32Value": 
            case "Int64Value": 
            case "UInt64Value": 
            case "UInt32Value": {
                return "int";
            }
            case "BoolValue": {
                return "boolean";
            }
            case "StringValue": {
                return "string";
            }
            case "BytesValue": {
                return "byte[]";
            }
            case "Empty": {
                return null;
            }
        }
        return protoType;
    }

    public static String toCamelCase(String name) {
        if (name == null) {
            return null;
        }
        String[] parts = name.split("_");
        StringBuilder camelCaseString = new StringBuilder();
        for (String part : parts) {
            camelCaseString.append(part.substring(0, 1).toUpperCase(Locale.ENGLISH)).append(part.substring(1).toLowerCase(Locale.ENGLISH));
        }
        return camelCaseString.toString();
    }
}

