/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.callback;

import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.StreamObserver;
import org.ballerinalang.net.grpc.callback.AbstractCallableUnitCallBack;
import org.ballerinalang.net.grpc.exception.ServerRuntimeException;
import org.ballerinalang.net.grpc.listener.ServerCallHandler;

public class UnaryCallableUnitCallBack
extends AbstractCallableUnitCallBack {
    private StreamObserver requestSender;
    private boolean emptyResponse;

    public UnaryCallableUnitCallBack(StreamObserver requestSender, boolean isEmptyResponse) {
        if (requestSender == null) {
            throw new ServerRuntimeException("Error while initializing Streaming service callback. StreamObserver is null");
        }
        this.requestSender = requestSender;
        this.emptyResponse = isEmptyResponse;
    }

    @Override
    public void notifySuccess() {
        if (this.requestSender instanceof ServerCallHandler.ServerCallStreamObserver) {
            ServerCallHandler.ServerCallStreamObserver serverCallStreamObserver = (ServerCallHandler.ServerCallStreamObserver)this.requestSender;
            if (!serverCallStreamObserver.isReady()) {
                return;
            }
            if (serverCallStreamObserver.isCancelled()) {
                return;
            }
        }
        if (this.emptyResponse) {
            this.requestSender.onNext(new Message("Empty", null));
        }
        this.requestSender.onCompleted();
        super.notifySuccess();
    }

    @Override
    public void notifyFailure(ErrorValue error) {
        UnaryCallableUnitCallBack.handleFailure(this.requestSender, error);
        super.notifyFailure(error);
    }
}

