/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.calleraction;

import io.netty.handler.codec.http.HttpHeaders;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.bre.bvm.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.StreamObserver;
import org.ballerinalang.net.grpc.exception.StatusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="sendError", receiver=@Receiver(type=TypeKind.OBJECT, structType="Caller", structPackage="ballerina/grpc"), isPublic=true)
public class SendError
extends BlockingNativeCallableUnit {
    private static final Logger LOG = LoggerFactory.getLogger(SendError.class);

    public void execute(Context context) {
    }

    public static Object sendError(Strand strand, ObjectValue endpointClient, long statusCode, String errorMsg, ObjectValue headerValues) {
        StreamObserver responseObserver = MessageUtils.getResponseObserver(endpointClient);
        if (responseObserver == null) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while sending the error. Response observer not found.")));
        }
        try {
            HttpHeaders headers = null;
            Message errorMessage = new Message(new StatusRuntimeException(Status.fromCodeValue((int)statusCode).withDescription(errorMsg)));
            if (headerValues != null) {
                headers = (HttpHeaders)headerValues.getNativeData("MessageHeaders");
            }
            if (headers != null) {
                errorMessage.setHeaders(headers);
            }
            responseObserver.onError(errorMessage);
        }
        catch (Exception e) {
            LOG.error("Error while sending error to caller.", (Throwable)e);
            return MessageUtils.getConnectorError(e);
        }
        return null;
    }
}

