/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.client;

import java.util.Map;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.jvm.Strand;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.MethodDescriptor;
import org.ballerinalang.net.grpc.ServiceDefinition;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.exception.GrpcClientException;
import org.ballerinalang.net.grpc.exception.StatusRuntimeException;
import org.ballerinalang.net.grpc.stubs.BlockingStub;
import org.ballerinalang.net.grpc.stubs.NonBlockingStub;
import org.wso2.transport.http.netty.contract.HttpClientConnector;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="initStub", receiver=@Receiver(type=TypeKind.OBJECT, structType="Client", structPackage="ballerina/grpc"), isPublic=true)
public class InitStub
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
    }

    public static Object initStub(Strand strand, ObjectValue clientEndpoint, String stubType, String rootDescriptor, MapValue<String, Object> descriptorMap) {
        block5: {
            HttpClientConnector clientConnector = (HttpClientConnector)clientEndpoint.getNativeData("ClientConnector");
            String urlString = (String)clientEndpoint.getNativeData("url");
            if (stubType == null || rootDescriptor == null || descriptorMap == null) {
                return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while initializing connector. message descriptor keys not exist. Please check the generated sub file")));
            }
            try {
                ServiceDefinition serviceDefinition = new ServiceDefinition(rootDescriptor, descriptorMap);
                Map<String, MethodDescriptor> methodDescriptorMap = serviceDefinition.getMethodDescriptors();
                clientEndpoint.addNativeData("MethodDescriptors", methodDescriptorMap);
                if ("blocking".equalsIgnoreCase(stubType)) {
                    BlockingStub blockingStub = new BlockingStub(clientConnector, urlString);
                    clientEndpoint.addNativeData("Stub", (Object)blockingStub);
                    break block5;
                }
                if ("non-blocking".equalsIgnoreCase(stubType)) {
                    NonBlockingStub nonBlockingStub = new NonBlockingStub(clientConnector, urlString);
                    clientEndpoint.addNativeData("Stub", (Object)nonBlockingStub);
                    break block5;
                }
                return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while initializing connector. invalid connector type")));
            }
            catch (RuntimeException | GrpcClientException e) {
                return MessageUtils.getConnectorError(e);
            }
        }
        return null;
    }
}

