/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.client;

import com.google.protobuf.Descriptors;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Map;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.jvm.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MethodDescriptor;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.exception.GrpcClientException;
import org.ballerinalang.net.grpc.nativeimpl.client.AbstractExecute;
import org.ballerinalang.net.grpc.stubs.DefaultStreamObserver;
import org.ballerinalang.net.grpc.stubs.NonBlockingStub;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="nonBlockingExecute", receiver=@Receiver(type=TypeKind.OBJECT, structType="Client", structPackage="ballerina/grpc"), isPublic=true)
public class NonBlockingExecute
extends AbstractExecute {
    public void execute(Context context, CallableUnitCallback callback) {
    }

    public static Object nonBlockingExecute(Strand strand, ObjectValue clientEndpoint, String methodName, ObjectValue callbackService, Object payload, ObjectValue headerValues) {
        Descriptors.MethodDescriptor methodDescriptor;
        if (clientEndpoint == null) {
            return NonBlockingExecute.notifyErrorReply(Status.Code.INTERNAL.name(), "Error while getting connector. gRPC Client connector is not initialized properly");
        }
        Object connectionStub = clientEndpoint.getNativeData("Stub");
        if (connectionStub == null) {
            return NonBlockingExecute.notifyErrorReply(Status.Code.INTERNAL.name(), "Error while getting connection stub. gRPC Client connector is not initialized properly");
        }
        if (methodName == null) {
            return NonBlockingExecute.notifyErrorReply(Status.Code.INTERNAL.name(), "Error while processing the request. RPC endpoint doesn't set properly");
        }
        Map methodDescriptors = (Map)clientEndpoint.getNativeData("MethodDescriptors");
        if (methodDescriptors == null) {
            return NonBlockingExecute.notifyErrorReply(Status.Code.INTERNAL.name(), "Error while processing the request. method descriptors doesn't set properly");
        }
        Descriptors.MethodDescriptor methodDescriptor2 = methodDescriptor = methodDescriptors.get(methodName) != null ? ((MethodDescriptor)methodDescriptors.get(methodName)).getSchemaDescriptor() : null;
        if (methodDescriptor == null) {
            return NonBlockingExecute.notifyErrorReply(Status.Code.INTERNAL.name(), "No registered method descriptor for '" + methodName + "'");
        }
        if (connectionStub instanceof NonBlockingStub) {
            Message requestMsg = new Message(methodDescriptor.getInputType().getName(), payload);
            HttpHeaders headers = null;
            if (headerValues != null) {
                headers = (HttpHeaders)headerValues.getNativeData("MessageHeaders");
            }
            if (headers != null) {
                requestMsg.setHeaders(headers);
            }
            NonBlockingStub nonBlockingStub = (NonBlockingStub)connectionStub;
            try {
                MethodDescriptor.MethodType methodType = NonBlockingExecute.getMethodType(methodDescriptor);
                if (methodType.equals((Object)MethodDescriptor.MethodType.UNARY)) {
                    nonBlockingStub.executeUnary(requestMsg, new DefaultStreamObserver(callbackService), (MethodDescriptor)methodDescriptors.get(methodName));
                } else if (methodType.equals((Object)MethodDescriptor.MethodType.SERVER_STREAMING)) {
                    nonBlockingStub.executeServerStreaming(requestMsg, new DefaultStreamObserver(callbackService), (MethodDescriptor)methodDescriptors.get(methodName));
                } else {
                    return NonBlockingExecute.notifyErrorReply(Status.Code.INTERNAL.name(), "Error while executing the client call. Method type " + methodType.name() + " not supported");
                }
                return null;
            }
            catch (RuntimeException | GrpcClientException e) {
                return NonBlockingExecute.notifyErrorReply(Status.Code.INTERNAL.name(), "gRPC Client Connector Error :" + e.getMessage());
            }
        }
        return NonBlockingExecute.notifyErrorReply(Status.Code.INTERNAL.name(), "Error while processing the request message. Connection Sub type not supported");
    }

    public boolean isBlocking() {
        return false;
    }
}

