/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.streamingclient;

import com.google.protobuf.Descriptors;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.bre.bvm.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.StreamObserver;
import org.ballerinalang.net.grpc.exception.StatusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="send", receiver=@Receiver(type=TypeKind.OBJECT, structType="StreamingClient", structPackage="ballerina/grpc"), isPublic=true)
public class Send
extends BlockingNativeCallableUnit {
    private static final Logger LOG = LoggerFactory.getLogger(Send.class);

    public void execute(Context context) {
    }

    public static Object send(Strand strand, ObjectValue streamConnection, Object responseValue) {
        StreamObserver requestSender = (StreamObserver)streamConnection.getNativeData("REQUEST_SENDER");
        if (requestSender == null) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while sending the message. endpoint does not exist")));
        }
        Descriptors.Descriptor inputType = (Descriptors.Descriptor)streamConnection.getNativeData("REQUEST_DEFINITION");
        try {
            Message requestMessage = new Message(inputType.getName(), responseValue);
            requestSender.onNext(requestMessage);
        }
        catch (Exception e) {
            LOG.error("Error while sending request message to server.", (Throwable)e);
            return MessageUtils.getConnectorError(e);
        }
        return null;
    }
}

