/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.proto.definition;

import com.google.protobuf.DescriptorProtos;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.net.grpc.exception.GrpcServerException;
import org.ballerinalang.net.grpc.proto.ServiceProtoConstants;
import org.ballerinalang.net.grpc.proto.definition.EnumField;
import org.ballerinalang.net.grpc.proto.definition.Message;
import org.ballerinalang.net.grpc.proto.definition.MessageKind;

public class UserDefinedEnumMessage
extends Message {
    List<EnumField> fieldList = new ArrayList<EnumField>();
    private DescriptorProtos.EnumDescriptorProto descriptorProto;

    public DescriptorProtos.EnumDescriptorProto getDescriptorProto() {
        return this.descriptorProto;
    }

    @Override
    public MessageKind getMessageKind() {
        return MessageKind.USER_DEFINED;
    }

    private UserDefinedEnumMessage(DescriptorProtos.EnumDescriptorProto descriptorProto) {
        this.descriptorProto = descriptorProto;
        this.messageName = descriptorProto.getName();
    }

    public static Builder newBuilder(String messageType) throws GrpcServerException {
        if (messageType == null) {
            throw new GrpcServerException("Error while initializing the builder, message type cannot be null");
        }
        String name = messageType.contains(":") ? messageType.replace(':', '.') : messageType;
        return new Builder(name);
    }

    @Override
    public String getMessageDefinition() {
        StringBuilder msgDefinition = new StringBuilder();
        msgDefinition.append("enum ").append(this.messageName).append(" {").append(ServiceProtoConstants.NEW_LINE_CHARACTER);
        for (EnumField field : this.fieldList) {
            msgDefinition.append("\t").append(field.getFieldDefinition());
        }
        msgDefinition.append("}").append(ServiceProtoConstants.NEW_LINE_CHARACTER);
        return msgDefinition.toString();
    }

    public static class Builder {
        private DescriptorProtos.EnumDescriptorProto.Builder messageDescriptorBuilder;
        private List<EnumField> fieldList = new ArrayList<EnumField>();

        public UserDefinedEnumMessage build() {
            UserDefinedEnumMessage message = new UserDefinedEnumMessage(this.messageDescriptorBuilder.build());
            message.fieldList = this.fieldList;
            return message;
        }

        private Builder(String messageName) {
            this.messageDescriptorBuilder = DescriptorProtos.EnumDescriptorProto.newBuilder();
            this.messageDescriptorBuilder.setName(messageName);
        }

        public Builder addFieldDefinition(EnumField fieldDefinition) {
            this.fieldList.add(fieldDefinition);
            this.messageDescriptorBuilder.addValue(fieldDefinition.getFieldDescriptorProto());
            return this;
        }
    }
}

