/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.stubs;

import io.netty.handler.codec.http.HttpHeaders;
import java.util.Arrays;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.BTupleType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.grpc.ClientCall;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.MethodDescriptor;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.stubs.AbstractStub;
import org.ballerinalang.net.http.DataContext;
import org.wso2.transport.http.netty.contract.HttpClientConnector;

public class BlockingStub
extends AbstractStub {
    public BlockingStub(HttpClientConnector clientConnector, String url) {
        super(clientConnector, url);
    }

    public void executeUnary(Message request, MethodDescriptor methodDescriptor, DataContext dataContext) {
        ClientCall call = new ClientCall(this.getConnector(), this.createOutboundRequest(request.getHeaders()), methodDescriptor);
        call.start(new CallBlockingListener(dataContext));
        try {
            call.sendMessage(request);
            call.halfClose();
        }
        catch (Exception e) {
            throw BlockingStub.cancelThrow(call, e);
        }
    }

    private static final class CallBlockingListener
    implements AbstractStub.Listener {
        private final DataContext dataContext;
        private Message value;

        private CallBlockingListener(DataContext dataContext) {
            this.dataContext = dataContext;
        }

        @Override
        public void onHeaders(HttpHeaders headers) {
        }

        @Override
        public void onMessage(Message value) {
            if (this.value != null) {
                throw Status.Code.INTERNAL.toStatus().withDescription("More than one value received for unary call").asRuntimeException();
            }
            this.value = value;
        }

        @Override
        public void onClose(Status status, HttpHeaders trailers) {
            ErrorValue httpConnectorError = null;
            ArrayValue inboundResponse = null;
            if (status.isOk()) {
                if (this.value == null) {
                    httpConnectorError = MessageUtils.getConnectorError(Status.Code.INTERNAL.toStatus().withDescription("No value received for unary call").asRuntimeException());
                } else {
                    Object responseBValue = this.value.getbMessage();
                    ObjectValue headerObject = BallerinaValues.createObjectValue((String)"ballerina/grpc", (String)"Headers", (Object[])new Object[0]);
                    headerObject.addNativeData("MessageHeaders", (Object)this.value.getHeaders());
                    ArrayValue contentTuple = new ArrayValue((BType)new BTupleType(Arrays.asList(BTypes.typeAny, headerObject.getType())));
                    contentTuple.add(0L, responseBValue);
                    contentTuple.add(1L, (Object)headerObject);
                    inboundResponse = contentTuple;
                }
            } else {
                httpConnectorError = MessageUtils.getConnectorError(status.asRuntimeException());
            }
            if (inboundResponse != null) {
                this.dataContext.getCallback().setReturnValues(inboundResponse);
            } else {
                this.dataContext.getCallback().setReturnValues((Object)httpConnectorError);
            }
            this.dataContext.getCallback().notifySuccess();
        }
    }
}

