/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.launcher;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import java.util.Arrays;
import java.util.List;

public interface BLauncherCmd {
    public void execute();

    public String getName();

    public void printLongDesc(StringBuilder var1);

    public void printUsage(StringBuilder var1);

    public void setParentCmdParser(JCommander var1);

    public void setSelfCmdParser(JCommander var1);

    public static String getCommandUsageInfo(JCommander cmdParser, String commandName) {
        StringBuilder out = new StringBuilder();
        JCommander jCommander = (JCommander)cmdParser.getCommands().get(commandName);
        BLauncherCmd bLauncherCmd = (BLauncherCmd)jCommander.getObjects().get(0);
        bLauncherCmd.printLongDesc(out);
        out.append("\n");
        out.append("Usage:\n");
        bLauncherCmd.printUsage(out);
        out.append("\n");
        if (jCommander.getCommands().values().size() != 0) {
            out.append("Available Commands:\n");
            BLauncherCmd.printCommandList(jCommander, out);
            out.append("\n");
        }
        BLauncherCmd.printFlags(jCommander.getParameters(), out);
        return out.toString();
    }

    public static void printCommandList(JCommander cmdParser, StringBuilder out) {
        BLauncherCmd cmd;
        int longestNameLen = 0;
        for (JCommander commander : cmdParser.getCommands().values()) {
            int length;
            cmd = (BLauncherCmd)commander.getObjects().get(0);
            if (cmd.getName().equals("default-cmd") || cmd.getName().equals("help") || (length = cmd.getName().length() + 2) <= longestNameLen) continue;
            longestNameLen = length;
        }
        for (JCommander commander : cmdParser.getCommands().values()) {
            cmd = (BLauncherCmd)commander.getObjects().get(0);
            if (cmd.getName().equals("default-cmd") || cmd.getName().equals("help")) continue;
            String cmdName = cmd.getName();
            String cmdDesc = cmdParser.getCommandDescription(cmdName);
            int noOfSpaces = longestNameLen - (cmd.getName().length() + 2);
            char[] charArray = new char[noOfSpaces + 4];
            Arrays.fill(charArray, ' ');
            out.append("  ").append(cmdName).append(new String(charArray)).append(cmdDesc).append("\n");
        }
    }

    public static void printFlags(List<ParameterDescription> paramDescs, StringBuilder out) {
        String names;
        int longestNameLen = 0;
        int count = 0;
        for (ParameterDescription parameterDesc : paramDescs) {
            if (parameterDesc.getParameter().hidden()) continue;
            names = parameterDesc.getNames();
            int length = names.length() + 2;
            if (length > longestNameLen) {
                longestNameLen = length;
            }
            ++count;
        }
        if (count == 0) {
            return;
        }
        out.append("Flags:\n");
        for (ParameterDescription parameterDesc : paramDescs) {
            if (parameterDesc.getParameter().hidden()) continue;
            names = parameterDesc.getNames();
            String desc = parameterDesc.getDescription();
            int noOfSpaces = longestNameLen - (names.length() + 2);
            char[] charArray = new char[noOfSpaces + 4];
            Arrays.fill(charArray, ' ');
            out.append("  ").append(names).append(new String(charArray)).append(desc).append("\n");
        }
    }
}

